/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.overlord.supervisor;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.druid.indexing.overlord.DataSourceMetadata;
import org.apache.druid.indexing.overlord.supervisor.SupervisorReport;
import org.apache.druid.indexing.overlord.supervisor.SupervisorSpec;
import org.apache.druid.indexing.overlord.supervisor.SupervisorStateManager;
import org.apache.druid.indexing.overlord.supervisor.autoscaler.SupervisorTaskAutoScaler;
import org.apache.druid.segment.incremental.ParseExceptionReport;

public interface Supervisor {
    public void start();

    public void stop(boolean var1);

    default public ListenableFuture<Void> stopAsync() {
        SettableFuture stopFuture = SettableFuture.create();
        try {
            this.stop(false);
            stopFuture.set(null);
        }
        catch (Exception e) {
            stopFuture.setException((Throwable)e);
        }
        return stopFuture;
    }

    public SupervisorReport getStatus();

    public SupervisorStateManager.State getState();

    default public Map<String, Map<String, Object>> getStats() {
        return ImmutableMap.of();
    }

    default public List<ParseExceptionReport> getParseErrors() {
        return ImmutableList.of();
    }

    @Nullable
    default public Boolean isHealthy() {
        return null;
    }

    default public SupervisorTaskAutoScaler createAutoscaler(SupervisorSpec spec) {
        return spec.createAutoscaler(this);
    }

    public void reset(@Nullable DataSourceMetadata var1);
}

