/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.client;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.util.Set;
import org.apache.druid.server.coordination.DruidServerMetadata;
import org.apache.druid.timeline.DataSegment;

public class ImmutableSegmentLoadInfo {
    private final DataSegment segment;
    private final ImmutableSet<DruidServerMetadata> servers;

    @JsonCreator
    public ImmutableSegmentLoadInfo(@JsonProperty(value="segment") DataSegment segment, @JsonProperty(value="servers") Set<DruidServerMetadata> servers) {
        Preconditions.checkNotNull((Object)segment, (Object)"segment");
        Preconditions.checkNotNull(servers, (Object)"servers");
        this.segment = segment;
        this.servers = ImmutableSet.copyOf(servers);
    }

    @JsonProperty(value="segment")
    public DataSegment getSegment() {
        return this.segment;
    }

    @JsonProperty(value="servers")
    public ImmutableSet<DruidServerMetadata> getServers() {
        return this.servers;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ImmutableSegmentLoadInfo that = (ImmutableSegmentLoadInfo)o;
        if (!this.segment.equals((Object)that.segment)) {
            return false;
        }
        return this.servers.equals(that.servers);
    }

    public int hashCode() {
        int result = this.segment.hashCode();
        result = 31 * result + this.servers.hashCode();
        return result;
    }

    public String toString() {
        return "SegmentLoadInfo{segment=" + String.valueOf(this.segment) + ", servers=" + String.valueOf(this.servers) + "}";
    }
}

