/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.coordinator;

import com.google.inject.Inject;
import org.apache.druid.audit.AuditManager;
import org.apache.druid.indexing.overlord.IndexerMetadataStorageCoordinator;
import org.apache.druid.metadata.MetadataRuleManager;
import org.apache.druid.metadata.MetadataSupervisorManager;
import org.apache.druid.metadata.SegmentsMetadataManager;
import org.apache.druid.segment.metadata.SegmentSchemaManager;
import org.apache.druid.server.coordinator.CoordinatorConfigManager;

public class MetadataManager {
    private final AuditManager auditManager;
    private final CoordinatorConfigManager configManager;
    private final SegmentsMetadataManager segmentsMetadataManager;
    private final MetadataSupervisorManager metadataSupervisorManager;
    private final MetadataRuleManager metadataRuleManager;
    private final IndexerMetadataStorageCoordinator storageCoordinator;
    private final SegmentSchemaManager segmentSchemaManager;

    @Inject
    public MetadataManager(AuditManager auditManager, CoordinatorConfigManager configManager, SegmentsMetadataManager segmentsMetadataManager, MetadataSupervisorManager metadataSupervisorManager, MetadataRuleManager metadataRuleManager, IndexerMetadataStorageCoordinator storageCoordinator, SegmentSchemaManager segmentSchemaManager) {
        this.auditManager = auditManager;
        this.configManager = configManager;
        this.segmentsMetadataManager = segmentsMetadataManager;
        this.metadataSupervisorManager = metadataSupervisorManager;
        this.metadataRuleManager = metadataRuleManager;
        this.storageCoordinator = storageCoordinator;
        this.segmentSchemaManager = segmentSchemaManager;
    }

    public void onLeaderStart() {
        this.segmentsMetadataManager.startPollingDatabasePeriodically();
        this.segmentsMetadataManager.populateUsedFlagLastUpdatedAsync();
        this.metadataRuleManager.start();
    }

    public void onLeaderStop() {
        this.metadataRuleManager.stop();
        this.segmentsMetadataManager.stopPollingDatabasePeriodically();
        this.segmentsMetadataManager.stopAsyncUsedFlagLastUpdatedUpdate();
    }

    public boolean isStarted() {
        return this.segmentsMetadataManager.isPollingDatabasePeriodically();
    }

    public AuditManager audit() {
        return this.auditManager;
    }

    public CoordinatorConfigManager configs() {
        return this.configManager;
    }

    public MetadataSupervisorManager supervisors() {
        return this.metadataSupervisorManager;
    }

    public MetadataRuleManager rules() {
        return this.metadataRuleManager;
    }

    public SegmentsMetadataManager segments() {
        return this.segmentsMetadataManager;
    }

    public IndexerMetadataStorageCoordinator indexer() {
        return this.storageCoordinator;
    }

    public SegmentSchemaManager schemas() {
        return this.segmentSchemaManager;
    }
}

