/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.coordinator;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Set;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.server.coordinator.ServerHolder;
import org.apache.druid.utils.CollectionUtils;

public class DruidCluster {
    public static final DruidCluster EMPTY = DruidCluster.builder().build();
    private final Set<ServerHolder> realtimes;
    private final Map<String, NavigableSet<ServerHolder>> historicals;
    private final Set<ServerHolder> brokers;
    private final List<ServerHolder> allServers;

    private DruidCluster(Set<ServerHolder> realtimes, Map<String, Set<ServerHolder>> historicals, Set<ServerHolder> brokers) {
        this.realtimes = Collections.unmodifiableSet(realtimes);
        this.historicals = CollectionUtils.mapValues(historicals, holders -> CollectionUtils.newTreeSet(Comparator.naturalOrder(), (Iterable)holders));
        this.brokers = Collections.unmodifiableSet(brokers);
        this.allServers = this.initAllServers();
    }

    public Set<ServerHolder> getRealtimes() {
        return this.realtimes;
    }

    public Map<String, NavigableSet<ServerHolder>> getHistoricals() {
        return this.historicals;
    }

    public Set<ServerHolder> getBrokers() {
        return this.brokers;
    }

    public Iterable<String> getTierNames() {
        return this.historicals.keySet();
    }

    public NavigableSet<ServerHolder> getHistoricalsByTier(String tier) {
        return this.historicals.get(tier);
    }

    public List<ServerHolder> getAllServers() {
        return this.allServers;
    }

    private List<ServerHolder> initAllServers() {
        int historicalSize = this.historicals.values().stream().mapToInt(Collection::size).sum();
        int realtimeSize = this.realtimes.size();
        ArrayList<ServerHolder> allServers = new ArrayList<ServerHolder>(historicalSize + realtimeSize);
        this.historicals.values().forEach(allServers::addAll);
        allServers.addAll(this.brokers);
        allServers.addAll(this.realtimes);
        return allServers;
    }

    public boolean isEmpty() {
        return this.historicals.isEmpty() && this.realtimes.isEmpty() && this.brokers.isEmpty();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private final Set<ServerHolder> realtimes = new HashSet<ServerHolder>();
        private final Map<String, Set<ServerHolder>> historicals = new HashMap<String, Set<ServerHolder>>();
        private final Set<ServerHolder> brokers = new HashSet<ServerHolder>();

        public Builder add(ServerHolder serverHolder) {
            switch (serverHolder.getServer().getType()) {
                case BRIDGE: 
                case HISTORICAL: {
                    this.addHistorical(serverHolder);
                    break;
                }
                case REALTIME: 
                case INDEXER_EXECUTOR: {
                    this.realtimes.add(serverHolder);
                    break;
                }
                case BROKER: {
                    this.brokers.add(serverHolder);
                    break;
                }
                default: {
                    throw new IAE("unknown server type[%s]", new Object[]{serverHolder.getServer().getType()});
                }
            }
            return this;
        }

        public Builder addRealtimes(ServerHolder ... realtimeServers) {
            this.realtimes.addAll(Arrays.asList(realtimeServers));
            return this;
        }

        public Builder addBrokers(ServerHolder ... brokers) {
            this.brokers.addAll(Arrays.asList(brokers));
            return this;
        }

        public Builder addTier(String tier, ServerHolder ... historicals) {
            this.historicals.computeIfAbsent(tier, t -> new HashSet()).addAll(Arrays.asList(historicals));
            return this;
        }

        private void addHistorical(ServerHolder serverHolder) {
            String tier = serverHolder.getServer().getTier();
            this.historicals.computeIfAbsent(tier, t -> new HashSet()).add(serverHolder);
        }

        public DruidCluster build() {
            return new DruidCluster(this.realtimes, this.historicals, this.brokers);
        }
    }
}

