/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.metadata;

import com.google.common.base.Joiner;
import com.google.common.base.Predicate;
import com.google.common.base.Supplier;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLRecoverableException;
import java.sql.SQLTransientException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.commons.dbcp2.BasicDataSource;
import org.apache.commons.dbcp2.BasicDataSourceFactory;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.RetryUtils;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.metadata.BasicDataSourceExt;
import org.apache.druid.metadata.MetadataCASUpdate;
import org.apache.druid.metadata.MetadataStorageConnector;
import org.apache.druid.metadata.MetadataStorageConnectorConfig;
import org.apache.druid.metadata.MetadataStorageTablesConfig;
import org.apache.druid.metadata.RetryTransactionException;
import org.apache.druid.segment.metadata.CentralizedDatasourceSchemaConfig;
import org.skife.jdbi.v2.Batch;
import org.skife.jdbi.v2.DBI;
import org.skife.jdbi.v2.Handle;
import org.skife.jdbi.v2.Query;
import org.skife.jdbi.v2.TransactionCallback;
import org.skife.jdbi.v2.TransactionIsolationLevel;
import org.skife.jdbi.v2.TransactionStatus;
import org.skife.jdbi.v2.Update;
import org.skife.jdbi.v2.exceptions.DBIException;
import org.skife.jdbi.v2.exceptions.UnableToExecuteStatementException;
import org.skife.jdbi.v2.exceptions.UnableToObtainConnectionException;
import org.skife.jdbi.v2.tweak.HandleCallback;
import org.skife.jdbi.v2.tweak.ResultSetMapper;
import org.skife.jdbi.v2.util.ByteArrayMapper;
import org.skife.jdbi.v2.util.IntegerMapper;

public abstract class SQLMetadataConnector
implements MetadataStorageConnector {
    private static final Logger log = new Logger(SQLMetadataConnector.class);
    private static final String PAYLOAD_TYPE = "BLOB";
    private static final String COLLATION = "";
    static final int QUIET_RETRIES = 2;
    static final int DEFAULT_MAX_TRIES = 3;
    private final Supplier<MetadataStorageConnectorConfig> config;
    private final Supplier<MetadataStorageTablesConfig> tablesConfigSupplier;
    private final Predicate<Throwable> shouldRetry;
    private final CentralizedDatasourceSchemaConfig centralizedDatasourceSchemaConfig;

    public SQLMetadataConnector(Supplier<MetadataStorageConnectorConfig> config, Supplier<MetadataStorageTablesConfig> tablesConfigSupplier, CentralizedDatasourceSchemaConfig centralizedDatasourceSchemaConfig) {
        this.config = config;
        this.tablesConfigSupplier = tablesConfigSupplier;
        this.shouldRetry = this::isTransientException;
        this.centralizedDatasourceSchemaConfig = centralizedDatasourceSchemaConfig;
    }

    public String getPayloadType() {
        return PAYLOAD_TYPE;
    }

    public String getCollation() {
        return COLLATION;
    }

    public abstract String getSerialType();

    public abstract int getStreamingFetchSize();

    public abstract String getQuoteString();

    public String getValidationQuery() {
        return "SELECT 1";
    }

    public abstract boolean tableExists(Handle var1, String var2);

    public abstract String limitClause(int var1);

    public <T> T retryWithHandle(HandleCallback<T> callback, Predicate<Throwable> myShouldRetry) {
        try {
            return (T)RetryUtils.retry(() -> this.getDBI().withHandle(callback), myShouldRetry, null, (int)3, (String)"Metadata transaction failed");
        }
        catch (Exception e) {
            Throwables.propagateIfPossible((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public <T> T retryWithHandle(HandleCallback<T> callback) {
        return this.retryWithHandle(callback, this.shouldRetry);
    }

    public <T> T retryTransaction(TransactionCallback<T> callback, int quietTries, int maxTries) {
        try {
            return (T)RetryUtils.retry(() -> this.getDBI().inTransaction(TransactionIsolationLevel.READ_COMMITTED, callback), this.shouldRetry, (int)quietTries, (int)maxTries, null, (String)"Metadata write transaction failed");
        }
        catch (Exception e) {
            Throwables.propagateIfPossible((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public final boolean isTransientException(Throwable e) {
        return e != null && (e instanceof RetryTransactionException || e instanceof SQLTransientException || e instanceof SQLRecoverableException || e instanceof UnableToObtainConnectionException || e instanceof UnableToExecuteStatementException && this.isTransientException(e.getCause()) || this.connectorIsTransientException(e) || e instanceof SQLException && this.isTransientException(e.getCause()) || e instanceof DBIException && this.isTransientException(e.getCause()));
    }

    protected boolean connectorIsTransientException(Throwable e) {
        return false;
    }

    protected boolean isRootCausePacketTooBigException(Throwable t) {
        return false;
    }

    public void createTable(String tableName, Iterable<String> sql) {
        try {
            this.retryWithHandle(handle -> {
                if (this.tableExists(handle, tableName)) {
                    log.info("Table[%s] already exists", new Object[]{tableName});
                } else {
                    log.info("Creating table[%s]", new Object[]{tableName});
                    Batch batch = handle.createBatch();
                    for (String s : sql) {
                        batch.add(s);
                    }
                    batch.execute();
                }
                return null;
            });
        }
        catch (Exception e) {
            log.warn((Throwable)e, "Exception creating table", new Object[0]);
        }
    }

    private void alterTable(String tableName, Iterable<String> sql) {
        try {
            this.retryWithHandle(handle -> {
                if (this.tableExists(handle, tableName)) {
                    Batch batch = handle.createBatch();
                    for (String s : sql) {
                        log.info("Altering table[%s], with command: %s", new Object[]{tableName, s});
                        batch.add(s);
                    }
                    batch.execute();
                } else {
                    log.info("Table[%s] doesn't exist.", new Object[]{tableName});
                }
                return null;
            });
        }
        catch (Exception e) {
            log.warn((Throwable)e, "Exception Altering table[%s]", new Object[]{tableName});
        }
    }

    public void createPendingSegmentsTable(String tableName) {
        this.createTable(tableName, (Iterable<String>)ImmutableList.of((Object)StringUtils.format((String)"CREATE TABLE %1$s (\n  id VARCHAR(255) NOT NULL,\n  dataSource VARCHAR(255) %4$s NOT NULL,\n  created_date VARCHAR(255) NOT NULL,\n  start VARCHAR(255) NOT NULL,\n  %3$send%3$s VARCHAR(255) NOT NULL,\n  sequence_name VARCHAR(255) NOT NULL,\n  sequence_prev_id VARCHAR(255) NOT NULL,\n  sequence_name_prev_id_sha1 VARCHAR(255) NOT NULL,\n  payload %2$s NOT NULL,\n  PRIMARY KEY (id),\n  UNIQUE (sequence_name_prev_id_sha1)\n)", (Object[])new Object[]{tableName, this.getPayloadType(), this.getQuoteString(), this.getCollation()}), (Object)StringUtils.format((String)"CREATE INDEX idx_%1$s_datasource_end ON %1$s(dataSource, %2$send%2$s)", (Object[])new Object[]{tableName, this.getQuoteString()}), (Object)StringUtils.format((String)"CREATE INDEX idx_%1$s_datasource_sequence ON %1$s(dataSource, sequence_name)", (Object[])new Object[]{tableName})));
        this.alterPendingSegmentsTable(tableName);
    }

    public void createDataSourceTable(String tableName) {
        this.createTable(tableName, (Iterable<String>)ImmutableList.of((Object)StringUtils.format((String)"CREATE TABLE %1$s (\n  dataSource VARCHAR(255) %3$s NOT NULL,\n  created_date VARCHAR(255) NOT NULL,\n  commit_metadata_payload %2$s NOT NULL,\n  commit_metadata_sha1 VARCHAR(255) NOT NULL,\n  PRIMARY KEY (dataSource)\n)", (Object[])new Object[]{tableName, this.getPayloadType(), this.getCollation()})));
    }

    public void createSegmentTable(String tableName) {
        ArrayList<String> columns = new ArrayList<String>();
        columns.add("id VARCHAR(255) NOT NULL");
        columns.add("dataSource VARCHAR(255) %4$s NOT NULL");
        columns.add("created_date VARCHAR(255) NOT NULL");
        columns.add("start VARCHAR(255) NOT NULL");
        columns.add("%3$send%3$s VARCHAR(255) NOT NULL");
        columns.add("partitioned BOOLEAN NOT NULL");
        columns.add("version VARCHAR(255) NOT NULL");
        columns.add("used BOOLEAN NOT NULL");
        columns.add("payload %2$s NOT NULL");
        columns.add("used_status_last_updated VARCHAR(255) NOT NULL");
        if (this.centralizedDatasourceSchemaConfig.isEnabled()) {
            columns.add("schema_fingerprint VARCHAR(255)");
            columns.add("num_rows BIGINT");
        }
        StringBuilder createStatementBuilder = new StringBuilder("CREATE TABLE %1$s (");
        for (String column : columns) {
            createStatementBuilder.append(column);
            createStatementBuilder.append(",\n");
        }
        createStatementBuilder.append("PRIMARY KEY (id)\n)");
        this.createTable(tableName, (Iterable<String>)ImmutableList.of((Object)StringUtils.format((String)createStatementBuilder.toString(), (Object[])new Object[]{tableName, this.getPayloadType(), this.getQuoteString(), this.getCollation()}), (Object)StringUtils.format((String)"CREATE INDEX idx_%1$s_used ON %1$s(used)", (Object[])new Object[]{tableName}), (Object)StringUtils.format((String)"CREATE INDEX idx_%1$s_datasource_used_end_start ON %1$s(dataSource, used, %2$send%2$s, start)", (Object[])new Object[]{tableName, this.getQuoteString()})));
    }

    private void createUpgradeSegmentsTable(String tableName) {
        this.createTable(tableName, (Iterable<String>)ImmutableList.of((Object)StringUtils.format((String)"CREATE TABLE %1$s (\n  id %2$s NOT NULL,\n  task_id VARCHAR(255) NOT NULL,\n  segment_id VARCHAR(255) NOT NULL,\n  lock_version VARCHAR(255) NOT NULL,\n  PRIMARY KEY (id)\n)", (Object[])new Object[]{tableName, this.getSerialType()}), (Object)StringUtils.format((String)"CREATE INDEX idx_%1$s_task ON %1$s(task_id)", (Object[])new Object[]{tableName})));
    }

    public void createRulesTable(String tableName) {
        this.createTable(tableName, (Iterable<String>)ImmutableList.of((Object)StringUtils.format((String)"CREATE TABLE %1$s (\n  id VARCHAR(255) NOT NULL,\n  dataSource VARCHAR(255) %3$s NOT NULL,\n  version VARCHAR(255) NOT NULL,\n  payload %2$s NOT NULL,\n  PRIMARY KEY (id)\n)", (Object[])new Object[]{tableName, this.getPayloadType(), this.getCollation()}), (Object)StringUtils.format((String)"CREATE INDEX idx_%1$s_datasource ON %1$s(dataSource)", (Object[])new Object[]{tableName})));
    }

    public void createConfigTable(String tableName) {
        this.createTable(tableName, (Iterable<String>)ImmutableList.of((Object)StringUtils.format((String)"CREATE TABLE %1$s (\n  name VARCHAR(255) NOT NULL,\n  payload %2$s NOT NULL,\n  PRIMARY KEY(name)\n)", (Object[])new Object[]{tableName, this.getPayloadType()})));
    }

    public void prepareTaskEntryTable(String tableName) {
        this.createEntryTable(tableName);
        this.alterEntryTableAddTypeAndGroupId(tableName);
    }

    public void createEntryTable(String tableName) {
        this.createTable(tableName, (Iterable<String>)ImmutableList.of((Object)StringUtils.format((String)"CREATE TABLE %1$s (\n  id VARCHAR(255) NOT NULL,\n  created_date VARCHAR(255) NOT NULL,\n  datasource VARCHAR(255) %3$s NOT NULL,\n  payload %2$s NOT NULL,\n  status_payload %2$s NOT NULL,\n  active BOOLEAN NOT NULL DEFAULT FALSE,\n  PRIMARY KEY (id)\n)", (Object[])new Object[]{tableName, this.getPayloadType(), this.getCollation()})));
        Set<String> createdIndexSet = this.getIndexOnTable(tableName);
        this.createIndex(tableName, StringUtils.format((String)"idx_%1$s_active_created_date", (Object[])new Object[]{tableName}), (List<String>)ImmutableList.of((Object)"active", (Object)"created_date"), createdIndexSet);
        this.createIndex(tableName, StringUtils.format((String)"idx_%1$s_datasource_active", (Object[])new Object[]{tableName}), (List<String>)ImmutableList.of((Object)"datasource", (Object)"active"), createdIndexSet);
    }

    private void alterEntryTableAddTypeAndGroupId(String tableName) {
        ArrayList<String> statements = new ArrayList<String>();
        if (this.tableHasColumn(tableName, "type")) {
            log.info("Table[%s] already has column[type].", new Object[]{tableName});
        } else {
            log.info("Adding column[type] to table[%s].", new Object[]{tableName});
            statements.add(StringUtils.format((String)"ALTER TABLE %1$s ADD COLUMN type VARCHAR(255)", (Object[])new Object[]{tableName}));
        }
        if (this.tableHasColumn(tableName, "group_id")) {
            log.info("Table[%s] already has column[group_id].", new Object[]{tableName});
        } else {
            log.info("Adding column[group_id] to table[%s].", new Object[]{tableName});
            statements.add(StringUtils.format((String)"ALTER TABLE %1$s ADD COLUMN group_id VARCHAR(255)", (Object[])new Object[]{tableName}));
        }
        if (!statements.isEmpty()) {
            this.alterTable(tableName, statements);
        }
    }

    private void alterPendingSegmentsTable(String tableName) {
        ArrayList<String> statements = new ArrayList<String>();
        if (this.tableHasColumn(tableName, "upgraded_from_segment_id")) {
            log.info("Table[%s] already has column[upgraded_from_segment_id].", new Object[]{tableName});
        } else {
            log.info("Adding column[upgraded_from_segment_id] to table[%s].", new Object[]{tableName});
            statements.add(StringUtils.format((String)"ALTER TABLE %1$s ADD COLUMN upgraded_from_segment_id VARCHAR(255)", (Object[])new Object[]{tableName}));
        }
        if (this.tableHasColumn(tableName, "task_allocator_id")) {
            log.info("Table[%s] already has column[task_allocator_id].", new Object[]{tableName});
        } else {
            log.info("Adding column[task_allocator_id] to table[%s].", new Object[]{tableName});
            statements.add(StringUtils.format((String)"ALTER TABLE %1$s ADD COLUMN task_allocator_id VARCHAR(255)", (Object[])new Object[]{tableName}));
        }
        if (!statements.isEmpty()) {
            this.alterTable(tableName, statements);
        }
        Set<String> createdIndexSet = this.getIndexOnTable(tableName);
        this.createIndex(tableName, StringUtils.format((String)"idx_%1$s_datasource_task_allocator_id", (Object[])new Object[]{tableName}), (List<String>)ImmutableList.of((Object)"dataSource", (Object)"task_allocator_id"), createdIndexSet);
    }

    public void createLockTable(String tableName, String entryTypeName) {
        this.createTable(tableName, (Iterable<String>)ImmutableList.of((Object)StringUtils.format((String)"CREATE TABLE %1$s (\n  id %2$s NOT NULL,\n  %4$s_id VARCHAR(255) DEFAULT NULL,\n  lock_payload %3$s,\n  PRIMARY KEY (id)\n)", (Object[])new Object[]{tableName, this.getSerialType(), this.getPayloadType(), entryTypeName}), (Object)StringUtils.format((String)"CREATE INDEX idx_%1$s_%2$s_id ON %1$s(%2$s_id)", (Object[])new Object[]{tableName, entryTypeName})));
    }

    public void createSupervisorsTable(String tableName) {
        this.createTable(tableName, (Iterable<String>)ImmutableList.of((Object)StringUtils.format((String)"CREATE TABLE %1$s (\n  id %2$s NOT NULL,\n  spec_id VARCHAR(255) NOT NULL,\n  created_date VARCHAR(255) NOT NULL,\n  payload %3$s NOT NULL,\n  PRIMARY KEY (id)\n)", (Object[])new Object[]{tableName, this.getSerialType(), this.getPayloadType()}), (Object)StringUtils.format((String)"CREATE INDEX idx_%1$s_spec_id ON %1$s(spec_id)", (Object[])new Object[]{tableName})));
    }

    protected void alterSegmentTable() {
        String tableName = ((MetadataStorageTablesConfig)this.tablesConfigSupplier.get()).getSegmentsTable();
        HashMap<String, String> columnNameTypes = new HashMap<String, String>();
        columnNameTypes.put("used_status_last_updated", "VARCHAR(255)");
        columnNameTypes.put("upgraded_from_segment_id", "VARCHAR(255)");
        if (this.centralizedDatasourceSchemaConfig.isEnabled()) {
            columnNameTypes.put("schema_fingerprint", "VARCHAR(255)");
            columnNameTypes.put("num_rows", "BIGINT");
        }
        HashSet<Object> columnsToAdd = new HashSet<Object>();
        for (Object columnName : columnNameTypes.keySet()) {
            if (this.tableHasColumn(tableName, (String)columnName)) {
                log.info("Table[%s] already has column[%s].", new Object[]{tableName, columnName});
                continue;
            }
            columnsToAdd.add(columnName);
        }
        ArrayList<String> alterCommands = new ArrayList<String>();
        if (!columnsToAdd.isEmpty()) {
            for (String string : columnsToAdd) {
                alterCommands.add(StringUtils.format((String)"ALTER TABLE %1$s ADD %2$s %3$s", (Object[])new Object[]{tableName, string, columnNameTypes.get(string)}));
            }
            log.info("Adding columns %s to table[%s].", new Object[]{columnsToAdd, tableName});
        }
        this.alterTable(tableName, alterCommands);
        Set<String> createdIndexSet = this.getIndexOnTable(tableName);
        this.createIndex(tableName, StringUtils.format((String)"idx_%1$s_datasource_upgraded_from_segment_id", (Object[])new Object[]{tableName}), (List<String>)ImmutableList.of((Object)"dataSource", (Object)"upgraded_from_segment_id"), createdIndexSet);
    }

    public Void insertOrUpdate(final String tableName, final String keyColumn, final String valueColumn, final String key, final byte[] value) {
        return (Void)this.getDBI().inTransaction((TransactionCallback)new TransactionCallback<Void>(){

            public Void inTransaction(Handle handle, TransactionStatus transactionStatus) {
                int count = (Integer)((Query)handle.createQuery(StringUtils.format((String)"SELECT COUNT(*) FROM %1$s WHERE %2$s = :key", (Object[])new Object[]{tableName, keyColumn})).bind("key", key)).map((ResultSetMapper)IntegerMapper.FIRST).first();
                if (count == 0) {
                    ((Update)((Update)handle.createStatement(StringUtils.format((String)"INSERT INTO %1$s (%2$s, %3$s) VALUES (:key, :value)", (Object[])new Object[]{tableName, keyColumn, valueColumn})).bind("key", key)).bind("value", value)).execute();
                } else {
                    ((Update)((Update)handle.createStatement(StringUtils.format((String)"UPDATE %1$s SET %3$s=:value WHERE %2$s=:key", (Object[])new Object[]{tableName, keyColumn, valueColumn})).bind("key", key)).bind("value", value)).execute();
                }
                return null;
            }
        });
    }

    public boolean compareAndSwap(final List<MetadataCASUpdate> updates) {
        return (Boolean)this.getDBI().inTransaction(TransactionIsolationLevel.REPEATABLE_READ, (TransactionCallback)new TransactionCallback<Boolean>(){

            public Boolean inTransaction(Handle handle, TransactionStatus transactionStatus) {
                byte[] currentValue;
                ArrayList<byte[]> currentValues = new ArrayList<byte[]>();
                for (MetadataCASUpdate update : updates) {
                    currentValue = (byte[])((Query)handle.createQuery(StringUtils.format((String)"SELECT %1$s FROM %2$s WHERE %3$s = :key FOR UPDATE", (Object[])new Object[]{update.getValueColumn(), update.getTableName(), update.getKeyColumn()})).bind("key", update.getKey())).map((ResultSetMapper)ByteArrayMapper.FIRST).first();
                    if (!Arrays.equals(currentValue, update.getOldValue())) {
                        return false;
                    }
                    currentValues.add(currentValue);
                }
                for (int i = 0; i < updates.size(); ++i) {
                    MetadataCASUpdate update;
                    update = (MetadataCASUpdate)updates.get(i);
                    currentValue = (byte[])currentValues.get(i);
                    if (currentValue == null) {
                        ((Update)((Update)handle.createStatement(StringUtils.format((String)"INSERT INTO %1$s (%2$s, %3$s) VALUES (:key, :value)", (Object[])new Object[]{update.getTableName(), update.getKeyColumn(), update.getValueColumn()})).bind("key", update.getKey())).bind("value", update.getNewValue())).execute();
                        continue;
                    }
                    ((Update)((Update)handle.createStatement(StringUtils.format((String)"UPDATE %1$s SET %3$s=:value WHERE %2$s=:key", (Object[])new Object[]{update.getTableName(), update.getKeyColumn(), update.getValueColumn()})).bind("key", update.getKey())).bind("value", update.getNewValue())).execute();
                }
                return true;
            }
        });
    }

    public abstract DBI getDBI();

    public void createDataSourceTable() {
        if (((MetadataStorageConnectorConfig)this.config.get()).isCreateTables()) {
            this.createDataSourceTable(((MetadataStorageTablesConfig)this.tablesConfigSupplier.get()).getDataSourceTable());
        }
    }

    public void createPendingSegmentsTable() {
        if (((MetadataStorageConnectorConfig)this.config.get()).isCreateTables()) {
            this.createPendingSegmentsTable(((MetadataStorageTablesConfig)this.tablesConfigSupplier.get()).getPendingSegmentsTable());
        }
    }

    public void createSegmentTable() {
        if (((MetadataStorageConnectorConfig)this.config.get()).isCreateTables()) {
            this.createSegmentTable(((MetadataStorageTablesConfig)this.tablesConfigSupplier.get()).getSegmentsTable());
            this.alterSegmentTable();
        }
        this.validateSegmentsTable();
    }

    public void createUpgradeSegmentsTable() {
        if (((MetadataStorageConnectorConfig)this.config.get()).isCreateTables()) {
            this.createUpgradeSegmentsTable(((MetadataStorageTablesConfig)this.tablesConfigSupplier.get()).getUpgradeSegmentsTable());
        }
    }

    public void createRulesTable() {
        if (((MetadataStorageConnectorConfig)this.config.get()).isCreateTables()) {
            this.createRulesTable(((MetadataStorageTablesConfig)this.tablesConfigSupplier.get()).getRulesTable());
        }
    }

    public void createConfigTable() {
        if (((MetadataStorageConnectorConfig)this.config.get()).isCreateTables()) {
            this.createConfigTable(((MetadataStorageTablesConfig)this.tablesConfigSupplier.get()).getConfigTable());
        }
    }

    public void createTaskTables() {
        if (((MetadataStorageConnectorConfig)this.config.get()).isCreateTables()) {
            MetadataStorageTablesConfig tablesConfig = (MetadataStorageTablesConfig)this.tablesConfigSupplier.get();
            String entryType = tablesConfig.getTaskEntryType();
            this.prepareTaskEntryTable(tablesConfig.getEntryTable(entryType));
            this.createLockTable(tablesConfig.getLockTable(entryType), entryType);
        }
    }

    public void createSupervisorsTable() {
        if (((MetadataStorageConnectorConfig)this.config.get()).isCreateTables()) {
            this.createSupervisorsTable(((MetadataStorageTablesConfig)this.tablesConfigSupplier.get()).getSupervisorTable());
        }
    }

    @Nullable
    public byte[] lookup(String tableName, String keyColumn, String valueColumn, String key) {
        return (byte[])this.getDBI().withHandle(handle -> this.lookupWithHandle(handle, tableName, keyColumn, valueColumn, key));
    }

    @Nullable
    public byte[] lookupWithHandle(Handle handle, String tableName, String keyColumn, String valueColumn, String key) {
        String selectStatement = StringUtils.format((String)"SELECT %s FROM %s WHERE %s = :key", (Object[])new Object[]{valueColumn, tableName, keyColumn});
        List matched = ((Query)handle.createQuery(selectStatement).bind("key", key)).map((ResultSetMapper)ByteArrayMapper.FIRST).list();
        if (matched.isEmpty()) {
            return null;
        }
        if (matched.size() > 1) {
            throw new ISE("Error! More than one matching entry[%d] found for [%s]?!", new Object[]{matched.size(), key});
        }
        return (byte[])matched.get(0);
    }

    public MetadataStorageConnectorConfig getConfig() {
        return (MetadataStorageConnectorConfig)this.config.get();
    }

    protected static BasicDataSource makeDatasource(MetadataStorageConnectorConfig connectorConfig, String validationQuery) {
        Object dataSource;
        try {
            Properties dbcpProperties = connectorConfig.getDbcpProperties();
            dataSource = dbcpProperties != null ? BasicDataSourceFactory.createDataSource((Properties)dbcpProperties) : new BasicDataSourceExt(connectorConfig);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        dataSource.setUsername(connectorConfig.getUser());
        dataSource.setPassword(connectorConfig.getPassword());
        String uri = connectorConfig.getConnectURI();
        dataSource.setUrl(uri);
        dataSource.setValidationQuery(validationQuery);
        dataSource.setTestOnBorrow(true);
        return dataSource;
    }

    protected BasicDataSource getDatasource() {
        return SQLMetadataConnector.makeDatasource(this.getConfig(), this.getValidationQuery());
    }

    public final <T> T retryReadOnlyTransaction(TransactionCallback<T> callback, int quietTries, int maxTries) {
        try {
            return (T)RetryUtils.retry(() -> this.getDBI().inTransaction(TransactionIsolationLevel.READ_COMMITTED, callback), this.shouldRetry, (int)quietTries, (int)maxTries, null, (String)"Metadata read transaction failed");
        }
        catch (Exception e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public final <T> T inReadOnlyTransaction(final TransactionCallback<T> callback) {
        return (T)this.getDBI().withHandle(new HandleCallback<T>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public T withHandle(Handle handle) throws Exception {
                Connection connection = handle.getConnection();
                boolean readOnly = connection.isReadOnly();
                connection.setReadOnly(true);
                try {
                    Object object = handle.inTransaction(callback);
                    return object;
                }
                finally {
                    try {
                        connection.setReadOnly(readOnly);
                    }
                    catch (SQLException e) {
                        log.error((Throwable)e, "Unable to reset connection read-only state", new Object[0]);
                    }
                }
            }
        });
    }

    private void createAuditTable(String tableName) {
        this.createTable(tableName, (Iterable<String>)ImmutableList.of((Object)StringUtils.format((String)"CREATE TABLE %1$s (\n  id %2$s NOT NULL,\n  audit_key VARCHAR(255) NOT NULL,\n  type VARCHAR(255) NOT NULL,\n  author VARCHAR(255) NOT NULL,\n  comment VARCHAR(2048) NOT NULL,\n  created_date VARCHAR(255) NOT NULL,\n  payload %3$s NOT NULL,\n  PRIMARY KEY(id)\n)", (Object[])new Object[]{tableName, this.getSerialType(), this.getPayloadType()}), (Object)StringUtils.format((String)"CREATE INDEX idx_%1$s_key_time ON %1$s(audit_key, created_date)", (Object[])new Object[]{tableName}), (Object)StringUtils.format((String)"CREATE INDEX idx_%1$s_type_time ON %1$s(type, created_date)", (Object[])new Object[]{tableName}), (Object)StringUtils.format((String)"CREATE INDEX idx_%1$s_audit_time ON %1$s(created_date)", (Object[])new Object[]{tableName})));
    }

    public void createAuditTable() {
        if (((MetadataStorageConnectorConfig)this.config.get()).isCreateTables()) {
            this.createAuditTable(((MetadataStorageTablesConfig)this.tablesConfigSupplier.get()).getAuditTable());
        }
    }

    public void deleteAllRecords(final String tableName) {
        try {
            this.retryWithHandle(new HandleCallback<Void>(){

                public Void withHandle(Handle handle) {
                    if (SQLMetadataConnector.this.tableExists(handle, tableName)) {
                        log.info("Deleting all records from table[%s]", new Object[]{tableName});
                        Batch batch = handle.createBatch();
                        batch.add("DELETE FROM " + tableName);
                        batch.execute();
                    } else {
                        log.info("Table[%s] does not exit.", new Object[]{tableName});
                    }
                    return null;
                }
            });
        }
        catch (Exception e) {
            log.warn((Throwable)e, "Exception while deleting records from table", new Object[0]);
        }
    }

    public void createSegmentSchemaTable(String tableName) {
        this.createTable(tableName, (Iterable<String>)ImmutableList.of((Object)StringUtils.format((String)"CREATE TABLE %1$s (\n  id %2$s NOT NULL,\n  created_date VARCHAR(255) NOT NULL,\n  datasource VARCHAR(255) NOT NULL,\n  fingerprint VARCHAR(255) NOT NULL,\n  payload %3$s NOT NULL,\n  used BOOLEAN NOT NULL,\n  used_status_last_updated VARCHAR(255) NOT NULL,\n  version INTEGER NOT NULL,\n  PRIMARY KEY (id),\n  UNIQUE (fingerprint) \n)", (Object[])new Object[]{tableName, this.getSerialType(), this.getPayloadType()}), (Object)StringUtils.format((String)"CREATE INDEX idx_%1$s_fingerprint ON %1$s(fingerprint)", (Object[])new Object[]{tableName}), (Object)StringUtils.format((String)"CREATE INDEX idx_%1$s_used ON %1$s(used, used_status_last_updated)", (Object[])new Object[]{tableName})));
    }

    public void createSegmentSchemasTable() {
        if (((MetadataStorageConnectorConfig)this.config.get()).isCreateTables() && this.centralizedDatasourceSchemaConfig.isEnabled()) {
            this.createSegmentSchemaTable(((MetadataStorageTablesConfig)this.tablesConfigSupplier.get()).getSegmentSchemasTable());
        }
    }

    public Set<String> getIndexOnTable(final String tableName) {
        final HashSet res = new HashSet();
        try {
            this.retryWithHandle(new HandleCallback<Void>(){

                public Void withHandle(Handle handle) throws Exception {
                    DatabaseMetaData databaseMetaData = handle.getConnection().getMetaData();
                    ResultSet resultSet = SQLMetadataConnector.this.getIndexInfo(databaseMetaData, tableName);
                    while (resultSet.next()) {
                        String indexName = resultSet.getString("INDEX_NAME");
                        if (!org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)indexName)) continue;
                        res.add(StringUtils.toUpperCase((String)indexName));
                    }
                    return null;
                }
            });
        }
        catch (Exception e) {
            log.error((Throwable)e, "Exception while listing the index on table %s ", new Object[]{tableName});
        }
        return ImmutableSet.copyOf(res);
    }

    public ResultSet getIndexInfo(DatabaseMetaData databaseMetaData, String tableName) throws SQLException {
        return databaseMetaData.getIndexInfo(null, null, tableName, false, false);
    }

    public void createIndex(final String tableName, final String indexName, final List<String> indexCols, final Set<String> createdIndexSet) {
        try {
            this.retryWithHandle(new HandleCallback<Void>(){

                public Void withHandle(Handle handle) {
                    if (!createdIndexSet.contains(StringUtils.toUpperCase((String)indexName))) {
                        String indexSQL = StringUtils.format((String)"CREATE INDEX %1$s ON %2$s(%3$s)", (Object[])new Object[]{indexName, tableName, Joiner.on((String)",").join((Iterable)indexCols)});
                        log.info("Creating Index on Table [%s], sql: [%s] ", new Object[]{tableName, indexSQL});
                        handle.execute(indexSQL, new Object[0]);
                    } else {
                        log.info("Index [%s] on Table [%s] already exists", new Object[]{indexName, tableName});
                    }
                    return null;
                }
            });
        }
        catch (Exception e) {
            log.error((Throwable)e, StringUtils.format((String)"Exception while creating index on table [%s]", (Object[])new Object[]{tableName}), new Object[0]);
        }
    }

    protected boolean tableHasColumn(String tableName, String columnName) {
        return (Boolean)this.getDBI().withHandle(handle -> {
            try {
                if (this.tableExists(handle, tableName)) {
                    DatabaseMetaData dbMetaData = handle.getConnection().getMetaData();
                    ResultSet columns = dbMetaData.getColumns(null, null, tableName, columnName);
                    return columns.next();
                }
                return false;
            }
            catch (SQLException e) {
                return false;
            }
        });
    }

    private void validateSegmentsTable() {
        boolean schemaPersistenceRequirementMet;
        String segmentsTables = ((MetadataStorageTablesConfig)this.tablesConfigSupplier.get()).getSegmentsTable();
        boolean bl = schemaPersistenceRequirementMet = !this.centralizedDatasourceSchemaConfig.isEnabled() || this.tableHasColumn(segmentsTables, "schema_fingerprint") && this.tableHasColumn(segmentsTables, "num_rows");
        if (!this.tableHasColumn(segmentsTables, "used_status_last_updated") || !schemaPersistenceRequirementMet) {
            throw new ISE("Cannot start Druid as table[%s] has an incompatible schema. Reason: One or all of these columns [used_status_last_updated, schema_fingerprint, num_rows] does not exist in table. See https://druid.apache.org/docs/latest/operations/upgrade-prep.html for more info on remediation.", new Object[]{((MetadataStorageTablesConfig)this.tablesConfigSupplier.get()).getSegmentsTable()});
        }
    }
}

