/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.timeline.partition;

import com.google.common.collect.Iterables;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.druid.timeline.Overshadowable;
import org.apache.druid.timeline.partition.OvershadowableManager;
import org.apache.druid.timeline.partition.PartitionChunk;
import org.apache.druid.timeline.partition.PartitionHolderContents;
import org.apache.druid.timeline.partition.SimplePartitionHolderContents;

public class PartitionHolder<T extends Overshadowable<T>>
implements Iterable<PartitionChunk<T>> {
    private PartitionHolderContents<T> contents = new SimplePartitionHolderContents();
    private short maxMinorVersion;

    public static <T extends Overshadowable<T>> PartitionHolder<T> copyWithOnlyVisibleChunks(PartitionHolder<T> partitionHolder) {
        return new PartitionHolder<T>(partitionHolder.contents.copyVisible(), partitionHolder.maxMinorVersion);
    }

    public static <T extends Overshadowable<T>> PartitionHolder<T> deepCopy(PartitionHolder<T> partitionHolder) {
        return new PartitionHolder<T>(partitionHolder.contents.deepCopy(), partitionHolder.maxMinorVersion);
    }

    public PartitionHolder(PartitionChunk<T> initialChunk) {
        this.add(initialChunk);
    }

    public PartitionHolder(List<PartitionChunk<T>> initialChunks) {
        for (PartitionChunk<T> chunk : initialChunks) {
            this.add(chunk);
        }
    }

    public PartitionHolder(PartitionHolderContents<T> contents, short maxMinorVersion) {
        this.contents = contents;
        this.maxMinorVersion = maxMinorVersion;
    }

    public boolean add(PartitionChunk<T> chunk) {
        boolean added;
        if (((Overshadowable)chunk.getObject()).getMinorVersion() != 0 && this.contents instanceof SimplePartitionHolderContents) {
            this.contents = OvershadowableManager.fromSimple((SimplePartitionHolderContents)this.contents);
        }
        if ((added = this.contents.addChunk(chunk)) && ((Overshadowable)chunk.getObject()).getMinorVersion() > this.maxMinorVersion) {
            this.maxMinorVersion = ((Overshadowable)chunk.getObject()).getMinorVersion();
        }
        return added;
    }

    public short getMaxMinorVersion() {
        return this.maxMinorVersion;
    }

    @Nullable
    public PartitionChunk<T> remove(PartitionChunk<T> chunk) {
        return this.contents.removeChunk(chunk);
    }

    public boolean isEmpty() {
        return this.contents.isEmpty();
    }

    public boolean isComplete() {
        if (this.contents.isEmpty()) {
            return false;
        }
        Iterator<PartitionChunk<T>> iter = this.iterator();
        PartitionChunk<T> curr = iter.next();
        if (!curr.isStart()) {
            return false;
        }
        if (curr.isEnd()) {
            return this.contents.areVisibleChunksConsistent();
        }
        while (iter.hasNext()) {
            PartitionChunk<T> next = iter.next();
            if (!curr.abuts(next)) {
                return false;
            }
            if (next.isEnd()) {
                return this.contents.areVisibleChunksConsistent();
            }
            curr = next;
        }
        return false;
    }

    public PartitionChunk<T> getChunk(int partitionNum) {
        return this.contents.getChunk(partitionNum);
    }

    @Override
    public Iterator<PartitionChunk<T>> iterator() {
        return this.contents.visibleChunksIterator();
    }

    public List<PartitionChunk<T>> getOvershadowed() {
        return this.contents.getOvershadowedChunks();
    }

    public Iterable<T> payloads() {
        return Iterables.transform((Iterable)this, PartitionChunk::getObject);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PartitionHolder that = (PartitionHolder)o;
        return Objects.equals(this.contents, that.contents);
    }

    public int hashCode() {
        return Objects.hash(this.contents);
    }

    public String toString() {
        return "PartitionHolder{contents=" + String.valueOf(this.contents) + "}";
    }

    public boolean hasData() {
        for (Overshadowable payload : this.payloads()) {
            if (!payload.hasData()) continue;
            return true;
        }
        return false;
    }
}

