/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.virtual;

import javax.annotation.Nullable;
import org.apache.druid.math.expr.ExprEval;
import org.apache.druid.query.monomorphicprocessing.RuntimeShapeInspector;
import org.apache.druid.segment.ColumnValueSelector;
import org.apache.druid.segment.RowIdSupplier;

public abstract class BaseExpressionColumnValueSelector
implements ColumnValueSelector<ExprEval> {
    @Nullable
    private final RowIdSupplier rowIdSupplier;
    private long currentRowId = -1L;
    private ExprEval<?> currentEval;

    protected BaseExpressionColumnValueSelector(@Nullable RowIdSupplier rowIdSupplier) {
        this.rowIdSupplier = rowIdSupplier;
    }

    @Override
    public double getDouble() {
        return this.computeCurrentEval().asDouble();
    }

    @Override
    public float getFloat() {
        return (float)this.computeCurrentEval().asDouble();
    }

    @Override
    public long getLong() {
        return this.computeCurrentEval().asLong();
    }

    @Override
    public boolean isNull() {
        return this.computeCurrentEval().isNumericNull();
    }

    @Override
    @Nullable
    public ExprEval<?> getObject() {
        return this.computeCurrentEval();
    }

    @Override
    public Class<ExprEval> classOfObject() {
        return ExprEval.class;
    }

    @Override
    public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
        inspector.visit("rowIdSupplier", this.rowIdSupplier);
    }

    protected abstract ExprEval<?> eval();

    private ExprEval<?> computeCurrentEval() {
        if (this.rowIdSupplier == null) {
            return this.eval();
        }
        long rowId = this.rowIdSupplier.getRowId();
        if (this.currentRowId != rowId) {
            this.currentEval = this.eval();
            this.currentRowId = rowId;
        }
        return this.currentEval;
    }
}

