/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.shim;

import org.apache.druid.segment.ColumnSelectorFactory;
import org.apache.druid.segment.Cursor;
import org.apache.druid.segment.shim.ShimColumnSelectorFactory;
import org.apache.druid.segment.vector.VectorColumnSelectorFactory;
import org.apache.druid.segment.vector.VectorCursor;

public class ShimCursor
implements Cursor {
    private final ShimColumnSelectorFactory columnSelectorFactory;
    final VectorCursor vectorCursor;
    final VectorColumnSelectorFactory vectorColumnSelectorFactory;
    int currentIndexInVector = 0;

    public ShimCursor(VectorCursor vectorCursor) {
        this.vectorCursor = vectorCursor;
        this.vectorColumnSelectorFactory = vectorCursor.getColumnSelectorFactory();
        this.columnSelectorFactory = new ShimColumnSelectorFactory(this);
    }

    @Override
    public ColumnSelectorFactory getColumnSelectorFactory() {
        return this.columnSelectorFactory;
    }

    @Override
    public void advance() {
        ++this.currentIndexInVector;
        if (this.currentIndexInVector == this.vectorCursor.getCurrentVectorSize()) {
            this.vectorCursor.advance();
            this.currentIndexInVector = 0;
        }
    }

    @Override
    public void advanceUninterruptibly() {
        this.advance();
    }

    @Override
    public boolean isDone() {
        return this.vectorCursor.isDone();
    }

    @Override
    public boolean isDoneOrInterrupted() {
        return this.isDone() || Thread.currentThread().isInterrupted();
    }

    @Override
    public void reset() {
        this.vectorCursor.reset();
    }
}

