/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.projections;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.druid.error.DruidException;
import org.apache.druid.java.util.common.granularity.Granularities;
import org.apache.druid.java.util.common.granularity.Granularity;
import org.apache.druid.query.OrderBy;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.filter.DimFilter;
import org.apache.druid.segment.VirtualColumn;
import org.apache.druid.segment.VirtualColumns;
import org.apache.druid.segment.projections.ProjectionSchema;
import org.apache.druid.utils.CollectionUtils;

public class AggregateProjectionSchema
implements ProjectionSchema {
    public static final Comparator<AggregateProjectionSchema> COMPARATOR = (o1, o2) -> {
        if (o1.getEffectiveGranularity().isFinerThan(o2.getEffectiveGranularity())) {
            return 1;
        }
        if (o2.getEffectiveGranularity().isFinerThan(o1.getEffectiveGranularity())) {
            return -1;
        }
        int dimsCompare = Integer.compare(o1.groupingColumns.size(), o2.groupingColumns.size());
        if (dimsCompare != 0) {
            return dimsCompare;
        }
        int metCompare = Integer.compare(o2.aggregators.length, o1.aggregators.length);
        if (metCompare != 0) {
            return metCompare;
        }
        int virtCompare = Integer.compare(o2.virtualColumns.getVirtualColumns().length, o1.virtualColumns.getVirtualColumns().length);
        if (virtCompare != 0) {
            return virtCompare;
        }
        return o1.name.compareTo(o2.name);
    };
    private final String name;
    @Nullable
    private final String timeColumnName;
    @Nullable
    private final DimFilter filter;
    private final VirtualColumns virtualColumns;
    private final List<String> groupingColumns;
    private final AggregatorFactory[] aggregators;
    private final List<OrderBy> ordering;
    private final List<OrderBy> orderingWithTimeSubstitution;
    private final int timeColumnPosition;
    private final Granularity effectiveGranularity;

    @JsonCreator
    public AggregateProjectionSchema(@JsonProperty(value="name") String name, @JsonProperty(value="timeColumnName") @Nullable String timeColumnName, @JsonProperty(value="filter") @Nullable DimFilter filter, @JsonProperty(value="virtualColumns") @Nullable VirtualColumns virtualColumns, @JsonProperty(value="groupingColumns") @Nullable List<String> groupingColumns, @JsonProperty(value="aggregators") @Nullable AggregatorFactory[] aggregators, @JsonProperty(value="ordering") List<OrderBy> ordering) {
        if (name == null || name.isEmpty()) {
            throw DruidException.defensive("projection schema name cannot be null or empty", new Object[0]);
        }
        this.name = name;
        if (CollectionUtils.isNullOrEmpty(groupingColumns) && (aggregators == null || aggregators.length == 0)) {
            throw DruidException.defensive("projection schema[%s] groupingColumns and aggregators must not both be null or empty", name);
        }
        if (ordering == null) {
            throw DruidException.defensive("projection schema[%s] ordering must not be null", name);
        }
        this.filter = filter;
        this.virtualColumns = virtualColumns == null ? VirtualColumns.EMPTY : virtualColumns;
        this.groupingColumns = groupingColumns == null ? Collections.emptyList() : groupingColumns;
        this.aggregators = aggregators == null ? new AggregatorFactory[]{} : aggregators;
        this.ordering = ordering;
        int foundTimePosition = -1;
        this.orderingWithTimeSubstitution = Lists.newArrayListWithCapacity((int)ordering.size());
        Granularity granularity = null;
        for (int i = 0; i < ordering.size(); ++i) {
            OrderBy orderBy = ordering.get(i);
            if (orderBy.getColumnName().equals(timeColumnName)) {
                this.orderingWithTimeSubstitution.add(new OrderBy("__time", orderBy.getOrder()));
                foundTimePosition = i;
                timeColumnName = this.groupingColumns.get(foundTimePosition);
                VirtualColumn vc = this.virtualColumns.getVirtualColumn(this.groupingColumns.get(foundTimePosition));
                if (vc != null) {
                    granularity = Granularities.fromVirtualColumn(vc);
                    continue;
                }
                granularity = Granularities.NONE;
                continue;
            }
            this.orderingWithTimeSubstitution.add(orderBy);
        }
        this.timeColumnName = timeColumnName;
        this.timeColumnPosition = foundTimePosition;
        this.effectiveGranularity = granularity == null ? Granularities.ALL : granularity;
    }

    public static SchemaBuilder schemaBuilder(String name) {
        return new SchemaBuilder().name(name);
    }

    @Override
    @JsonIgnore
    public List<String> getColumnNames() {
        ArrayList<String> columns = new ArrayList<String>(this.groupingColumns.size() + this.aggregators.length);
        columns.addAll(this.groupingColumns);
        for (AggregatorFactory aggregator : this.aggregators) {
            columns.add(aggregator.getName());
        }
        return columns;
    }

    @Override
    @JsonProperty
    public String getName() {
        return this.name;
    }

    @Override
    @JsonProperty
    @Nullable
    public String getTimeColumnName() {
        return this.timeColumnName;
    }

    @JsonProperty
    @Nullable
    public DimFilter getFilter() {
        return this.filter;
    }

    @Override
    @JsonProperty
    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    public VirtualColumns getVirtualColumns() {
        return this.virtualColumns;
    }

    @JsonProperty
    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    public List<String> getGroupingColumns() {
        return this.groupingColumns;
    }

    @JsonProperty
    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    public AggregatorFactory[] getAggregators() {
        return this.aggregators;
    }

    @Override
    @JsonProperty
    public List<OrderBy> getOrdering() {
        return this.ordering;
    }

    @Override
    @JsonIgnore
    public List<OrderBy> getOrderingWithTimeColumnSubstitution() {
        return this.orderingWithTimeSubstitution;
    }

    @Override
    @JsonIgnore
    public int getTimeColumnPosition() {
        return this.timeColumnPosition;
    }

    @Override
    @JsonIgnore
    public Granularity getEffectiveGranularity() {
        return this.effectiveGranularity;
    }

    public boolean isInvalidGrouping(@Nullable String columnName) {
        if (columnName == null) {
            return false;
        }
        return !this.groupingColumns.contains(columnName) && this.virtualColumns.exists(columnName);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AggregateProjectionSchema schema = (AggregateProjectionSchema)o;
        return Objects.equals(this.name, schema.name) && Objects.equals(this.timeColumnName, schema.timeColumnName) && Objects.equals(this.filter, schema.filter) && Objects.equals(this.virtualColumns, schema.virtualColumns) && Objects.equals(this.groupingColumns, schema.groupingColumns) && Objects.deepEquals(this.aggregators, schema.aggregators) && Objects.equals(this.ordering, schema.ordering);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.timeColumnName, this.filter, this.virtualColumns, this.groupingColumns, Arrays.hashCode(this.aggregators), this.ordering);
    }

    public String toString() {
        return "Schema{name='" + this.name + "', timeColumnName='" + this.timeColumnName + "', virtualColumns=" + String.valueOf(this.virtualColumns) + ", groupingColumns=" + String.valueOf(this.groupingColumns) + ", aggregators=" + Arrays.toString(this.aggregators) + ", ordering=" + String.valueOf(this.ordering) + ", timeColumnPosition=" + this.timeColumnPosition + ", effectiveGranularity=" + String.valueOf(this.effectiveGranularity) + ", orderingWithTimeSubstitution=" + String.valueOf(this.orderingWithTimeSubstitution) + "}";
    }

    public static class SchemaBuilder {
        @Nullable
        private String name;
        @Nullable
        private String timeColumnName;
        private VirtualColumns virtualColumns = VirtualColumns.EMPTY;
        @Nullable
        private DimFilter filter;
        private List<String> groupingColumns;
        private AggregatorFactory[] aggregators;
        private List<OrderBy> ordering;

        public SchemaBuilder name(@Nullable String name) {
            this.name = name;
            return this;
        }

        public SchemaBuilder timeColumnName(@Nullable String timeColumnName) {
            this.timeColumnName = timeColumnName;
            return this;
        }

        public SchemaBuilder virtualColumns(VirtualColumns virtualColumns) {
            this.virtualColumns = virtualColumns;
            return this;
        }

        public SchemaBuilder virtualColumns(VirtualColumn ... virtualColumns) {
            this.virtualColumns = VirtualColumns.create(virtualColumns);
            return this;
        }

        public SchemaBuilder filter(@Nullable DimFilter filter) {
            this.filter = filter;
            return this;
        }

        public SchemaBuilder groupAndOrder(String ... groupingColumns) {
            this.groupingColumns = Arrays.asList(groupingColumns);
            return this.ordering(groupingColumns);
        }

        public SchemaBuilder aggregators(AggregatorFactory ... aggregators) {
            this.aggregators = aggregators;
            return this;
        }

        public SchemaBuilder ordering(String ... columnNames) {
            this.ordering = Arrays.stream(columnNames).map(OrderBy::ascending).collect(Collectors.toList());
            return this;
        }

        public SchemaBuilder ordering(List<OrderBy> ordering) {
            this.ordering = ordering;
            return this;
        }

        public AggregateProjectionSchema build() {
            return new AggregateProjectionSchema(this.name, this.timeColumnName, this.filter, this.virtualColumns, this.groupingColumns, this.aggregators, this.ordering);
        }
    }
}

