/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.nested;

import com.google.common.base.Preconditions;
import org.apache.druid.segment.nested.DictionaryIdLookup;
import org.apache.druid.segment.nested.GlobalDictionaryEncodedFieldColumnWriter;
import org.apache.druid.segment.nested.NestedCommonFormatColumnFormatSpec;
import org.apache.druid.segment.writeout.SegmentWriteOutMedium;

public final class VariantFieldColumnWriter
extends GlobalDictionaryEncodedFieldColumnWriter<Object> {
    public VariantFieldColumnWriter(String columnName, String fieldName, SegmentWriteOutMedium segmentWriteOutMedium, NestedCommonFormatColumnFormatSpec columnFormatSpec, DictionaryIdLookup globalDictionaryIdLookup) {
        super(columnName, fieldName, segmentWriteOutMedium, columnFormatSpec, globalDictionaryIdLookup);
    }

    @Override
    Object processValue(int row, Object value) {
        if (value instanceof Object[]) {
            Object[] array = (Object[])value;
            int[] globalIds = new int[array.length];
            for (int i = 0; i < array.length; ++i) {
                globalIds[i] = array[i] == null ? 0 : (array[i] instanceof String ? this.globalDictionaryIdLookup.lookupString((String)array[i]) : (array[i] instanceof Long ? this.globalDictionaryIdLookup.lookupLong((Long)array[i]) : (array[i] instanceof Double ? this.globalDictionaryIdLookup.lookupDouble((Double)array[i]) : -1)));
                Preconditions.checkArgument((globalIds[i] >= 0 ? 1 : 0) != 0, (String)"unknown global id [%s] for value [%s]", (int)globalIds[i], (Object)array[i]);
            }
            return globalIds;
        }
        return super.processValue(row, value);
    }

    @Override
    int lookupGlobalId(Object value) {
        if (value == null) {
            return 0;
        }
        if (value instanceof Long) {
            return this.globalDictionaryIdLookup.lookupLong((Long)value);
        }
        if (value instanceof Double) {
            return this.globalDictionaryIdLookup.lookupDouble((Double)value);
        }
        if (value instanceof int[]) {
            return this.globalDictionaryIdLookup.lookupArray((int[])value);
        }
        return this.globalDictionaryIdLookup.lookupString(String.valueOf(value));
    }
}

