/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.nested;

import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.druid.collections.bitmap.BitmapFactory;
import org.apache.druid.collections.bitmap.ImmutableBitmap;
import org.apache.druid.error.DruidException;
import org.apache.druid.java.util.common.RE;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.math.expr.ExprEval;
import org.apache.druid.math.expr.ExprType;
import org.apache.druid.math.expr.ExpressionType;
import org.apache.druid.query.BitmapResultFactory;
import org.apache.druid.segment.column.ColumnIndexSupplier;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.StringEncodingStrategies;
import org.apache.druid.segment.column.TypeSignature;
import org.apache.druid.segment.column.ValueType;
import org.apache.druid.segment.data.BitmapSerdeFactory;
import org.apache.druid.segment.data.ColumnarInts;
import org.apache.druid.segment.data.CompressedVSizeColumnarIntsSupplier;
import org.apache.druid.segment.data.FixedIndexed;
import org.apache.druid.segment.data.FrontCodedIntArrayIndexed;
import org.apache.druid.segment.data.GenericIndexed;
import org.apache.druid.segment.data.Indexed;
import org.apache.druid.segment.data.VByte;
import org.apache.druid.segment.file.SegmentFileMapper;
import org.apache.druid.segment.index.AllFalseBitmapColumnIndex;
import org.apache.druid.segment.index.BitmapColumnIndex;
import org.apache.druid.segment.index.SimpleBitmapColumnIndex;
import org.apache.druid.segment.index.SimpleImmutableBitmapIndex;
import org.apache.druid.segment.index.semantic.ArrayElementIndexes;
import org.apache.druid.segment.index.semantic.NullValueIndex;
import org.apache.druid.segment.index.semantic.ValueIndexes;
import org.apache.druid.segment.nested.CompressedNestedDataComplexColumn;
import org.apache.druid.segment.nested.NestedCommonFormatColumn;
import org.apache.druid.segment.nested.VariantColumn;
import org.apache.druid.segment.serde.NestedCommonFormatColumnPartSerde;

public class VariantColumnAndIndexSupplier
implements Supplier<NestedCommonFormatColumn>,
ColumnIndexSupplier {
    private final ColumnType logicalType;
    @Nullable
    private final Byte variantTypeSetByte;
    private final BitmapFactory bitmapFactory;
    private final Supplier<? extends Indexed<ByteBuffer>> stringDictionarySupplier;
    private final Supplier<FixedIndexed<Long>> longDictionarySupplier;
    private final Supplier<FixedIndexed<Double>> doubleDictionarySupplier;
    private final Supplier<FrontCodedIntArrayIndexed> arrayDictionarySupplier;
    private final Supplier<FixedIndexed<Integer>> arrayElementDictionarySupplier;
    private final Supplier<ColumnarInts> encodedValueColumnSupplier;
    private final GenericIndexed<ImmutableBitmap> valueIndexes;
    private final GenericIndexed<ImmutableBitmap> arrayElementIndexes;
    private final ImmutableBitmap nullValueBitmap;

    public static VariantColumnAndIndexSupplier read(ColumnType logicalType, ByteOrder byteOrder, BitmapSerdeFactory bitmapSerdeFactory, ByteBuffer bb, SegmentFileMapper fileMapper, @Nullable VariantColumnAndIndexSupplier parent) {
        byte version = bb.get();
        int columnNameLength = VByte.readInt(bb);
        String columnName = StringUtils.fromUtf8(bb, columnNameLength);
        Byte variantTypeByte = bb.hasRemaining() ? Byte.valueOf(bb.get()) : null;
        if (version == 0) {
            try {
                Supplier<FixedIndexed<Integer>> arrayElementDictionarySupplier;
                Supplier<FrontCodedIntArrayIndexed> arrayDictionarySupplier;
                Object doubleDictionarySupplier;
                Object longDictionarySupplier;
                Supplier<? extends Indexed<ByteBuffer>> stringDictionarySupplier;
                if (parent != null) {
                    stringDictionarySupplier = parent.stringDictionarySupplier;
                    longDictionarySupplier = parent.longDictionarySupplier;
                    doubleDictionarySupplier = parent.doubleDictionarySupplier;
                    arrayDictionarySupplier = parent.arrayDictionarySupplier;
                    arrayElementDictionarySupplier = parent.arrayElementDictionarySupplier;
                } else {
                    ByteBuffer stringDictionaryBuffer = NestedCommonFormatColumnPartSerde.loadInternalFile(fileMapper, columnName, "__stringDictionary");
                    ByteBuffer longDictionaryBuffer = NestedCommonFormatColumnPartSerde.loadInternalFile(fileMapper, columnName, "__longDictionary");
                    ByteBuffer doubleDictionaryBuffer = NestedCommonFormatColumnPartSerde.loadInternalFile(fileMapper, columnName, "__doubleDictionary");
                    ByteBuffer arrayDictionarybuffer = NestedCommonFormatColumnPartSerde.loadInternalFile(fileMapper, columnName, "__arrayDictionary");
                    ByteBuffer arrayElementDictionaryBuffer = NestedCommonFormatColumnPartSerde.loadInternalFile(fileMapper, columnName, "__arrayElementDictionary");
                    stringDictionarySupplier = StringEncodingStrategies.getStringDictionarySupplier(fileMapper, stringDictionaryBuffer, byteOrder);
                    longDictionarySupplier = FixedIndexed.read(longDictionaryBuffer, ColumnType.LONG.getStrategy(), byteOrder, 8);
                    doubleDictionarySupplier = FixedIndexed.read(doubleDictionaryBuffer, ColumnType.DOUBLE.getStrategy(), byteOrder, 8);
                    arrayDictionarySupplier = FrontCodedIntArrayIndexed.read(arrayDictionarybuffer, byteOrder);
                    arrayElementDictionarySupplier = FixedIndexed.read(arrayElementDictionaryBuffer, CompressedNestedDataComplexColumn.INT_TYPE_STRATEGY, byteOrder, 4);
                }
                ByteBuffer encodedValueColumn = NestedCommonFormatColumnPartSerde.loadInternalFile(fileMapper, columnName, "__encodedColumn");
                CompressedVSizeColumnarIntsSupplier ints = CompressedVSizeColumnarIntsSupplier.fromByteBuffer(encodedValueColumn, byteOrder, fileMapper);
                ByteBuffer valueIndexBuffer = NestedCommonFormatColumnPartSerde.loadInternalFile(fileMapper, columnName, "__valueIndexes");
                GenericIndexed<ImmutableBitmap> valueIndexes = GenericIndexed.read(valueIndexBuffer, bitmapSerdeFactory.getObjectStrategy(), fileMapper);
                ByteBuffer elementIndexBuffer = NestedCommonFormatColumnPartSerde.loadInternalFile(fileMapper, columnName, "__arrayElementIndexes");
                GenericIndexed<ImmutableBitmap> arrayElementIndexes = GenericIndexed.read(elementIndexBuffer, bitmapSerdeFactory.getObjectStrategy(), fileMapper);
                return new VariantColumnAndIndexSupplier(logicalType, variantTypeByte, stringDictionarySupplier, (Supplier<FixedIndexed<Long>>)longDictionarySupplier, (Supplier<FixedIndexed<Double>>)doubleDictionarySupplier, arrayDictionarySupplier, arrayElementDictionarySupplier, ints, valueIndexes, arrayElementIndexes, bitmapSerdeFactory.getBitmapFactory());
            }
            catch (IOException ex) {
                throw new RE(ex, "Failed to deserialize V%s column.", version);
            }
        }
        throw new RE("Unknown version " + version, new Object[0]);
    }

    public VariantColumnAndIndexSupplier(ColumnType logicalType, @Nullable Byte variantTypeSetByte, Supplier<? extends Indexed<ByteBuffer>> stringDictionarySupplier, Supplier<FixedIndexed<Long>> longDictionarySupplier, Supplier<FixedIndexed<Double>> doubleDictionarySupplier, Supplier<FrontCodedIntArrayIndexed> arrayDictionarySupplier, Supplier<FixedIndexed<Integer>> arrayElementDictionarySupplier, Supplier<ColumnarInts> encodedValueColumnSupplier, GenericIndexed<ImmutableBitmap> valueIndexes, GenericIndexed<ImmutableBitmap> elementIndexes, BitmapFactory bitmapFactory) {
        this.logicalType = logicalType;
        this.variantTypeSetByte = variantTypeSetByte;
        this.stringDictionarySupplier = stringDictionarySupplier;
        this.longDictionarySupplier = longDictionarySupplier;
        this.doubleDictionarySupplier = doubleDictionarySupplier;
        this.arrayDictionarySupplier = arrayDictionarySupplier;
        this.arrayElementDictionarySupplier = arrayElementDictionarySupplier;
        this.encodedValueColumnSupplier = encodedValueColumnSupplier;
        this.valueIndexes = valueIndexes;
        this.arrayElementIndexes = elementIndexes;
        this.bitmapFactory = bitmapFactory;
        this.nullValueBitmap = valueIndexes.get(0) == null ? bitmapFactory.makeEmptyImmutableBitmap() : (ImmutableBitmap)valueIndexes.get(0);
    }

    @Nullable
    public Byte getVariantTypeSetByte() {
        return this.variantTypeSetByte;
    }

    public NestedCommonFormatColumn get() {
        return new VariantColumn<Indexed>((Indexed)this.stringDictionarySupplier.get(), (FixedIndexed)this.longDictionarySupplier.get(), (FixedIndexed)this.doubleDictionarySupplier.get(), (FrontCodedIntArrayIndexed)this.arrayDictionarySupplier.get(), (ColumnarInts)this.encodedValueColumnSupplier.get(), this.nullValueBitmap, this.logicalType, this.variantTypeSetByte, this.bitmapFactory);
    }

    @Override
    @Nullable
    public <T> T as(Class<T> clazz) {
        if (clazz.equals(NullValueIndex.class)) {
            SimpleImmutableBitmapIndex nullIndex = new SimpleImmutableBitmapIndex(this.nullValueBitmap);
            return (T)((NullValueIndex)() -> nullIndex);
        }
        if (clazz.equals(ValueIndexes.class) && this.variantTypeSetByte == null && this.logicalType.isArray()) {
            return (T)new ArrayValueIndexes();
        }
        if (clazz.equals(ArrayElementIndexes.class) && this.variantTypeSetByte == null && this.logicalType.isArray()) {
            return (T)new VariantArrayElementIndexes();
        }
        return null;
    }

    private ImmutableBitmap getBitmap(int idx) {
        if (idx < 0) {
            return this.bitmapFactory.makeEmptyImmutableBitmap();
        }
        ImmutableBitmap bitmap = (ImmutableBitmap)this.valueIndexes.get(idx);
        return bitmap == null ? this.bitmapFactory.makeEmptyImmutableBitmap() : bitmap;
    }

    private ImmutableBitmap getElementBitmap(int idx) {
        if (idx < 0) {
            return this.bitmapFactory.makeEmptyImmutableBitmap();
        }
        int elementDictionaryIndex = ((FixedIndexed)this.arrayElementDictionarySupplier.get()).indexOf(idx);
        if (elementDictionaryIndex < 0) {
            return this.bitmapFactory.makeEmptyImmutableBitmap();
        }
        ImmutableBitmap bitmap = (ImmutableBitmap)this.arrayElementIndexes.get(elementDictionaryIndex);
        return bitmap == null ? this.bitmapFactory.makeEmptyImmutableBitmap() : bitmap;
    }

    private class ArrayValueIndexes
    implements ValueIndexes {
        private ArrayValueIndexes() {
        }

        @Override
        @Nullable
        public BitmapColumnIndex forValue(@Nonnull Object value, TypeSignature<ValueType> valueType) {
            int elementOffset;
            Indexed elements;
            if (!valueType.isArray()) {
                return new AllFalseBitmapColumnIndex(VariantColumnAndIndexSupplier.this.bitmapFactory, VariantColumnAndIndexSupplier.this.nullValueBitmap);
            }
            ExprEval<?> eval = ExprEval.ofType(ExpressionType.fromColumnTypeStrict(valueType), value);
            ExprEval<?> castForComparison = ExprEval.castForEqualityComparison(eval, ExpressionType.fromColumnTypeStrict(VariantColumnAndIndexSupplier.this.logicalType));
            if (castForComparison == null) {
                return new AllFalseBitmapColumnIndex(VariantColumnAndIndexSupplier.this.bitmapFactory, VariantColumnAndIndexSupplier.this.nullValueBitmap);
            }
            Object[] arrayToMatch = castForComparison.asArray();
            switch ((ValueType)VariantColumnAndIndexSupplier.this.logicalType.getElementType().getType()) {
                case STRING: {
                    elements = (Indexed)VariantColumnAndIndexSupplier.this.stringDictionarySupplier.get();
                    elementOffset = 0;
                    break;
                }
                case LONG: {
                    elements = (Indexed)VariantColumnAndIndexSupplier.this.longDictionarySupplier.get();
                    elementOffset = ((Indexed)VariantColumnAndIndexSupplier.this.stringDictionarySupplier.get()).size();
                    break;
                }
                case DOUBLE: {
                    elements = (Indexed)VariantColumnAndIndexSupplier.this.doubleDictionarySupplier.get();
                    elementOffset = ((Indexed)VariantColumnAndIndexSupplier.this.stringDictionarySupplier.get()).size() + ((FixedIndexed)VariantColumnAndIndexSupplier.this.longDictionarySupplier.get()).size();
                    break;
                }
                default: {
                    throw DruidException.defensive("Unhandled array type [%s] how did this happen?", VariantColumnAndIndexSupplier.this.logicalType.getElementType());
                }
            }
            final int[] ids = new int[arrayToMatch.length];
            final int arrayOffset = ((Indexed)VariantColumnAndIndexSupplier.this.stringDictionarySupplier.get()).size() + ((FixedIndexed)VariantColumnAndIndexSupplier.this.longDictionarySupplier.get()).size() + ((FixedIndexed)VariantColumnAndIndexSupplier.this.doubleDictionarySupplier.get()).size();
            for (int i = 0; i < arrayToMatch.length; ++i) {
                ids[i] = arrayToMatch[i] == null ? 0 : (VariantColumnAndIndexSupplier.this.logicalType.getElementType().is(ValueType.STRING) ? elements.indexOf(StringUtils.toUtf8ByteBuffer((String)arrayToMatch[i])) : elements.indexOf(arrayToMatch[i]) + elementOffset);
                if (ids[i] >= 0 || value != null) continue;
                return new AllFalseBitmapColumnIndex(VariantColumnAndIndexSupplier.this.bitmapFactory, VariantColumnAndIndexSupplier.this.nullValueBitmap);
            }
            final FrontCodedIntArrayIndexed dictionary = (FrontCodedIntArrayIndexed)VariantColumnAndIndexSupplier.this.arrayDictionarySupplier.get();
            return new SimpleBitmapColumnIndex(){

                @Override
                public int estimatedComputeCost() {
                    return 1;
                }

                @Override
                public <T> T computeBitmapResult(BitmapResultFactory<T> bitmapResultFactory, boolean includeUnknown) {
                    int localId = dictionary.indexOf(ids);
                    if (includeUnknown) {
                        if (localId < 0) {
                            return bitmapResultFactory.wrapDimensionValue(VariantColumnAndIndexSupplier.this.nullValueBitmap);
                        }
                        return bitmapResultFactory.unionDimensionValueBitmaps((Iterable<ImmutableBitmap>)ImmutableList.of((Object)VariantColumnAndIndexSupplier.this.getBitmap(localId + arrayOffset), (Object)VariantColumnAndIndexSupplier.this.nullValueBitmap));
                    }
                    if (localId < 0) {
                        return bitmapResultFactory.wrapDimensionValue(VariantColumnAndIndexSupplier.this.bitmapFactory.makeEmptyImmutableBitmap());
                    }
                    return bitmapResultFactory.wrapDimensionValue(VariantColumnAndIndexSupplier.this.getBitmap(localId + arrayOffset));
                }
            };
        }
    }

    private class VariantArrayElementIndexes
    implements ArrayElementIndexes {
        private VariantArrayElementIndexes() {
        }

        @Override
        @Nullable
        public BitmapColumnIndex containsValue(@Nullable Object value, TypeSignature<ValueType> elementValueType) {
            int elementOffset;
            Indexed elements;
            if (elementValueType.isArray()) {
                return new AllFalseBitmapColumnIndex(VariantColumnAndIndexSupplier.this.bitmapFactory, VariantColumnAndIndexSupplier.this.nullValueBitmap);
            }
            ExprEval<?> eval = ExprEval.ofType(ExpressionType.fromColumnTypeStrict(elementValueType), value);
            final ExprEval<?> castForComparison = ExprEval.castForEqualityComparison(eval, ExpressionType.fromColumnTypeStrict(VariantColumnAndIndexSupplier.this.logicalType.isArray() ? VariantColumnAndIndexSupplier.this.logicalType.getElementType() : VariantColumnAndIndexSupplier.this.logicalType));
            if (castForComparison == null) {
                return new AllFalseBitmapColumnIndex(VariantColumnAndIndexSupplier.this.bitmapFactory, VariantColumnAndIndexSupplier.this.nullValueBitmap);
            }
            switch ((ValueType)VariantColumnAndIndexSupplier.this.logicalType.getElementType().getType()) {
                case STRING: {
                    elements = (Indexed)VariantColumnAndIndexSupplier.this.stringDictionarySupplier.get();
                    elementOffset = 0;
                    break;
                }
                case LONG: {
                    elements = (Indexed)VariantColumnAndIndexSupplier.this.longDictionarySupplier.get();
                    elementOffset = ((Indexed)VariantColumnAndIndexSupplier.this.stringDictionarySupplier.get()).size();
                    break;
                }
                case DOUBLE: {
                    elements = (Indexed)VariantColumnAndIndexSupplier.this.doubleDictionarySupplier.get();
                    elementOffset = ((Indexed)VariantColumnAndIndexSupplier.this.stringDictionarySupplier.get()).size() + ((FixedIndexed)VariantColumnAndIndexSupplier.this.longDictionarySupplier.get()).size();
                    break;
                }
                default: {
                    throw DruidException.defensive("Unhandled array type [%s] how did this happen?", VariantColumnAndIndexSupplier.this.logicalType.getElementType());
                }
            }
            return new SimpleBitmapColumnIndex(){

                @Override
                public int estimatedComputeCost() {
                    return 1;
                }

                @Override
                public <T> T computeBitmapResult(BitmapResultFactory<T> bitmapResultFactory, boolean includeUnknown) {
                    int elementId = this.getElementId();
                    if (includeUnknown) {
                        if (elementId < 0) {
                            return bitmapResultFactory.wrapDimensionValue(VariantColumnAndIndexSupplier.this.nullValueBitmap);
                        }
                        return bitmapResultFactory.unionDimensionValueBitmaps((Iterable<ImmutableBitmap>)ImmutableList.of((Object)VariantColumnAndIndexSupplier.this.getElementBitmap(elementId), (Object)VariantColumnAndIndexSupplier.this.nullValueBitmap));
                    }
                    if (elementId < 0) {
                        return bitmapResultFactory.wrapDimensionValue(VariantColumnAndIndexSupplier.this.bitmapFactory.makeEmptyImmutableBitmap());
                    }
                    return bitmapResultFactory.wrapDimensionValue(VariantColumnAndIndexSupplier.this.getElementBitmap(elementId));
                }

                private int getElementId() {
                    if (castForComparison.value() == null) {
                        return 0;
                    }
                    if (castForComparison.type().is(ExprType.STRING)) {
                        return elements.indexOf(StringUtils.toUtf8ByteBuffer(castForComparison.asString()));
                    }
                    return elements.indexOf(castForComparison.value()) + elementOffset;
                }
            };
        }
    }
}

