/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.nested;

import java.io.File;
import java.io.IOException;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.io.Closer;
import org.apache.druid.math.expr.ExprEval;
import org.apache.druid.math.expr.ExpressionType;
import org.apache.druid.segment.column.StringEncodingStrategies;
import org.apache.druid.segment.file.SegmentFileBuilder;
import org.apache.druid.segment.file.SegmentFileMapper;
import org.apache.druid.segment.nested.DictionaryIdLookup;
import org.apache.druid.segment.nested.NestedCommonFormatColumnFormatSpec;
import org.apache.druid.segment.nested.ScalarNestedCommonFormatColumnSerializer;
import org.apache.druid.segment.writeout.SegmentWriteOutMedium;

public class ScalarStringColumnSerializer
extends ScalarNestedCommonFormatColumnSerializer<String> {
    public ScalarStringColumnSerializer(String name, NestedCommonFormatColumnFormatSpec columnFormatSpec, SegmentWriteOutMedium segmentWriteOutMedium, Closer closer) {
        super(name, columnFormatSpec, segmentWriteOutMedium, closer);
    }

    @Override
    protected int processValue(@Nullable Object rawValue) {
        ExprEval<?> eval = ExprEval.bestEffortOf(rawValue);
        String s = eval.castTo(ExpressionType.STRING).asString();
        int dictId = this.dictionaryIdLookup.lookupString(s);
        return dictId;
    }

    @Override
    public void openDictionaryWriter(File segmentBaseDir) throws IOException {
        this.dictionaryWriter = StringEncodingStrategies.getStringDictionaryWriter(this.columnFormatSpec.getStringDictionaryEncoding(), this.segmentWriteOutMedium, this.name);
        this.dictionaryWriter.open();
        this.dictionaryIdLookup = this.closer.register(new DictionaryIdLookup(this.name, segmentBaseDir, this.dictionaryWriter, null, null, null));
    }

    @Override
    protected void openValueColumnSerializer() {
    }

    @Override
    public void serializeDictionaries(Iterable<String> strings, Iterable<Long> longs, Iterable<Double> doubles, Iterable<int[]> arrays) throws IOException {
        if (this.dictionarySerialized) {
            throw new ISE("String dictionary already serialized for column [%s], cannot serialize again", this.name);
        }
        this.dictionaryWriter.write(null);
        for (String value : strings) {
            if (value == null) continue;
            this.dictionaryWriter.write(value);
        }
        this.dictionarySerialized = true;
    }

    @Override
    protected void writeValueColumn(SegmentFileBuilder fileBuilder) {
    }

    @Override
    protected void writeDictionaryFile(SegmentFileBuilder fileBuilder) throws IOException {
        if (this.dictionaryIdLookup.getStringBufferMapper() != null) {
            SegmentFileMapper fileMapper = this.dictionaryIdLookup.getStringBufferMapper();
            for (String name : fileMapper.getInternalFilenames()) {
                fileBuilder.add(name, fileMapper.mapFile(name));
            }
        } else {
            this.writeInternal(fileBuilder, this.dictionaryWriter, "__stringDictionary");
        }
    }

    @Override
    public int getCardinality() {
        if (this.writeDictionary) {
            return this.dictionaryWriter.getCardinality();
        }
        return this.dictionaryIdLookup.getStringCardinality();
    }
}

