/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.nested;

import com.google.common.base.Supplier;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import javax.annotation.Nullable;
import org.apache.druid.collections.bitmap.ImmutableBitmap;
import org.apache.druid.java.util.common.RE;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.segment.column.ColumnBuilder;
import org.apache.druid.segment.column.ColumnConfig;
import org.apache.druid.segment.column.ColumnIndexSupplier;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.StringEncodingStrategies;
import org.apache.druid.segment.data.CompressedVariableSizedBlobColumnSupplier;
import org.apache.druid.segment.data.FixedIndexed;
import org.apache.druid.segment.data.FrontCodedIntArrayIndexed;
import org.apache.druid.segment.data.Indexed;
import org.apache.druid.segment.data.VByte;
import org.apache.druid.segment.file.SegmentFileMapper;
import org.apache.druid.segment.index.SimpleImmutableBitmapIndex;
import org.apache.druid.segment.index.semantic.NullValueIndex;
import org.apache.druid.segment.nested.FieldTypeInfo;
import org.apache.druid.segment.nested.NestedCommonFormatColumn;
import org.apache.druid.segment.nested.NestedCommonFormatColumnFormatSpec;
import org.apache.druid.segment.nested.NestedDataColumnV5;
import org.apache.druid.segment.serde.ColumnSerializerUtils;
import org.apache.druid.segment.serde.NestedCommonFormatColumnPartSerde;

public class NestedDataColumnSupplier
implements Supplier<NestedCommonFormatColumn>,
ColumnIndexSupplier {
    private final String columnName;
    private final Supplier<? extends Indexed<ByteBuffer>> fieldSupplier;
    private final FieldTypeInfo fieldInfo;
    @Nullable
    private final CompressedVariableSizedBlobColumnSupplier compressedRawColumnSupplier;
    private final ImmutableBitmap nullValues;
    private final Supplier<? extends Indexed<ByteBuffer>> stringDictionarySupplier;
    private final Supplier<FixedIndexed<Long>> longDictionarySupplier;
    private final Supplier<FixedIndexed<Double>> doubleDictionarySupplier;
    private final Supplier<FrontCodedIntArrayIndexed> arrayDictionarySupplier;
    private final ColumnConfig columnConfig;
    private final SegmentFileMapper fileMapper;
    private final NestedCommonFormatColumnFormatSpec formatSpec;
    private final ByteOrder byteOrder;
    @Nullable
    private final ColumnType simpleType;

    public static NestedDataColumnSupplier read(ColumnType logicalType, boolean hasNulls, ByteBuffer bb, ColumnBuilder columnBuilder, ColumnConfig columnConfig, NestedCommonFormatColumnFormatSpec formatSpec, ByteOrder byteOrder, NestedDataColumnSupplier parent) {
        byte version = bb.get();
        int columnNameLength = VByte.readInt(bb);
        String columnName = StringUtils.fromUtf8(bb, columnNameLength);
        if (version == 0) {
            try {
                ImmutableBitmap nullValues;
                CompressedVariableSizedBlobColumnSupplier compressedRawColumnSupplier;
                Supplier<FrontCodedIntArrayIndexed> arrayDictionarySupplier;
                Object doubleDictionarySupplier;
                Object longDictionarySupplier;
                Supplier<? extends Indexed<ByteBuffer>> stringDictionarySupplier;
                FieldTypeInfo fieldInfo;
                Supplier<? extends Indexed<ByteBuffer>> fieldsSupplier;
                SegmentFileMapper mapper = columnBuilder.getFileMapper();
                if (parent != null) {
                    fieldsSupplier = parent.fieldSupplier;
                    fieldInfo = parent.fieldInfo;
                    stringDictionarySupplier = parent.stringDictionarySupplier;
                    longDictionarySupplier = parent.longDictionarySupplier;
                    doubleDictionarySupplier = parent.doubleDictionarySupplier;
                    arrayDictionarySupplier = parent.arrayDictionarySupplier;
                } else {
                    fieldsSupplier = StringEncodingStrategies.getStringDictionarySupplier(mapper, bb, byteOrder);
                    fieldInfo = FieldTypeInfo.read(bb, ((Indexed)fieldsSupplier.get()).size());
                    ByteBuffer stringDictionaryBuffer = NestedCommonFormatColumnPartSerde.loadInternalFile(mapper, columnName, "__stringDictionary");
                    ByteBuffer longDictionaryBuffer = NestedCommonFormatColumnPartSerde.loadInternalFile(mapper, columnName, "__longDictionary");
                    ByteBuffer doubleDictionaryBuffer = NestedCommonFormatColumnPartSerde.loadInternalFile(mapper, columnName, "__doubleDictionary");
                    ByteBuffer arrayDictionarybuffer = NestedCommonFormatColumnPartSerde.loadInternalFile(mapper, columnName, "__arrayDictionary");
                    stringDictionarySupplier = StringEncodingStrategies.getStringDictionarySupplier(mapper, stringDictionaryBuffer, byteOrder);
                    longDictionarySupplier = FixedIndexed.read(longDictionaryBuffer, ColumnType.LONG.getStrategy(), byteOrder, 8);
                    doubleDictionarySupplier = FixedIndexed.read(doubleDictionaryBuffer, ColumnType.DOUBLE.getStrategy(), byteOrder, 8);
                    arrayDictionarySupplier = FrontCodedIntArrayIndexed.read(arrayDictionarybuffer, byteOrder);
                }
                ByteBuffer rawBuffer = NestedCommonFormatColumnPartSerde.loadInternalFile(mapper, columnName, "__raw");
                CompressedVariableSizedBlobColumnSupplier compressedVariableSizedBlobColumnSupplier = compressedRawColumnSupplier = rawBuffer == null ? null : CompressedVariableSizedBlobColumnSupplier.fromByteBuffer(ColumnSerializerUtils.getInternalFileName(columnName, "__raw"), rawBuffer, byteOrder, byteOrder, mapper);
                if (hasNulls) {
                    columnBuilder.setHasNulls(true);
                    ByteBuffer nullIndexBuffer = NestedCommonFormatColumnPartSerde.loadInternalFile(mapper, columnName, "__nullIndex");
                    nullValues = formatSpec.getBitmapEncoding().getObjectStrategy().fromByteBufferWithSize(nullIndexBuffer);
                } else {
                    nullValues = formatSpec.getBitmapEncoding().getBitmapFactory().makeEmptyImmutableBitmap();
                }
                return new NestedDataColumnSupplier(columnName, fieldsSupplier, fieldInfo, compressedRawColumnSupplier, nullValues, stringDictionarySupplier, (Supplier<FixedIndexed<Long>>)longDictionarySupplier, (Supplier<FixedIndexed<Double>>)doubleDictionarySupplier, arrayDictionarySupplier, columnConfig, mapper, formatSpec, byteOrder, logicalType);
            }
            catch (IOException ex) {
                throw new RE(ex, "Failed to deserialize V%s column.", version);
            }
        }
        throw new RE("Unknown version " + version, new Object[0]);
    }

    private NestedDataColumnSupplier(String columnName, Supplier<? extends Indexed<ByteBuffer>> fieldSupplier, FieldTypeInfo fieldInfo, @Nullable CompressedVariableSizedBlobColumnSupplier compressedRawColumnSupplier, ImmutableBitmap nullValues, Supplier<? extends Indexed<ByteBuffer>> stringDictionarySupplier, Supplier<FixedIndexed<Long>> longDictionarySupplier, Supplier<FixedIndexed<Double>> doubleDictionarySupplier, Supplier<FrontCodedIntArrayIndexed> arrayDictionarySupplier, ColumnConfig columnConfig, SegmentFileMapper fileMapper, NestedCommonFormatColumnFormatSpec formatSpec, ByteOrder byteOrder, @Nullable ColumnType simpleType) {
        this.columnName = columnName;
        this.fieldSupplier = fieldSupplier;
        this.fieldInfo = fieldInfo;
        this.compressedRawColumnSupplier = compressedRawColumnSupplier;
        this.nullValues = nullValues;
        this.stringDictionarySupplier = stringDictionarySupplier;
        this.longDictionarySupplier = longDictionarySupplier;
        this.doubleDictionarySupplier = doubleDictionarySupplier;
        this.arrayDictionarySupplier = arrayDictionarySupplier;
        this.columnConfig = columnConfig;
        this.fileMapper = fileMapper;
        this.formatSpec = formatSpec;
        this.byteOrder = byteOrder;
        this.simpleType = simpleType;
    }

    public NestedCommonFormatColumn get() {
        return new NestedDataColumnV5<Indexed<ByteBuffer>, Indexed<ByteBuffer>>(this.columnName, this.getLogicalType(), this.columnConfig, this.compressedRawColumnSupplier, this.nullValues, this.fieldSupplier, this.fieldInfo, this.stringDictionarySupplier, this.longDictionarySupplier, this.doubleDictionarySupplier, this.arrayDictionarySupplier, this.fileMapper, this.formatSpec, this.byteOrder);
    }

    public ColumnType getLogicalType() {
        return this.simpleType == null ? ColumnType.NESTED_DATA : this.simpleType;
    }

    @Override
    @Nullable
    public <T> T as(Class<T> clazz) {
        if (clazz.equals(NullValueIndex.class)) {
            return (T)((NullValueIndex)() -> new SimpleImmutableBitmapIndex(this.nullValues));
        }
        return null;
    }
}

