/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.nested;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.WritableByteChannel;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import javax.annotation.Nullable;
import org.apache.druid.collections.bitmap.ImmutableBitmap;
import org.apache.druid.collections.bitmap.MutableBitmap;
import org.apache.druid.error.DruidException;
import org.apache.druid.java.util.common.io.Closer;
import org.apache.druid.java.util.common.io.smoosh.SmooshedWriter;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.math.expr.ExprEval;
import org.apache.druid.segment.ColumnValueSelector;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.StringEncodingStrategies;
import org.apache.druid.segment.column.Types;
import org.apache.druid.segment.column.ValueType;
import org.apache.druid.segment.data.ByteBufferWriter;
import org.apache.druid.segment.data.CompressedVariableSizedBlobColumnSerializer;
import org.apache.druid.segment.data.DictionaryWriter;
import org.apache.druid.segment.data.FixedIndexedWriter;
import org.apache.druid.segment.data.FrontCodedIntArrayIndexedWriter;
import org.apache.druid.segment.file.SegmentFileBuilder;
import org.apache.druid.segment.nested.DictionaryIdLookup;
import org.apache.druid.segment.nested.FieldTypeInfo;
import org.apache.druid.segment.nested.GlobalDictionaryEncodedFieldColumnWriter;
import org.apache.druid.segment.nested.NestedCommonFormatColumnFormatSpec;
import org.apache.druid.segment.nested.NestedCommonFormatColumnSerializer;
import org.apache.druid.segment.nested.NestedDataComplexTypeSerde;
import org.apache.druid.segment.nested.NestedPathFinder;
import org.apache.druid.segment.nested.NestedPathPart;
import org.apache.druid.segment.nested.ObjectStorageEncoding;
import org.apache.druid.segment.nested.ScalarDoubleFieldColumnWriter;
import org.apache.druid.segment.nested.ScalarLongFieldColumnWriter;
import org.apache.druid.segment.nested.ScalarStringFieldColumnWriter;
import org.apache.druid.segment.nested.StructuredData;
import org.apache.druid.segment.nested.StructuredDataProcessor;
import org.apache.druid.segment.nested.VariantArrayFieldColumnWriter;
import org.apache.druid.segment.nested.VariantFieldColumnWriter;
import org.apache.druid.segment.serde.ColumnSerializerUtils;
import org.apache.druid.segment.writeout.SegmentWriteOutMedium;

public class NestedDataColumnSerializer
extends NestedCommonFormatColumnSerializer {
    private static final Logger log = new Logger(NestedDataColumnSerializer.class);
    private final String name;
    private final SegmentWriteOutMedium segmentWriteOutMedium;
    private final NestedCommonFormatColumnFormatSpec columnFormatSpec;
    private final Closer closer;
    private final StructuredDataProcessor fieldProcessor = new StructuredDataProcessor(){

        @Override
        public StructuredDataProcessor.ProcessedValue<?> processField(ArrayList<NestedPathPart> fieldPath, @Nullable Object fieldValue) {
            GlobalDictionaryEncodedFieldColumnWriter<?> writer = NestedDataColumnSerializer.this.fieldWriters.get(NestedPathFinder.toNormalizedJsonPath(fieldPath));
            if (writer != null) {
                try {
                    ExprEval<?> eval = ExprEval.bestEffortOf(fieldValue);
                    if (eval.type().isPrimitive() || eval.type().isPrimitiveArray()) {
                        writer.addValue(NestedDataColumnSerializer.this.rowCount, eval.value());
                    } else {
                        writer.addValue(NestedDataColumnSerializer.this.rowCount, eval.asString());
                    }
                    return StructuredDataProcessor.ProcessedValue.NULL_LITERAL;
                }
                catch (IOException e) {
                    throw DruidException.defensive(e, "Failed to write field [%s], unhandled value", fieldPath);
                }
            }
            return StructuredDataProcessor.ProcessedValue.NULL_LITERAL;
        }

        @Override
        @Nullable
        public StructuredDataProcessor.ProcessedValue<?> processArrayField(ArrayList<NestedPathPart> fieldPath, @Nullable List<?> array) {
            GlobalDictionaryEncodedFieldColumnWriter<?> writer;
            ExprEval<?> eval = ExprEval.bestEffortArray(array);
            if (eval.type().isPrimitiveArray() && (writer = NestedDataColumnSerializer.this.fieldWriters.get(NestedPathFinder.toNormalizedJsonPath(fieldPath))) != null) {
                try {
                    writer.addValue(NestedDataColumnSerializer.this.rowCount, eval.value());
                    return StructuredDataProcessor.ProcessedValue.NULL_LITERAL;
                }
                catch (IOException e) {
                    throw DruidException.defensive(e, "Failed to write field [%s] value [%s]", fieldPath, array);
                }
            }
            return null;
        }
    };
    private DictionaryIdLookup globalDictionaryIdLookup;
    private SortedMap<String, FieldTypeInfo.MutableTypeSet> fields;
    private DictionaryWriter<String> fieldsWriter;
    private FieldTypeInfo.Writer fieldsInfoWriter;
    private DictionaryWriter<String> dictionaryWriter;
    private FixedIndexedWriter<Long> longDictionaryWriter;
    private FixedIndexedWriter<Double> doubleDictionaryWriter;
    private FrontCodedIntArrayIndexedWriter arrayDictionaryWriter;
    @Nullable
    private CompressedVariableSizedBlobColumnSerializer rawWriter;
    private ByteBufferWriter<ImmutableBitmap> nullBitmapWriter;
    private MutableBitmap nullRowsBitmap;
    private Map<String, GlobalDictionaryEncodedFieldColumnWriter<?>> fieldWriters;
    private int rowCount = 0;
    private boolean closedForWrite = false;
    private boolean writeDictionary = true;
    private boolean dictionarySerialized = false;
    private ByteBuffer columnNameBytes = null;

    public NestedDataColumnSerializer(String name, NestedCommonFormatColumnFormatSpec columnFormatSpec, SegmentWriteOutMedium segmentWriteOutMedium, Closer closer) {
        this.name = name;
        this.segmentWriteOutMedium = segmentWriteOutMedium;
        this.columnFormatSpec = columnFormatSpec;
        this.closer = closer;
    }

    @Override
    public String getColumnName() {
        return this.name;
    }

    @Override
    public DictionaryIdLookup getDictionaryIdLookup() {
        return this.globalDictionaryIdLookup;
    }

    @Override
    public boolean hasNulls() {
        return !this.nullRowsBitmap.isEmpty();
    }

    @Override
    public void openDictionaryWriter(File segmentBaseDir) throws IOException {
        this.fieldsWriter = StringEncodingStrategies.getStringDictionaryWriter(this.columnFormatSpec.getObjectFieldsDictionaryEncoding(), this.segmentWriteOutMedium, this.name);
        this.fieldsWriter.open();
        this.fieldsInfoWriter = new FieldTypeInfo.Writer(this.segmentWriteOutMedium);
        this.fieldsInfoWriter.open();
        this.dictionaryWriter = StringEncodingStrategies.getStringDictionaryWriter(this.columnFormatSpec.getStringDictionaryEncoding(), this.segmentWriteOutMedium, this.name);
        this.dictionaryWriter.open();
        this.longDictionaryWriter = new FixedIndexedWriter(this.segmentWriteOutMedium, ColumnType.LONG.getStrategy(), ByteOrder.nativeOrder(), 8, true);
        this.longDictionaryWriter.open();
        this.doubleDictionaryWriter = new FixedIndexedWriter(this.segmentWriteOutMedium, ColumnType.DOUBLE.getStrategy(), ByteOrder.nativeOrder(), 8, true);
        this.doubleDictionaryWriter.open();
        this.arrayDictionaryWriter = new FrontCodedIntArrayIndexedWriter(this.segmentWriteOutMedium, ByteOrder.nativeOrder(), 4);
        this.arrayDictionaryWriter.open();
        this.globalDictionaryIdLookup = this.closer.register(new DictionaryIdLookup(this.name, segmentBaseDir, this.dictionaryWriter, this.longDictionaryWriter, this.doubleDictionaryWriter, this.arrayDictionaryWriter));
    }

    @Override
    public void open() throws IOException {
        if (ObjectStorageEncoding.NONE.equals((Object)this.columnFormatSpec.getObjectStorageEncoding())) {
            this.rawWriter = null;
        } else if (ObjectStorageEncoding.SMILE.equals((Object)this.columnFormatSpec.getObjectStorageEncoding())) {
            this.rawWriter = new CompressedVariableSizedBlobColumnSerializer(ColumnSerializerUtils.getInternalFileName(this.name, "__raw"), this.segmentWriteOutMedium, this.columnFormatSpec.getObjectStorageCompression());
            this.rawWriter.open();
        } else {
            throw DruidException.defensive("Unknown object storage encoding [%s]", new Object[]{this.columnFormatSpec.getObjectStorageEncoding()});
        }
        this.nullBitmapWriter = new ByteBufferWriter<ImmutableBitmap>(this.segmentWriteOutMedium, this.columnFormatSpec.getBitmapEncoding().getObjectStrategy());
        this.nullBitmapWriter.open();
        this.nullRowsBitmap = this.columnFormatSpec.getBitmapEncoding().getBitmapFactory().makeEmptyMutableBitmap();
    }

    @Override
    public void serializeFields(SortedMap<String, FieldTypeInfo.MutableTypeSet> fields) throws IOException {
        this.fields = fields;
        this.fieldWriters = Maps.newHashMapWithExpectedSize((int)fields.size());
        int ctr = 0;
        for (Map.Entry<String, FieldTypeInfo.MutableTypeSet> field : fields.entrySet()) {
            String fieldName = field.getKey();
            String fieldFileName = "__field_" + ctr++;
            this.fieldsWriter.write(fieldName);
            this.fieldsInfoWriter.write(field.getValue());
            GlobalDictionaryEncodedFieldColumnWriter<?> writer = this.openFieldWriter(field, fieldFileName);
            this.fieldWriters.put(fieldName, writer);
        }
    }

    @Override
    public void serializeDictionaries(Iterable<String> strings, Iterable<Long> longs, Iterable<Double> doubles, Iterable<int[]> arrays) throws IOException {
        if (this.dictionarySerialized) {
            throw DruidException.defensive("String dictionary already serialized for column [%s], cannot serialize again", this.name);
        }
        this.dictionaryWriter.write(null);
        for (String string : strings) {
            if (string == null) continue;
            this.dictionaryWriter.write(string);
        }
        this.dictionarySerialized = true;
        for (Long l : longs) {
            if (l == null) continue;
            this.longDictionaryWriter.write(l);
        }
        for (Double d : doubles) {
            if (d == null) continue;
            this.doubleDictionaryWriter.write(d);
        }
        for (int[] nArray : arrays) {
            if (nArray == null) continue;
            this.arrayDictionaryWriter.write(nArray);
        }
        this.dictionarySerialized = true;
    }

    @Override
    public void serialize(ColumnValueSelector<? extends StructuredData> selector) throws IOException {
        this.serialize(StructuredData.wrap(selector.getObject()));
    }

    public void serialize(StructuredData data) throws IOException {
        if (!this.dictionarySerialized) {
            throw DruidException.defensive("Must serialize value dictionaries before serializing values for column [%s]", this.name);
        }
        if (data == null) {
            this.nullRowsBitmap.add(this.rowCount);
        }
        if (this.rawWriter != null) {
            this.rawWriter.addValue(NestedDataComplexTypeSerde.INSTANCE.toBytes(data));
        }
        if (data != null) {
            this.fieldProcessor.processFields(data.getValue());
        }
        ++this.rowCount;
    }

    private void closeForWrite() throws IOException {
        if (!this.closedForWrite) {
            this.closedForWrite = true;
            this.nullBitmapWriter.write(this.nullRowsBitmap);
            this.columnNameBytes = this.computeFilenameBytes();
        }
    }

    @Override
    public long getSerializedSize() throws IOException {
        this.closeForWrite();
        long size = 1 + this.columnNameBytes.capacity();
        if (this.writeDictionary) {
            if (this.fieldsWriter != null) {
                size += this.fieldsWriter.getSerializedSize();
            }
            if (this.fieldsInfoWriter != null) {
                size += this.fieldsInfoWriter.getSerializedSize();
            }
        }
        return size;
    }

    @Override
    public void writeTo(WritableByteChannel channel, SegmentFileBuilder fileBuilder) throws IOException {
        Preconditions.checkState((boolean)this.closedForWrite, (Object)"Not closed yet!");
        if (this.writeDictionary) {
            Preconditions.checkArgument((boolean)this.dictionaryWriter.isSorted(), (Object)"Dictionary not sorted?!?");
        }
        NestedDataColumnSerializer.writeV0Header(channel, this.columnNameBytes);
        if (this.writeDictionary) {
            this.fieldsWriter.writeTo(channel, fileBuilder);
            this.fieldsInfoWriter.writeTo(channel, fileBuilder);
            if (this.globalDictionaryIdLookup.getStringBufferMapper() != null) {
                NestedDataColumnSerializer.copyFromTempSmoosh(fileBuilder, this.globalDictionaryIdLookup.getStringBufferMapper());
            } else {
                this.writeInternal(fileBuilder, this.dictionaryWriter, "__stringDictionary");
            }
            if (this.globalDictionaryIdLookup.getLongBufferMapper() != null) {
                NestedDataColumnSerializer.copyFromTempSmoosh(fileBuilder, this.globalDictionaryIdLookup.getLongBufferMapper());
            } else {
                this.writeInternal(fileBuilder, this.longDictionaryWriter, "__longDictionary");
            }
            if (this.globalDictionaryIdLookup.getDoubleBufferMapper() != null) {
                NestedDataColumnSerializer.copyFromTempSmoosh(fileBuilder, this.globalDictionaryIdLookup.getDoubleBufferMapper());
            } else {
                this.writeInternal(fileBuilder, this.doubleDictionaryWriter, "__doubleDictionary");
            }
            if (this.globalDictionaryIdLookup.getArrayBufferMapper() != null) {
                NestedDataColumnSerializer.copyFromTempSmoosh(fileBuilder, this.globalDictionaryIdLookup.getArrayBufferMapper());
            } else {
                this.writeInternal(fileBuilder, this.arrayDictionaryWriter, "__arrayDictionary");
            }
        }
        if (this.rawWriter != null) {
            this.writeInternal(fileBuilder, this.rawWriter, "__raw");
        }
        if (!this.nullRowsBitmap.isEmpty()) {
            this.writeInternal(fileBuilder, this.nullBitmapWriter, "__nullIndex");
        }
        if (channel instanceof SmooshedWriter) {
            channel.close();
        }
        for (Map.Entry<String, FieldTypeInfo.MutableTypeSet> field : this.fields.entrySet()) {
            GlobalDictionaryEncodedFieldColumnWriter<?> writer = this.fieldWriters.remove(field.getKey());
            writer.writeTo(this.rowCount, fileBuilder);
        }
        log.info("Column [%s] serialized successfully with [%d] nested columns.", this.name, this.fields.size());
    }

    @Override
    public void setDictionaryIdLookup(DictionaryIdLookup dictionaryIdLookup) {
        this.globalDictionaryIdLookup = dictionaryIdLookup;
        this.writeDictionary = false;
        this.dictionarySerialized = true;
    }

    public void setFieldsAndOpenWriters(NestedDataColumnSerializer serializer) throws IOException {
        this.fields = serializer.fields;
        this.fieldWriters = Maps.newHashMapWithExpectedSize((int)this.fields.size());
        int ctr = 0;
        for (Map.Entry<String, FieldTypeInfo.MutableTypeSet> field : this.fields.entrySet()) {
            String fieldName = field.getKey();
            String fieldFileName = "__field_" + ctr++;
            GlobalDictionaryEncodedFieldColumnWriter<?> writer = this.openFieldWriter(field, fieldFileName);
            this.fieldWriters.put(fieldName, writer);
        }
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private GlobalDictionaryEncodedFieldColumnWriter<?> openFieldWriter(Map.Entry<String, FieldTypeInfo.MutableTypeSet> field, String fieldFileName) throws IOException {
        void var3_9;
        ColumnType type = field.getValue().getSingleType();
        if (type != null) {
            if (Types.is(type, ValueType.STRING)) {
                ScalarStringFieldColumnWriter scalarStringFieldColumnWriter = new ScalarStringFieldColumnWriter(this.name, fieldFileName, this.segmentWriteOutMedium, this.columnFormatSpec, this.globalDictionaryIdLookup);
            } else if (Types.is(type, ValueType.LONG)) {
                ScalarLongFieldColumnWriter scalarLongFieldColumnWriter = new ScalarLongFieldColumnWriter(this.name, fieldFileName, this.segmentWriteOutMedium, this.columnFormatSpec, this.globalDictionaryIdLookup);
            } else if (Types.is(type, ValueType.DOUBLE)) {
                ScalarDoubleFieldColumnWriter scalarDoubleFieldColumnWriter = new ScalarDoubleFieldColumnWriter(this.name, fieldFileName, this.segmentWriteOutMedium, this.columnFormatSpec, this.globalDictionaryIdLookup);
            } else {
                if (!Types.is(type, ValueType.ARRAY)) throw DruidException.defensive("Invalid field type [%s], how did this happen?", type);
                VariantArrayFieldColumnWriter variantArrayFieldColumnWriter = new VariantArrayFieldColumnWriter(this.name, fieldFileName, this.segmentWriteOutMedium, this.columnFormatSpec, this.globalDictionaryIdLookup);
            }
        } else {
            VariantFieldColumnWriter variantFieldColumnWriter = new VariantFieldColumnWriter(this.name, fieldFileName, this.segmentWriteOutMedium, this.columnFormatSpec, this.globalDictionaryIdLookup);
        }
        var3_9.open();
        return var3_9;
    }
}

