/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.nested;

import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import com.google.common.primitives.Doubles;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.druid.collections.bitmap.ImmutableBitmap;
import org.apache.druid.common.semantic.SemanticUtils;
import org.apache.druid.error.DruidException;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.Pair;
import org.apache.druid.java.util.common.RE;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.io.Closer;
import org.apache.druid.query.extraction.ExtractionFn;
import org.apache.druid.query.monomorphicprocessing.RuntimeShapeInspector;
import org.apache.druid.segment.BaseSingleValueDimensionSelector;
import org.apache.druid.segment.ColumnSelectorFactory;
import org.apache.druid.segment.ColumnValueSelector;
import org.apache.druid.segment.DimensionSelector;
import org.apache.druid.segment.NilColumnValueSelector;
import org.apache.druid.segment.ObjectColumnSelector;
import org.apache.druid.segment.column.BaseColumnHolder;
import org.apache.druid.segment.column.BitmapIndexType;
import org.apache.druid.segment.column.ColumnBuilder;
import org.apache.druid.segment.column.ColumnConfig;
import org.apache.druid.segment.column.ColumnIndexSupplier;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.DictionaryEncodedColumn;
import org.apache.druid.segment.column.StringEncodingStrategies;
import org.apache.druid.segment.column.TypeSignature;
import org.apache.druid.segment.column.TypeStrategies;
import org.apache.druid.segment.column.TypeStrategy;
import org.apache.druid.segment.column.ValueType;
import org.apache.druid.segment.data.AtomicIntegerReadableOffset;
import org.apache.druid.segment.data.ColumnarDoubles;
import org.apache.druid.segment.data.ColumnarInts;
import org.apache.druid.segment.data.ColumnarLongs;
import org.apache.druid.segment.data.CompressedColumnarDoublesSuppliers;
import org.apache.druid.segment.data.CompressedColumnarLongsSupplier;
import org.apache.druid.segment.data.CompressedVSizeColumnarIntsSupplier;
import org.apache.druid.segment.data.CompressedVariableSizedBlobColumn;
import org.apache.druid.segment.data.CompressedVariableSizedBlobColumnSupplier;
import org.apache.druid.segment.data.FixedIndexed;
import org.apache.druid.segment.data.FrontCodedIntArrayIndexed;
import org.apache.druid.segment.data.GenericIndexed;
import org.apache.druid.segment.data.Indexed;
import org.apache.druid.segment.data.ObjectStrategy;
import org.apache.druid.segment.data.ReadableOffset;
import org.apache.druid.segment.data.VSizeColumnarInts;
import org.apache.druid.segment.data.WritableSupplier;
import org.apache.druid.segment.file.SegmentFileMapper;
import org.apache.druid.segment.nested.FieldTypeInfo;
import org.apache.druid.segment.nested.NestedCommonFormatColumn;
import org.apache.druid.segment.nested.NestedCommonFormatColumnFormatSpec;
import org.apache.druid.segment.nested.NestedDataComplexColumn;
import org.apache.druid.segment.nested.NestedDataComplexTypeSerde;
import org.apache.druid.segment.nested.NestedFieldColumnIndexSupplier;
import org.apache.druid.segment.nested.NestedFieldDictionaryEncodedColumn;
import org.apache.druid.segment.nested.NestedPathArrayElement;
import org.apache.druid.segment.nested.NestedPathPart;
import org.apache.druid.segment.nested.StructuredDataBuilder;
import org.apache.druid.segment.serde.DictionaryEncodedColumnPartSerde;
import org.apache.druid.segment.serde.NoIndexesColumnIndexSupplier;
import org.apache.druid.segment.vector.NilVectorSelector;
import org.apache.druid.segment.vector.ReadableVectorOffset;
import org.apache.druid.segment.vector.SingleValueDimensionVectorSelector;
import org.apache.druid.segment.vector.VectorColumnSelectorFactory;
import org.apache.druid.segment.vector.VectorObjectSelector;
import org.apache.druid.segment.vector.VectorValueSelector;
import org.apache.druid.utils.CloseableUtils;

public abstract class CompressedNestedDataComplexColumn<TKeyDictionary extends Indexed<ByteBuffer>, TStringDictionary extends Indexed<ByteBuffer>>
extends NestedDataComplexColumn
implements NestedCommonFormatColumn {
    private static final Map<Class<?>, Function<CompressedNestedDataComplexColumn, ?>> AS_MAP = SemanticUtils.makeAsMap(CompressedNestedDataComplexColumn.class);
    private static final ObjectStrategy<Object> STRATEGY = NestedDataComplexTypeSerde.INSTANCE.getObjectStrategy();
    public static final IntTypeStrategy INT_TYPE_STRATEGY = new IntTypeStrategy();
    private final ColumnConfig columnConfig;
    private final Closer closer;
    @Nullable
    private final CompressedVariableSizedBlobColumnSupplier compressedRawColumnSupplier;
    private final ImmutableBitmap nullValues;
    private final Supplier<TKeyDictionary> fieldsSupplier;
    private final FieldTypeInfo fieldInfo;
    private final Supplier<TStringDictionary> stringDictionarySupplier;
    private final Supplier<FixedIndexed<Long>> longDictionarySupplier;
    private final Supplier<FixedIndexed<Double>> doubleDictionarySupplier;
    @Nullable
    private final Supplier<FrontCodedIntArrayIndexed> arrayDictionarySupplier;
    private final SegmentFileMapper fileMapper;
    private final String rootFieldPath;
    private final ColumnType logicalType;
    private final String columnName;
    private final NestedCommonFormatColumnFormatSpec formatSpec;
    private final ByteOrder byteOrder;
    private final ConcurrentHashMap<Integer, BaseColumnHolder> columns = new ConcurrentHashMap();
    private CompressedVariableSizedBlobColumn compressedRawColumn;

    public CompressedNestedDataComplexColumn(String columnName, ColumnType logicalType, ColumnConfig columnConfig, @Nullable CompressedVariableSizedBlobColumnSupplier compressedRawColumnSupplier, ImmutableBitmap nullValues, Supplier<TKeyDictionary> fieldsSupplier, FieldTypeInfo fieldInfo, Supplier<TStringDictionary> stringDictionary, Supplier<FixedIndexed<Long>> longDictionarySupplier, Supplier<FixedIndexed<Double>> doubleDictionarySupplier, @Nullable Supplier<FrontCodedIntArrayIndexed> arrayDictionarySupplier, SegmentFileMapper fileMapper, NestedCommonFormatColumnFormatSpec formatSpec, ByteOrder byteOrder, String rootFieldPath) {
        this.columnName = columnName;
        this.logicalType = logicalType;
        this.nullValues = nullValues;
        this.fieldsSupplier = fieldsSupplier;
        this.fieldInfo = fieldInfo;
        this.stringDictionarySupplier = stringDictionary;
        this.longDictionarySupplier = longDictionarySupplier;
        this.doubleDictionarySupplier = doubleDictionarySupplier;
        this.arrayDictionarySupplier = arrayDictionarySupplier;
        this.fileMapper = fileMapper;
        this.closer = Closer.create();
        this.compressedRawColumnSupplier = compressedRawColumnSupplier;
        this.formatSpec = formatSpec;
        this.byteOrder = byteOrder;
        this.rootFieldPath = rootFieldPath;
        this.columnConfig = columnConfig;
    }

    public abstract List<NestedPathPart> parsePath(String var1);

    public abstract String getField(List<NestedPathPart> var1);

    public abstract String getFieldFileName(String var1, String var2, int var3);

    @Override
    public SortedMap<String, FieldTypeInfo.MutableTypeSet> getFieldTypeInfo() {
        TreeMap<String, FieldTypeInfo.MutableTypeSet> fieldMap = new TreeMap<String, FieldTypeInfo.MutableTypeSet>();
        for (NestedField field : this.getAllNestedFields()) {
            FieldTypeInfo.TypeSet types = this.fieldInfo.getTypes(field.fieldIndex);
            fieldMap.put(field.fieldName, new FieldTypeInfo.MutableTypeSet(types.getByteValue()));
        }
        return fieldMap;
    }

    @Override
    public ColumnType getLogicalType() {
        return this.logicalType;
    }

    @Override
    public List<List<NestedPathPart>> getNestedFields() {
        return this.getAllParsedNestedFields().stream().map(pair -> (List)pair.rhs).collect(Collectors.toList());
    }

    public TStringDictionary getUtf8BytesDictionary() {
        return (TStringDictionary)((Indexed)this.stringDictionarySupplier.get());
    }

    @Override
    public Indexed<String> getStringDictionary() {
        return new StringEncodingStrategies.Utf8ToStringIndexed((Indexed)this.stringDictionarySupplier.get());
    }

    @Override
    public Indexed<Long> getLongDictionary() {
        return (Indexed)this.longDictionarySupplier.get();
    }

    @Override
    public Indexed<Double> getDoubleDictionary() {
        return (Indexed)this.doubleDictionarySupplier.get();
    }

    @Override
    public Indexed<Object[]> getArrayDictionary() {
        if (this.arrayDictionarySupplier == null) {
            return Indexed.empty();
        }
        final Iterable arrays = () -> {
            final Indexed stringDictionary = (Indexed)this.stringDictionarySupplier.get();
            final FixedIndexed longDictionary = (FixedIndexed)this.longDictionarySupplier.get();
            final FixedIndexed doubleDictionary = (FixedIndexed)this.doubleDictionarySupplier.get();
            return new Iterator<Object[]>(){
                final Iterator<int[]> delegate;
                {
                    this.delegate = ((FrontCodedIntArrayIndexed)CompressedNestedDataComplexColumn.this.arrayDictionarySupplier.get()).iterator();
                }

                @Override
                public boolean hasNext() {
                    return this.delegate.hasNext();
                }

                @Override
                public Object[] next() {
                    int[] next = this.delegate.next();
                    Object[] nextArray = new Object[next.length];
                    for (int i = 0; i < nextArray.length; ++i) {
                        nextArray[i] = this.lookupId(next[i]);
                    }
                    return nextArray;
                }

                private Object lookupId(int globalId) {
                    if (globalId == 0) {
                        return null;
                    }
                    int adjustLongId = stringDictionary.size();
                    int adjustDoubleId = stringDictionary.size() + longDictionary.size();
                    if (globalId < adjustLongId) {
                        return StringUtils.fromUtf8Nullable((ByteBuffer)stringDictionary.get(globalId));
                    }
                    if (globalId < adjustDoubleId) {
                        return longDictionary.get(globalId - adjustLongId);
                    }
                    if (globalId < adjustDoubleId + doubleDictionary.size()) {
                        return doubleDictionary.get(globalId - adjustDoubleId);
                    }
                    throw new IAE("Unknown globalId [%s]", globalId);
                }
            };
        };
        return new Indexed<Object[]>(){

            @Override
            public int size() {
                return ((FrontCodedIntArrayIndexed)CompressedNestedDataComplexColumn.this.arrayDictionarySupplier.get()).size();
            }

            @Override
            @Nullable
            public Object[] get(int index) {
                throw new UnsupportedOperationException("get not supported");
            }

            @Override
            public int indexOf(@Nullable Object[] value) {
                throw new UnsupportedOperationException("indexOf not supported");
            }

            @Override
            public Iterator<Object[]> iterator() {
                return arrays.iterator();
            }

            @Override
            public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
            }
        };
    }

    public ImmutableBitmap getNullValues() {
        return this.nullValues;
    }

    @Override
    @Nullable
    public Object getRowValue(int rowNum) {
        if (this.nullValues.get(rowNum)) {
            return null;
        }
        if (this.compressedRawColumn == null && this.compressedRawColumnSupplier != null) {
            this.compressedRawColumn = this.closer.register(this.compressedRawColumnSupplier.get());
        }
        if (this.compressedRawColumnSupplier != null) {
            ByteBuffer valueBuffer = this.compressedRawColumn.get(rowNum);
            return STRATEGY.fromByteBuffer(valueBuffer, valueBuffer.remaining());
        }
        List<StructuredDataBuilder.Element> elements = this.getAllParsedNestedFields().stream().map(pair -> {
            NestedFieldDictionaryEncodedColumn column = (NestedFieldDictionaryEncodedColumn)this.getColumnHolder(((NestedField)pair.lhs).fieldName, ((NestedField)pair.lhs).fieldIndex).getColumn();
            return StructuredDataBuilder.Element.of((List)pair.rhs, column.lookupObject(column.getSingleValueRow(rowNum)));
        }).collect(Collectors.toList());
        return new StructuredDataBuilder(elements).build();
    }

    @Override
    public ColumnValueSelector<?> makeColumnValueSelector(final ReadableOffset offset) {
        Supplier valueProvider;
        List<NestedField> allFields = this.getAllNestedFields();
        if (!this.logicalType.equals(ColumnType.NESTED_DATA) && allFields.size() == 1 && this.rootFieldPath.equals(((NestedField)Iterables.getOnlyElement(allFields)).fieldName)) {
            return this.makeColumnValueSelector((List<NestedPathPart>)ImmutableList.of(), null, offset);
        }
        if (this.compressedRawColumnSupplier != null) {
            if (this.compressedRawColumn == null) {
                this.compressedRawColumn = this.closer.register(this.compressedRawColumnSupplier.get());
            }
            valueProvider = () -> {
                ByteBuffer valueBuffer = this.compressedRawColumn.get(offset.getOffset());
                return STRATEGY.fromByteBuffer(valueBuffer, valueBuffer.remaining());
            };
        } else {
            List fieldSelectors = this.getAllParsedNestedFields().stream().map(pair -> Pair.of((List)pair.rhs, this.getColumnHolder(((NestedField)pair.lhs).fieldName, ((NestedField)pair.lhs).fieldIndex).getColumn().makeColumnValueSelector(offset))).collect(Collectors.toList());
            valueProvider = () -> {
                List<StructuredDataBuilder.Element> elements = fieldSelectors.stream().map(c -> StructuredDataBuilder.Element.of((List)c.lhs, ((ColumnValueSelector)c.rhs).getObject())).collect(Collectors.toList());
                return new StructuredDataBuilder(elements).build();
            };
        }
        return new ObjectColumnSelector(){

            @Override
            @Nullable
            public Object getObject() {
                if (CompressedNestedDataComplexColumn.this.nullValues.get(offset.getOffset())) {
                    return null;
                }
                return valueProvider.get();
            }

            @Override
            public Class classOfObject() {
                return CompressedNestedDataComplexColumn.this.getClazz();
            }

            @Override
            public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
                inspector.visit("column", CompressedNestedDataComplexColumn.this);
            }
        };
    }

    @Override
    public VectorObjectSelector makeVectorObjectSelector(final ReadableVectorOffset offset) {
        Supplier valueProvider;
        List<Pair<NestedField, List<NestedPathPart>>> allFields = this.getAllParsedNestedFields();
        if (!this.logicalType.equals(ColumnType.NESTED_DATA) && allFields.size() == 1 && this.rootFieldPath.equals(((NestedField)((Pair)Iterables.getOnlyElement(allFields)).lhs).fieldName)) {
            return this.makeVectorObjectSelector(Collections.emptyList(), null, offset);
        }
        final AtomicInteger atomicOffset = new AtomicInteger(-1);
        if (this.compressedRawColumnSupplier != null) {
            if (this.compressedRawColumn == null) {
                this.compressedRawColumn = this.closer.register(this.compressedRawColumnSupplier.get());
            }
            valueProvider = () -> {
                ByteBuffer valueBuffer = this.compressedRawColumn.get(atomicOffset.get());
                return STRATEGY.fromByteBuffer(valueBuffer, valueBuffer.remaining());
            };
        } else {
            AtomicIntegerReadableOffset readableAtomicOffset = new AtomicIntegerReadableOffset(atomicOffset);
            List fieldSelectors = allFields.stream().map(pair -> Pair.of((List)pair.rhs, this.getColumnHolder(((NestedField)pair.lhs).fieldName, ((NestedField)pair.lhs).fieldIndex).getColumn().makeColumnValueSelector(readableAtomicOffset))).collect(Collectors.toList());
            valueProvider = () -> {
                List<StructuredDataBuilder.Element> elements = fieldSelectors.stream().map(c -> StructuredDataBuilder.Element.of((List)c.lhs, ((ColumnValueSelector)c.rhs).getObject())).collect(Collectors.toList());
                return new StructuredDataBuilder(elements).build();
            };
        }
        return new VectorObjectSelector(){
            final Object[] vector;
            private int id;
            {
                this.vector = new Object[offset.getMaxVectorSize()];
                this.id = -1;
            }

            @Override
            public Object[] getObjectVector() {
                if (this.id == offset.getId()) {
                    return this.vector;
                }
                if (offset.isContiguous()) {
                    int startOffset = offset.getStartOffset();
                    int vectorSize = offset.getCurrentVectorSize();
                    for (int i = 0; i < vectorSize; ++i) {
                        this.vector[i] = this.getForOffset(startOffset + i);
                    }
                } else {
                    int[] offsets = offset.getOffsets();
                    int vectorSize = offset.getCurrentVectorSize();
                    for (int i = 0; i < vectorSize; ++i) {
                        this.vector[i] = this.getForOffset(offsets[i]);
                    }
                }
                this.id = offset.getId();
                return this.vector;
            }

            @Nullable
            private Object getForOffset(int offset2) {
                if (CompressedNestedDataComplexColumn.this.nullValues.get(offset2)) {
                    return null;
                }
                atomicOffset.set(offset2);
                return valueProvider.get();
            }

            @Override
            public int getCurrentVectorSize() {
                return offset.getCurrentVectorSize();
            }

            @Override
            public int getMaxVectorSize() {
                return offset.getMaxVectorSize();
            }
        };
    }

    @Override
    public VectorValueSelector makeVectorValueSelector(ReadableVectorOffset offset) {
        List<NestedField> allFields = this.getAllNestedFields();
        if (!this.logicalType.equals(ColumnType.NESTED_DATA) && allFields.size() == 1 && this.rootFieldPath.equals(((NestedField)Iterables.getOnlyElement(allFields)).fieldName)) {
            return this.makeVectorValueSelector(Collections.emptyList(), null, offset);
        }
        return super.makeVectorValueSelector(offset);
    }

    @Override
    public int getLength() {
        if (this.compressedRawColumn == null && this.compressedRawColumnSupplier != null) {
            this.compressedRawColumn = this.closer.register(this.compressedRawColumnSupplier.get());
        }
        return this.compressedRawColumnSupplier != null ? this.compressedRawColumn.size() : -1;
    }

    @Override
    public void close() {
        CloseableUtils.closeAndWrapExceptions(this.closer);
    }

    @Override
    public DimensionSelector makeDimensionSelector(List<NestedPathPart> path, ExtractionFn extractionFn, ColumnSelectorFactory selectorFactory, ReadableOffset readableOffset) {
        Field field = this.getNestedFieldOrNestedArrayElementFromPath(path);
        if (field instanceof NestedField) {
            DictionaryEncodedColumn col = (DictionaryEncodedColumn)this.getColumnHolder(((NestedField)field).fieldName, ((NestedField)field).fieldIndex).getColumn();
            return col.makeDimensionSelector(readableOffset, extractionFn);
        }
        if (field instanceof NestedArrayElement) {
            NestedArrayElement arrayField = (NestedArrayElement)field;
            final int elementNumber = arrayField.elementNumber;
            if (elementNumber < 0) {
                throw new IAE("Cannot make array element selector for path [%s], negative array index not supported for this selector", path);
            }
            final ColumnValueSelector<?> arraySelector = this.getColumnHolder(arrayField.nestedField.fieldName, arrayField.nestedField.fieldIndex).getColumn().makeColumnValueSelector(readableOffset);
            return new BaseSingleValueDimensionSelector(){

                @Override
                @Nullable
                protected String getValue() {
                    Object[] array;
                    Object o = arraySelector.getObject();
                    if (o instanceof Object[] && elementNumber < (array = (Object[])o).length) {
                        Object element = array[elementNumber];
                        if (element == null) {
                            return null;
                        }
                        return String.valueOf(element);
                    }
                    return null;
                }

                @Override
                public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
                    arraySelector.inspectRuntimeShape(inspector);
                }
            };
        }
        return DimensionSelector.constant(null);
    }

    @Override
    public ColumnValueSelector<?> makeColumnValueSelector(List<NestedPathPart> path, ColumnSelectorFactory selectorFactory, ReadableOffset readableOffset) {
        Field field = this.getNestedFieldOrNestedArrayElementFromPath(path);
        if (field instanceof NestedField) {
            NestedField nestedField = (NestedField)field;
            return this.getColumnHolder(nestedField.fieldName, nestedField.fieldIndex).getColumn().makeColumnValueSelector(readableOffset);
        }
        if (field instanceof NestedArrayElement) {
            NestedArrayElement arrayField = (NestedArrayElement)field;
            final int elementNumber = arrayField.elementNumber;
            if (elementNumber < 0) {
                throw DruidException.forPersona(DruidException.Persona.USER).ofCategory(DruidException.Category.INVALID_INPUT).build("Cannot make array element selector for path [%s], negative array index not supported for this selector", path);
            }
            final ColumnValueSelector<?> arraySelector = this.getColumnHolder(arrayField.nestedField.fieldName, arrayField.nestedField.fieldIndex).getColumn().makeColumnValueSelector(readableOffset);
            return new ColumnValueSelector<Object>(){

                @Override
                public boolean isNull() {
                    Object o = this.getObject();
                    return !(o instanceof Number);
                }

                @Override
                public long getLong() {
                    Object o = this.getObject();
                    return o instanceof Number ? ((Number)o).longValue() : 0L;
                }

                @Override
                public float getFloat() {
                    Object o = this.getObject();
                    return o instanceof Number ? ((Number)o).floatValue() : 0.0f;
                }

                @Override
                public double getDouble() {
                    Object o = this.getObject();
                    return o instanceof Number ? ((Number)o).doubleValue() : 0.0;
                }

                @Override
                public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
                    arraySelector.inspectRuntimeShape(inspector);
                }

                @Override
                @Nullable
                public Object getObject() {
                    Object[] array;
                    Object o = arraySelector.getObject();
                    if (o instanceof Object[] && elementNumber < (array = (Object[])o).length) {
                        return array[elementNumber];
                    }
                    return null;
                }

                @Override
                public Class<?> classOfObject() {
                    return Object.class;
                }
            };
        }
        return NilColumnValueSelector.instance();
    }

    @Override
    public SingleValueDimensionVectorSelector makeSingleValueDimensionVectorSelector(List<NestedPathPart> path, VectorColumnSelectorFactory selectorFactory, ReadableVectorOffset readableOffset) {
        Field field = this.getNestedFieldOrNestedArrayElementFromPath(path);
        if (field instanceof NestedField) {
            NestedField nestedField = (NestedField)field;
            DictionaryEncodedColumn col = (DictionaryEncodedColumn)this.getColumnHolder(nestedField.fieldName, nestedField.fieldIndex).getColumn();
            return col.makeSingleValueDimensionVectorSelector(readableOffset);
        }
        return NilVectorSelector.create(readableOffset);
    }

    @Override
    public VectorObjectSelector makeVectorObjectSelector(List<NestedPathPart> path, VectorColumnSelectorFactory selectorFactory, final ReadableVectorOffset readableOffset) {
        Field field = this.getNestedFieldOrNestedArrayElementFromPath(path);
        if (field instanceof NestedField) {
            NestedField nestedField = (NestedField)field;
            return this.getColumnHolder(nestedField.fieldName, nestedField.fieldIndex).getColumn().makeVectorObjectSelector(readableOffset);
        }
        if (field instanceof NestedArrayElement) {
            NestedArrayElement arrayField = (NestedArrayElement)field;
            final int elementNumber = arrayField.elementNumber;
            if (elementNumber < 0) {
                throw DruidException.forPersona(DruidException.Persona.USER).ofCategory(DruidException.Category.INVALID_INPUT).build("Cannot make array element selector for path [%s], negative array index not supported for this selector", path);
            }
            final VectorObjectSelector arraySelector = this.getColumnHolder(arrayField.nestedField.fieldName, arrayField.nestedField.fieldIndex).getColumn().makeVectorObjectSelector(readableOffset);
            return new VectorObjectSelector(){
                private final Object[] elements;
                private int id;
                {
                    this.elements = new Object[arraySelector.getMaxVectorSize()];
                    this.id = -1;
                }

                @Override
                public Object[] getObjectVector() {
                    if (readableOffset.getId() != this.id) {
                        Object[] delegate = arraySelector.getObjectVector();
                        for (int i = 0; i < arraySelector.getCurrentVectorSize(); ++i) {
                            Object maybeArray = delegate[i];
                            if (maybeArray instanceof Object[]) {
                                Object[] anArray = (Object[])maybeArray;
                                if (elementNumber < anArray.length) {
                                    Object element;
                                    this.elements[i] = element = anArray[elementNumber];
                                    continue;
                                }
                                this.elements[i] = null;
                                continue;
                            }
                            this.elements[i] = null;
                        }
                        this.id = readableOffset.getId();
                    }
                    return this.elements;
                }

                @Override
                public int getMaxVectorSize() {
                    return arraySelector.getMaxVectorSize();
                }

                @Override
                public int getCurrentVectorSize() {
                    return arraySelector.getCurrentVectorSize();
                }
            };
        }
        return NilVectorSelector.create(readableOffset);
    }

    @Override
    public VectorValueSelector makeVectorValueSelector(List<NestedPathPart> path, VectorColumnSelectorFactory selectorFactory, final ReadableVectorOffset readableOffset) {
        Field field = this.getNestedFieldOrNestedArrayElementFromPath(path);
        if (field instanceof NestedField) {
            NestedField nestedField = (NestedField)field;
            return this.getColumnHolder(nestedField.fieldName, nestedField.fieldIndex).getColumn().makeVectorValueSelector(readableOffset);
        }
        if (field instanceof NestedArrayElement) {
            NestedArrayElement arrayField = (NestedArrayElement)field;
            final int elementNumber = arrayField.elementNumber;
            if (elementNumber < 0) {
                throw DruidException.forPersona(DruidException.Persona.USER).ofCategory(DruidException.Category.INVALID_INPUT).build("Cannot make array element selector for path [%s], negative array index not supported for this selector", path);
            }
            final VectorObjectSelector arraySelector = this.getColumnHolder(arrayField.nestedField.fieldName, arrayField.nestedField.fieldIndex).getColumn().makeVectorObjectSelector(readableOffset);
            return new VectorValueSelector(){
                private final long[] longs;
                private final double[] doubles;
                private final float[] floats;
                private final boolean[] nulls;
                private int id;
                {
                    this.longs = new long[readableOffset.getMaxVectorSize()];
                    this.doubles = new double[readableOffset.getMaxVectorSize()];
                    this.floats = new float[readableOffset.getMaxVectorSize()];
                    this.nulls = new boolean[readableOffset.getMaxVectorSize()];
                    this.id = -1;
                }

                private void computeNumbers() {
                    if (readableOffset.getId() != this.id) {
                        Object[] maybeArrays = arraySelector.getObjectVector();
                        for (int i = 0; i < arraySelector.getCurrentVectorSize(); ++i) {
                            Object maybeArray = maybeArrays[i];
                            if (maybeArray instanceof Object[]) {
                                Object[] anArray = (Object[])maybeArray;
                                if (elementNumber < anArray.length) {
                                    Double d;
                                    if (anArray[elementNumber] instanceof Number) {
                                        Number n = (Number)anArray[elementNumber];
                                        this.longs[i] = n.longValue();
                                        this.doubles[i] = n.doubleValue();
                                        this.floats[i] = n.floatValue();
                                        this.nulls[i] = false;
                                        continue;
                                    }
                                    Double d2 = d = anArray[elementNumber] instanceof String ? Doubles.tryParse((String)((String)anArray[elementNumber])) : null;
                                    if (d != null) {
                                        this.longs[i] = d.longValue();
                                        this.doubles[i] = d;
                                        this.floats[i] = d.floatValue();
                                        this.nulls[i] = false;
                                        continue;
                                    }
                                    this.nullElement(i);
                                    continue;
                                }
                                this.nullElement(i);
                                continue;
                            }
                            this.nullElement(i);
                        }
                        this.id = readableOffset.getId();
                    }
                }

                private void nullElement(int i) {
                    this.longs[i] = 0L;
                    this.doubles[i] = 0.0;
                    this.floats[i] = 0.0f;
                    this.nulls[i] = true;
                }

                @Override
                public long[] getLongVector() {
                    if (readableOffset.getId() != this.id) {
                        this.computeNumbers();
                    }
                    return this.longs;
                }

                @Override
                public float[] getFloatVector() {
                    if (readableOffset.getId() != this.id) {
                        this.computeNumbers();
                    }
                    return this.floats;
                }

                @Override
                public double[] getDoubleVector() {
                    if (readableOffset.getId() != this.id) {
                        this.computeNumbers();
                    }
                    return this.doubles;
                }

                @Override
                @Nullable
                public boolean[] getNullVector() {
                    if (readableOffset.getId() != this.id) {
                        this.computeNumbers();
                    }
                    return this.nulls;
                }

                @Override
                public int getMaxVectorSize() {
                    return arraySelector.getMaxVectorSize();
                }

                @Override
                public int getCurrentVectorSize() {
                    return arraySelector.getCurrentVectorSize();
                }
            };
        }
        return NilVectorSelector.create(readableOffset);
    }

    @Override
    @Nullable
    public Set<ColumnType> getFieldTypes(List<NestedPathPart> path) {
        Field field = this.getNestedFieldOrNestedArrayElementFromPath(path);
        if (field instanceof NestedField) {
            return FieldTypeInfo.convertToSet(this.fieldInfo.getTypes(((NestedField)field).fieldIndex).getByteValue());
        }
        if (field instanceof NestedArrayElement) {
            NestedArrayElement arrayField = (NestedArrayElement)field;
            Set<ColumnType> arrayFieldTypes = FieldTypeInfo.convertToSet(this.fieldInfo.getTypes(arrayField.nestedField.fieldIndex).getByteValue());
            HashSet elementTypes = Sets.newHashSetWithExpectedSize((int)arrayFieldTypes.size());
            for (ColumnType type : arrayFieldTypes) {
                if (type.isArray()) {
                    elementTypes.add((ColumnType)type.getElementType());
                    continue;
                }
                elementTypes.add(type);
            }
            return elementTypes;
        }
        return null;
    }

    @Override
    @Nullable
    public ColumnType getFieldLogicalType(List<NestedPathPart> path) {
        Field field = this.getNestedFieldOrNestedArrayElementFromPath(path);
        if (field instanceof NestedField) {
            Set<ColumnType> fieldTypes = FieldTypeInfo.convertToSet(this.fieldInfo.getTypes(((NestedField)field).fieldIndex).getByteValue());
            return ColumnType.leastRestrictiveType(fieldTypes);
        }
        if (field instanceof NestedArrayElement) {
            NestedArrayElement arrayField = (NestedArrayElement)field;
            Set<ColumnType> arrayFieldTypes = FieldTypeInfo.convertToSet(this.fieldInfo.getTypes(arrayField.nestedField.fieldIndex).getByteValue());
            ColumnType leastRestrictiveType = null;
            for (ColumnType type : arrayFieldTypes) {
                if (type.isArray()) {
                    leastRestrictiveType = ColumnType.leastRestrictiveType(leastRestrictiveType, (ColumnType)type.getElementType());
                    continue;
                }
                leastRestrictiveType = ColumnType.leastRestrictiveType(leastRestrictiveType, type);
            }
            return leastRestrictiveType;
        }
        return null;
    }

    @Override
    @Nullable
    public BaseColumnHolder getColumnHolder(List<NestedPathPart> path) {
        Field field = this.getNestedFieldOrNestedArrayElementFromPath(path);
        if (field instanceof NestedField) {
            NestedField nestedField = (NestedField)field;
            return this.getColumnHolder(nestedField.fieldName, nestedField.fieldIndex);
        }
        return null;
    }

    @Override
    @Nullable
    public ColumnIndexSupplier getColumnIndexSupplier(List<NestedPathPart> path) {
        Field field = this.getNestedFieldOrNestedArrayElementFromPath(path);
        if (field instanceof NestedField) {
            NestedField nestedField = (NestedField)field;
            return this.getColumnHolder(nestedField.fieldName, nestedField.fieldIndex).getIndexSupplier();
        }
        if (field instanceof NestedArrayElement) {
            return NoIndexesColumnIndexSupplier.getInstance();
        }
        return null;
    }

    @Override
    public boolean isNumeric(List<NestedPathPart> path) {
        Field field = this.getNestedFieldOrNestedArrayElementFromPath(path);
        if (field instanceof NestedField) {
            NestedField nestedField = (NestedField)field;
            return this.getColumnHolder(nestedField.fieldName, nestedField.fieldIndex).getCapabilities().isNumeric();
        }
        if (field instanceof NestedArrayElement) {
            NestedArrayElement element = (NestedArrayElement)field;
            TypeSignature elementType = this.getColumnHolder(element.nestedField.fieldName, element.nestedField.fieldIndex).getCapabilities().getElementType();
            if (elementType != null) {
                return elementType.isNumeric();
            }
            return false;
        }
        return field == null;
    }

    @Override
    @Nullable
    public <T> T as(Class<T> clazz) {
        Function<CompressedNestedDataComplexColumn, ?> asFn = AS_MAP.get(clazz);
        if (asFn != null) {
            return (T)asFn.apply(this);
        }
        return super.as(clazz);
    }

    private BaseColumnHolder getColumnHolder(String field, int fieldIndex) {
        return this.columns.computeIfAbsent(fieldIndex, f -> this.readNestedFieldColumn(field, fieldIndex));
    }

    @Nullable
    private BaseColumnHolder readNestedFieldColumn(String field, int fieldIndex) {
        try {
            ImmutableBitmap nullBitmap;
            if (fieldIndex < 0) {
                return null;
            }
            FieldTypeInfo.TypeSet types = this.fieldInfo.getTypes(fieldIndex);
            String fieldFileName = this.getFieldFileName(this.columnName, field, fieldIndex);
            ByteBuffer dataBuffer = this.fileMapper.mapFile(fieldFileName);
            if (dataBuffer == null) {
                throw new ISE("Can't find field [%s] with name [%s] in [%s] file.", field, fieldFileName, this.columnName);
            }
            ColumnBuilder columnBuilder = new ColumnBuilder().setFileMapper(this.fileMapper);
            DictionaryEncodedColumnPartSerde.VERSION version = DictionaryEncodedColumnPartSerde.VERSION.fromByte(dataBuffer.get());
            int flags = dataBuffer.getInt();
            if (flags != 0) {
                throw DruidException.defensive("Unrecognized bits set in space reserved for future flags for field column [%s]", field);
            }
            Supplier<FixedIndexed<Integer>> localDictionarySupplier = FixedIndexed.read(dataBuffer, INT_TYPE_STRATEGY, this.byteOrder, 4);
            ByteBuffer bb = dataBuffer.asReadOnlyBuffer().order(this.byteOrder);
            int longsLength = bb.getInt();
            int doublesLength = bb.getInt();
            dataBuffer.position(dataBuffer.position() + 4 + 4);
            int pos = dataBuffer.position();
            Supplier longs = longsLength > 0 ? CompressedColumnarLongsSupplier.fromByteBuffer(dataBuffer, this.byteOrder, columnBuilder.getFileMapper()) : () -> null;
            dataBuffer.position(pos + longsLength);
            pos = dataBuffer.position();
            Supplier<ColumnarDoubles> doubles = doublesLength > 0 ? CompressedColumnarDoublesSuppliers.fromByteBuffer(dataBuffer, this.byteOrder, columnBuilder.getFileMapper()) : () -> null;
            dataBuffer.position(pos + doublesLength);
            WritableSupplier<ColumnarInts> ints = version == DictionaryEncodedColumnPartSerde.VERSION.COMPRESSED ? CompressedVSizeColumnarIntsSupplier.fromByteBuffer(dataBuffer, this.byteOrder, columnBuilder.getFileMapper()) : VSizeColumnarInts.readFromByteBuffer(dataBuffer);
            ColumnType theType = types.getSingleType();
            columnBuilder.setHasMultipleValues(false).setType(theType != null ? theType : ColumnType.leastRestrictiveType(FieldTypeInfo.convertToSet(types.getByteValue())));
            BitmapIndexType indexType = theType != null ? (theType.getType() == ValueType.LONG ? this.formatSpec.getLongFieldBitmapIndexType() : (theType.getType() == ValueType.DOUBLE ? this.formatSpec.getDoubleFieldBitmapIndexType() : null)) : null;
            if (indexType == null || indexType instanceof BitmapIndexType.DictionaryEncodedValueIndex) {
                GenericIndexed<ImmutableBitmap> arrayElementBitmaps;
                Supplier<FixedIndexed<Integer>> arrayElementDictionarySupplier;
                GenericIndexed<ImmutableBitmap> rBitmaps = BitmapIndexType.DictionaryEncodedValueIndex.read(dataBuffer, this.formatSpec.getBitmapEncoding().getObjectStrategy(), columnBuilder.getFileMapper());
                if (dataBuffer.hasRemaining()) {
                    arrayElementDictionarySupplier = FixedIndexed.read(dataBuffer, INT_TYPE_STRATEGY, this.byteOrder, 4);
                    arrayElementBitmaps = GenericIndexed.read(dataBuffer, this.formatSpec.getBitmapEncoding().getObjectStrategy(), columnBuilder.getFileMapper());
                } else {
                    arrayElementDictionarySupplier = null;
                    arrayElementBitmaps = null;
                }
                boolean hasNull = (Integer)((FixedIndexed)localDictionarySupplier.get()).get(0) == 0;
                nullBitmap = hasNull ? (ImmutableBitmap)rBitmaps.get(0) : this.formatSpec.getBitmapEncoding().getBitmapFactory().makeEmptyImmutableBitmap();
                columnBuilder.setHasNulls(hasNull).setIndexSupplier(new NestedFieldColumnIndexSupplier<TStringDictionary>(types, this.formatSpec.getBitmapEncoding().getBitmapFactory(), this.columnConfig, rBitmaps, localDictionarySupplier, this.stringDictionarySupplier, this.longDictionarySupplier, this.doubleDictionarySupplier, this.arrayDictionarySupplier, arrayElementDictionarySupplier, arrayElementBitmaps), true, false);
            } else if (indexType instanceof BitmapIndexType.NullValueIndex) {
                nullBitmap = BitmapIndexType.NullValueIndex.read(dataBuffer, this.formatSpec.getBitmapEncoding().getObjectStrategy());
                columnBuilder.setHasNulls(!nullBitmap.isEmpty()).setNullValueIndexSupplier(nullBitmap);
            } else {
                throw DruidException.defensive("Unsupported BitmapIndexType[%s]", indexType);
            }
            columnBuilder.setDictionaryEncodedColumnSupplier(() -> this.closer.register(new NestedFieldDictionaryEncodedColumn<Indexed>(types, (ColumnarLongs)longs.get(), (ColumnarDoubles)doubles.get(), (ColumnarInts)ints.get(), (Indexed)this.stringDictionarySupplier.get(), (FixedIndexed)this.longDictionarySupplier.get(), (FixedIndexed)this.doubleDictionarySupplier.get(), this.arrayDictionarySupplier != null ? (FrontCodedIntArrayIndexed)this.arrayDictionarySupplier.get() : null, (FixedIndexed)localDictionarySupplier.get(), nullBitmap)));
            return columnBuilder.build();
        }
        catch (IOException ex) {
            throw new RE(ex, "Failed to read data for [%s]", field);
        }
    }

    private List<NestedField> getAllNestedFields() {
        Indexed fields = (Indexed)this.fieldsSupplier.get();
        ArrayList<NestedField> allFields = new ArrayList<NestedField>(fields.size());
        for (int i = 0; i < fields.size(); ++i) {
            String field = StringUtils.fromUtf8((ByteBuffer)fields.get(i));
            allFields.add(new NestedField(field, i));
        }
        return allFields;
    }

    private List<Pair<NestedField, List<NestedPathPart>>> getAllParsedNestedFields() {
        Indexed fields = (Indexed)this.fieldsSupplier.get();
        ArrayList<Pair<NestedField, List<NestedPathPart>>> allFields = new ArrayList<Pair<NestedField, List<NestedPathPart>>>(fields.size());
        for (int i = 0; i < fields.size(); ++i) {
            String field = StringUtils.fromUtf8((ByteBuffer)fields.get(i));
            allFields.add(Pair.of(new NestedField(field, i), this.parsePath(field)));
        }
        return allFields;
    }

    @Nullable
    private Field getNestedFieldOrNestedArrayElementFromPath(List<NestedPathPart> path) {
        Indexed fields = (Indexed)this.fieldsSupplier.get();
        ArrayList<List<NestedPathPart>> parsed = new ArrayList<List<NestedPathPart>>(fields.size());
        for (int i = 0; i < fields.size(); ++i) {
            String field = StringUtils.fromUtf8((ByteBuffer)fields.get(i));
            parsed.add(this.parsePath(field));
            if (!((List)parsed.get(i)).equals(path)) continue;
            return new NestedField(field, i);
        }
        if (!path.isEmpty() && path.get(path.size() - 1) instanceof NestedPathArrayElement) {
            List<NestedPathPart> arrayPath = path.subList(0, path.size() - 1);
            for (int i = 0; i < fields.size(); ++i) {
                if (!((List)parsed.get(i)).equals(arrayPath)) continue;
                return new NestedArrayElement(new NestedField(StringUtils.fromUtf8((ByteBuffer)fields.get(i)), i), ((NestedPathArrayElement)path.get(path.size() - 1)).getIndex());
            }
        }
        return null;
    }

    private static class NestedField
    implements Field {
        private final String fieldName;
        private final int fieldIndex;

        NestedField(String fieldName, int fieldIndex) {
            this.fieldName = fieldName;
            this.fieldIndex = fieldIndex;
        }
    }

    static interface Field {
    }

    private static class NestedArrayElement
    implements Field {
        private final NestedField nestedField;
        private final int elementNumber;

        NestedArrayElement(NestedField nestedField, int elementNumber) {
            this.nestedField = nestedField;
            this.elementNumber = elementNumber;
        }
    }

    private static final class IntTypeStrategy
    implements TypeStrategy<Integer> {
        private IntTypeStrategy() {
        }

        @Override
        public int estimateSizeBytes(Integer value) {
            return 4;
        }

        @Override
        public Integer read(ByteBuffer buffer) {
            return buffer.getInt();
        }

        @Override
        public Integer read(ByteBuffer buffer, int offset) {
            return buffer.getInt(offset);
        }

        @Override
        public boolean readRetainsBufferReference() {
            return false;
        }

        @Override
        public int write(ByteBuffer buffer, Integer value, int maxSizeBytes) {
            TypeStrategies.checkMaxSize(buffer.remaining(), maxSizeBytes, ColumnType.LONG);
            int sizeBytes = 4;
            int remaining = maxSizeBytes - 4;
            if (remaining >= 0) {
                buffer.putInt(value);
                return 4;
            }
            return remaining;
        }

        @Override
        public int compare(Object o1, Object o2) {
            return Integer.compare(((Number)o1).intValue(), ((Number)o2).intValue());
        }
    }
}

