/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.index;

import javax.annotation.Nullable;
import org.apache.druid.collections.bitmap.BitmapFactory;
import org.apache.druid.collections.bitmap.ImmutableBitmap;
import org.apache.druid.segment.data.Indexed;
import org.apache.druid.segment.index.semantic.DictionaryEncodedStringValueIndex;

public final class IndexedStringDictionaryEncodedStringValueIndex<TDictionary extends Indexed<String>>
implements DictionaryEncodedStringValueIndex {
    private final BitmapFactory bitmapFactory;
    private final TDictionary dictionary;
    private final Indexed<ImmutableBitmap> bitmaps;

    public IndexedStringDictionaryEncodedStringValueIndex(BitmapFactory bitmapFactory, TDictionary dictionary, Indexed<ImmutableBitmap> bitmaps) {
        this.bitmapFactory = bitmapFactory;
        this.dictionary = dictionary;
        this.bitmaps = bitmaps;
    }

    @Override
    public int getCardinality() {
        return this.dictionary.size();
    }

    @Override
    @Nullable
    public String getValue(int index) {
        return (String)this.dictionary.get(index);
    }

    @Override
    public BitmapFactory getBitmapFactory() {
        return this.bitmapFactory;
    }

    @Override
    public ImmutableBitmap getBitmap(int idx) {
        if (idx < 0) {
            return this.bitmapFactory.makeEmptyImmutableBitmap();
        }
        ImmutableBitmap bitmap = this.bitmaps.get(idx);
        return bitmap == null ? this.bitmapFactory.makeEmptyImmutableBitmap() : bitmap;
    }
}

