/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.incremental;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.primitives.Ints;
import com.google.common.primitives.Longs;
import com.google.errorprone.annotations.concurrent.GuardedBy;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.druid.data.input.InputRow;
import org.apache.druid.data.input.ListBasedInputRow;
import org.apache.druid.data.input.MapBasedInputRow;
import org.apache.druid.data.input.Row;
import org.apache.druid.data.input.impl.DimensionSchema;
import org.apache.druid.data.input.impl.DimensionsSpec;
import org.apache.druid.data.input.impl.SpatialDimensionSchema;
import org.apache.druid.error.DruidException;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.granularity.Granularity;
import org.apache.druid.java.util.common.parsers.ParseException;
import org.apache.druid.java.util.common.parsers.UnparseableColumnsParseException;
import org.apache.druid.query.OrderBy;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.PostAggregator;
import org.apache.druid.query.dimension.DimensionSpec;
import org.apache.druid.query.monomorphicprocessing.RuntimeShapeInspector;
import org.apache.druid.segment.ColumnInspector;
import org.apache.druid.segment.ColumnSelectorFactory;
import org.apache.druid.segment.ColumnValueSelector;
import org.apache.druid.segment.CursorBuildSpec;
import org.apache.druid.segment.DimensionHandler;
import org.apache.druid.segment.DimensionHandlerUtils;
import org.apache.druid.segment.DimensionIndexer;
import org.apache.druid.segment.DimensionSelector;
import org.apache.druid.segment.DoubleColumnSelector;
import org.apache.druid.segment.EncodedKeyComponent;
import org.apache.druid.segment.FloatColumnSelector;
import org.apache.druid.segment.IndexSpec;
import org.apache.druid.segment.LongColumnSelector;
import org.apache.druid.segment.Metadata;
import org.apache.druid.segment.NestedCommonFormatColumnHandler;
import org.apache.druid.segment.NilColumnValueSelector;
import org.apache.druid.segment.ObjectColumnSelector;
import org.apache.druid.segment.RowAdapters;
import org.apache.druid.segment.RowBasedColumnSelectorFactory;
import org.apache.druid.segment.VirtualColumns;
import org.apache.druid.segment.column.CapabilitiesBasedFormat;
import org.apache.druid.segment.column.ColumnCapabilities;
import org.apache.druid.segment.column.ColumnCapabilitiesImpl;
import org.apache.druid.segment.column.ColumnFormat;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.segment.column.ValueType;
import org.apache.druid.segment.incremental.IncrementalIndexAddResult;
import org.apache.druid.segment.incremental.IncrementalIndexRow;
import org.apache.druid.segment.incremental.IncrementalIndexRowHolder;
import org.apache.druid.segment.incremental.IncrementalIndexRowSelector;
import org.apache.druid.segment.incremental.IncrementalIndexSchema;
import org.apache.druid.segment.incremental.SpatialDimensionRowTransformer;
import org.apache.druid.segment.projections.QueryableProjection;
import org.apache.druid.segment.serde.ComplexMetricExtractor;
import org.apache.druid.segment.serde.ComplexMetricSerde;
import org.apache.druid.segment.serde.ComplexMetrics;
import org.apache.druid.segment.transform.TransformedInputRow;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.joda.time.ReadableInstant;

public abstract class IncrementalIndex
implements IncrementalIndexRowSelector,
ColumnInspector,
Iterable<Row>,
Closeable {
    private final long minTimestamp;
    private final Granularity queryGranularity;
    private final boolean rollup;
    private final List<Function<InputRow, InputRow>> rowTransformers;
    private final VirtualColumns virtualColumns;
    private final AggregatorFactory[] metrics;
    private final Metadata metadata;
    protected final boolean preserveExistingMetrics;
    private final Map<String, MetricDesc> metricDescs;
    private final DimensionsSpec dimensionsSpec;
    private final Map<String, DimensionDesc> dimensionDescs;
    protected final int timePosition;
    private final List<DimensionDesc> dimensionDescsList;
    private final Map<String, ColumnCapabilities> timeAndMetricsColumnCapabilities;
    private final Map<String, ColumnFormat> timeAndMetricsColumnFormats;
    private final AtomicInteger numEntries = new AtomicInteger();
    private final AtomicLong bytesInMemory = new AtomicLong();
    private final boolean useSchemaDiscovery;
    protected final InputRowHolder inputRowHolder = new InputRowHolder();
    @Nullable
    private volatile DateTime maxIngestedEventTime;

    public static ColumnSelectorFactory makeColumnSelectorFactory(VirtualColumns virtualColumns, final InputRowHolder inputRowHolder, final @Nullable AggregatorFactory agg) {
        final RowBasedColumnSelectorFactory<InputRow> baseSelectorFactory = new RowBasedColumnSelectorFactory<InputRow>(inputRowHolder::getRow, inputRowHolder::getRowId, RowAdapters.standardRow(), RowSignature.empty(), true, true);
        class IncrementalIndexInputRowColumnSelectorFactory
        implements ColumnSelectorFactory {
            IncrementalIndexInputRowColumnSelectorFactory() {
            }

            @Override
            public ColumnValueSelector<?> makeColumnValueSelector(final String column) {
                final ColumnValueSelector<?> selector = baseSelectorFactory.makeColumnValueSelector(column);
                if (agg == null || !agg.getIntermediateType().is(ValueType.COMPLEX)) {
                    return selector;
                }
                String complexTypeName = agg.getIntermediateType().getComplexTypeName();
                ComplexMetricSerde serde = ComplexMetrics.getSerdeForType(complexTypeName);
                if (serde == null) {
                    throw new ISE("Don't know how to handle type[%s]", complexTypeName);
                }
                final ComplexMetricExtractor extractor = serde.getExtractor();
                return new ColumnValueSelector(){

                    @Override
                    public boolean isNull() {
                        return selector.isNull();
                    }

                    @Override
                    public long getLong() {
                        return selector.getLong();
                    }

                    @Override
                    public float getFloat() {
                        return selector.getFloat();
                    }

                    @Override
                    public double getDouble() {
                        return selector.getDouble();
                    }

                    @Override
                    public Class classOfObject() {
                        return extractor.extractedClass();
                    }

                    @Override
                    @Nullable
                    public Object getObject() {
                        return extractor.extractValue(inputRowHolder.getRow(), column, agg);
                    }

                    @Override
                    public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
                        inspector.visit("inputRowHolder", inputRowHolder);
                        inspector.visit("selector", selector);
                        inspector.visit("extractor", extractor);
                    }
                };
            }

            @Override
            public DimensionSelector makeDimensionSelector(DimensionSpec dimensionSpec) {
                return baseSelectorFactory.makeDimensionSelector(dimensionSpec);
            }

            @Override
            @Nullable
            public ColumnCapabilities getColumnCapabilities(String columnName) {
                return baseSelectorFactory.getColumnCapabilities(columnName);
            }
        }
        return virtualColumns.wrap(new IncrementalIndexInputRowColumnSelectorFactory());
    }

    protected IncrementalIndex(IncrementalIndexSchema incrementalIndexSchema, boolean preserveExistingMetrics) {
        this.minTimestamp = incrementalIndexSchema.getMinTimestamp();
        this.queryGranularity = incrementalIndexSchema.getQueryGranularity();
        this.rollup = incrementalIndexSchema.isRollup();
        this.virtualColumns = incrementalIndexSchema.getVirtualColumns();
        this.metrics = incrementalIndexSchema.getMetrics();
        this.rowTransformers = new CopyOnWriteArrayList<Function<InputRow, InputRow>>();
        this.preserveExistingMetrics = preserveExistingMetrics;
        this.useSchemaDiscovery = incrementalIndexSchema.getDimensionsSpec().useSchemaDiscovery();
        this.timeAndMetricsColumnCapabilities = new HashMap<String, ColumnCapabilities>();
        this.timeAndMetricsColumnFormats = new HashMap<String, ColumnFormat>();
        this.metricDescs = Maps.newLinkedHashMap();
        this.dimensionDescs = Maps.newLinkedHashMap();
        this.initAggs(this.metrics, this.inputRowHolder);
        for (AggregatorFactory metric : this.metrics) {
            MetricDesc metricDesc = new MetricDesc(this.metricDescs.size(), metric);
            this.metricDescs.put(metricDesc.getName(), metricDesc);
            ColumnCapabilities capabilities = metricDesc.getCapabilities();
            this.timeAndMetricsColumnCapabilities.put(metricDesc.getName(), capabilities);
            if (capabilities.is(ValueType.COMPLEX)) {
                this.timeAndMetricsColumnFormats.put(metricDesc.getName(), new CapabilitiesBasedFormat(ColumnCapabilitiesImpl.snapshot(ColumnCapabilitiesImpl.copyOf(capabilities).setType(ColumnType.ofComplex(metricDesc.getType())), ColumnCapabilitiesImpl.ALL_FALSE)));
                continue;
            }
            this.timeAndMetricsColumnFormats.put(metricDesc.getName(), new CapabilitiesBasedFormat(ColumnCapabilitiesImpl.snapshot(capabilities, ColumnCapabilitiesImpl.ALL_FALSE)));
        }
        this.dimensionsSpec = incrementalIndexSchema.getDimensionsSpec();
        this.dimensionDescsList = new ArrayList<DimensionDesc>();
        int foundTimePosition = -1;
        List<DimensionSchema> dimSchemas = this.dimensionsSpec.getDimensions();
        for (int i = 0; i < dimSchemas.size(); ++i) {
            DimensionSchema dimSchema = dimSchemas.get(i);
            if ("__time".equals(dimSchema.getName())) {
                foundTimePosition = i;
                continue;
            }
            this.addNewDimension(dimSchema.getName(), dimSchema.getDimensionHandler());
        }
        this.timePosition = foundTimePosition == -1 ? (this.dimensionsSpec.isForceSegmentSortByTime() ? 0 : this.dimensionDescsList.size()) : foundTimePosition;
        this.timeAndMetricsColumnCapabilities.put("__time", ColumnCapabilitiesImpl.createSimpleNumericColumnCapabilities(ColumnType.LONG));
        List<SpatialDimensionSchema> spatialDimensions = this.dimensionsSpec.getSpatialDimensions();
        if (!spatialDimensions.isEmpty()) {
            this.rowTransformers.add(new SpatialDimensionRowTransformer(spatialDimensions));
        }
        this.metadata = new Metadata(null, IncrementalIndex.getCombiningAggregators(this.metrics), incrementalIndexSchema.getTimestampSpec(), this.queryGranularity, this.rollup, this.getDimensionOrder().stream().map(OrderBy::ascending).collect(Collectors.toList()), Collections.emptyList());
    }

    @Nullable
    public abstract QueryableProjection<IncrementalIndexRowSelector> getProjection(CursorBuildSpec var1);

    public abstract IncrementalIndexRowSelector getProjection(String var1);

    public abstract boolean canAppendRow();

    public abstract String getOutOfRowsReason();

    protected abstract void initAggs(AggregatorFactory[] var1, InputRowHolder var2);

    protected abstract AddToFactsResult addToFacts(IncrementalIndexRow var1, InputRowHolder var2);

    public abstract Iterable<Row> iterableWithPostAggregations(@Nullable List<PostAggregator> var1, boolean var2);

    public boolean isRollup() {
        return this.rollup;
    }

    @Override
    public void close() {
    }

    public InputRow formatRow(InputRow row) {
        for (Function<InputRow, InputRow> rowTransformer : this.rowTransformers) {
            row = (InputRow)rowTransformer.apply((Object)row);
        }
        if (row == null) {
            throw new IAE("Row is null? How can this be?!", new Object[0]);
        }
        return row;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, ColumnFormat> getColumnFormats() {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        Map<String, DimensionDesc> map = this.dimensionDescs;
        synchronized (map) {
            this.timeAndMetricsColumnFormats.forEach((arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
            this.dimensionDescs.forEach((? super K dimension, ? super V desc) -> builder.put(dimension, (Object)desc.getIndexer().getFormat()));
        }
        return builder.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public ColumnCapabilities getColumnCapabilities(String columnName) {
        if (this.timeAndMetricsColumnCapabilities.containsKey(columnName)) {
            return this.timeAndMetricsColumnCapabilities.get(columnName);
        }
        Map<String, DimensionDesc> map = this.dimensionDescs;
        synchronized (map) {
            DimensionDesc desc = this.dimensionDescs.get(columnName);
            return desc != null ? desc.getCapabilities() : null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public ColumnFormat getColumnFormat(String columnName) {
        if (this.timeAndMetricsColumnFormats.containsKey(columnName)) {
            return this.timeAndMetricsColumnFormats.get(columnName);
        }
        Map<String, DimensionDesc> map = this.dimensionDescs;
        synchronized (map) {
            DimensionDesc desc = this.dimensionDescs.get(columnName);
            return desc != null ? desc.getIndexer().getFormat() : null;
        }
    }

    public IncrementalIndexAddResult add(InputRow row) {
        IncrementalIndexRowResult incrementalIndexRowResult = this.toIncrementalIndexRow(row);
        this.inputRowHolder.set(row);
        AddToFactsResult addToFactsResult = this.addToFacts(incrementalIndexRowResult.getIncrementalIndexRow(), this.inputRowHolder);
        this.updateMaxIngestedTime(row.getTimestamp());
        ParseException parseException = IncrementalIndex.getCombinedParseException(row, incrementalIndexRowResult.getParseExceptionMessages(), addToFactsResult.getParseExceptionMessages());
        this.inputRowHolder.unset();
        return new IncrementalIndexAddResult(addToFactsResult.getRowCount(), addToFactsResult.getBytesInMemory(), parseException);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    IncrementalIndexRowResult toIncrementalIndexRow(InputRow row) {
        Object[] dims;
        if ((row = this.formatRow(row)).getTimestampFromEpoch() < this.minTimestamp) {
            throw DruidException.defensive("Cannot add row[%s] because it is below the minTimestamp[%s]", row, DateTimes.utc(this.minTimestamp));
        }
        List<String> rowDimensions = row.getDimensions();
        ArrayList overflow = null;
        long dimsKeySize = 0L;
        ArrayList<String> parseExceptionMessages = new ArrayList<String>();
        Map<String, DimensionDesc> map = this.dimensionDescs;
        synchronized (map) {
            HashSet absentDimensions = Sets.newHashSet(this.dimensionDescs.keySet());
            dims = new Object[this.dimensionDescs.size()];
            for (String dimension : rowDimensions) {
                if (Strings.isNullOrEmpty((String)dimension) || "__time".equals(dimension)) continue;
                boolean wasNewDim = false;
                DimensionDesc desc = this.dimensionDescs.get(dimension);
                if (desc != null) {
                    absentDimensions.remove(dimension);
                } else {
                    wasNewDim = true;
                    NestedCommonFormatColumnHandler handler = this.useSchemaDiscovery ? new NestedCommonFormatColumnHandler(dimension, null, IndexSpec.getDefault().getAutoColumnFormatSpec()) : DimensionHandlerUtils.getHandlerFromCapabilities(dimension, IncrementalIndex.makeDefaultCapabilitiesFromValueType(ColumnType.STRING), null);
                    desc = this.addNewDimension(dimension, handler);
                }
                DimensionIndexer<?, ?, ?> indexer = desc.getIndexer();
                Object dimsKey = null;
                try {
                    EncodedKeyComponent<?> encodedKeyComponent = indexer.processRowValsToUnsortedEncodedKeyComponent(row.getRaw(dimension), true);
                    dimsKey = encodedKeyComponent.getComponent();
                    dimsKeySize += encodedKeyComponent.getEffectiveSizeBytes();
                }
                catch (ParseException pe) {
                    parseExceptionMessages.add(pe.getMessage());
                }
                if (wasNewDim) {
                    if (this.maxIngestedEventTime != null) {
                        indexer.setSparseIndexed();
                    }
                    if (overflow == null) {
                        overflow = new ArrayList();
                    }
                    overflow.add(dimsKey);
                    continue;
                }
                if (desc.getIndex() > dims.length || dims[desc.getIndex()] != null) {
                    throw new ISE("Dimension[%s] occurred more than once in InputRow", dimension);
                }
                dims[desc.getIndex()] = dimsKey;
            }
            for (String missing : absentDimensions) {
                this.dimensionDescs.get(missing).getIndexer().setSparseIndexed();
            }
        }
        if (overflow != null) {
            Object[] newDims = new Object[dims.length + overflow.size()];
            System.arraycopy(dims, 0, newDims, 0, dims.length);
            for (int i = 0; i < overflow.size(); ++i) {
                newDims[dims.length + i] = overflow.get(i);
            }
            dims = newDims;
        }
        long truncated = 0L;
        if (row.getTimestamp() != null) {
            truncated = this.queryGranularity.bucketStart(row.getTimestampFromEpoch());
        }
        IncrementalIndexRow incrementalIndexRow = IncrementalIndexRow.createTimeAndDimswithDimsKeySize(Math.max(truncated, this.minTimestamp), dims, this.dimensionDescsList, dimsKeySize);
        return new IncrementalIndexRowResult(incrementalIndexRow, parseExceptionMessages);
    }

    @Nullable
    public static ParseException getCombinedParseException(InputRow row, @Nullable List<String> dimParseExceptionMessages, @Nullable List<String> aggParseExceptionMessages) {
        int numAdded = 0;
        StringBuilder stringBuilder = new StringBuilder();
        ArrayList<String> details = new ArrayList<String>();
        if (dimParseExceptionMessages != null) {
            details.addAll(dimParseExceptionMessages);
            for (String parseExceptionMessage : dimParseExceptionMessages) {
                stringBuilder.append(parseExceptionMessage);
                stringBuilder.append(",");
                ++numAdded;
            }
        }
        if (aggParseExceptionMessages != null) {
            details.addAll(aggParseExceptionMessages);
            for (String parseExceptionMessage : aggParseExceptionMessages) {
                stringBuilder.append(parseExceptionMessage);
                stringBuilder.append(",");
                ++numAdded;
            }
        }
        if (numAdded == 0) {
            return null;
        }
        int messageLen = stringBuilder.length();
        if (messageLen > 0) {
            stringBuilder.delete(messageLen - 1, messageLen);
        }
        String eventString = IncrementalIndex.getSimplifiedEventStringFromRow(row);
        return new UnparseableColumnsParseException(eventString, details, true, "Found unparseable columns in row: [%s], exceptions: [%s]", IncrementalIndex.getSimplifiedEventStringFromRow(row), stringBuilder.toString());
    }

    private synchronized void updateMaxIngestedTime(DateTime eventTime) {
        if (this.maxIngestedEventTime == null || this.maxIngestedEventTime.isBefore((ReadableInstant)eventTime)) {
            this.maxIngestedEventTime = eventTime;
        }
    }

    @Override
    public boolean isEmpty() {
        return this.numEntries.get() == 0;
    }

    @Override
    public int numRows() {
        return this.numEntries.get();
    }

    AtomicInteger getNumEntries() {
        return this.numEntries;
    }

    public AtomicLong getBytesInMemory() {
        return this.bytesInMemory;
    }

    private long getMinTimeMillis() {
        return this.getFacts().getMinTimeMillis();
    }

    private long getMaxTimeMillis() {
        return this.getFacts().getMaxTimeMillis();
    }

    public AggregatorFactory[] getMetricAggs() {
        return this.metrics;
    }

    public DimensionsSpec getDimensionsSpec() {
        return this.dimensionsSpec;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getDimensionNames(boolean includeTime) {
        Map<String, DimensionDesc> map = this.dimensionDescs;
        synchronized (map) {
            if (includeTime) {
                ImmutableList.Builder listBuilder = ImmutableList.builderWithExpectedSize((int)(this.dimensionDescs.size() + 1));
                int i = 0;
                if (i == this.timePosition) {
                    listBuilder.add((Object)"__time");
                }
                for (String dimName : this.dimensionDescs.keySet()) {
                    listBuilder.add((Object)dimName);
                    if (++i != this.timePosition) continue;
                    listBuilder.add((Object)"__time");
                }
                return listBuilder.build();
            }
            return ImmutableList.copyOf(this.dimensionDescs.keySet());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<DimensionDesc> getDimensions() {
        Map<String, DimensionDesc> map = this.dimensionDescs;
        synchronized (map) {
            return ImmutableList.copyOf(this.dimensionDescs.values());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public DimensionDesc getDimension(String dimension) {
        Map<String, DimensionDesc> map = this.dimensionDescs;
        synchronized (map) {
            return this.dimensionDescs.get(dimension);
        }
    }

    @Override
    @Nullable
    public MetricDesc getMetric(String metric) {
        return this.metricDescs.get(metric);
    }

    @Override
    public List<OrderBy> getOrdering() {
        return this.metadata.getOrdering();
    }

    @Override
    public int getTimePosition() {
        return this.timePosition;
    }

    public static ColumnValueSelector<?> makeMetricColumnValueSelector(IncrementalIndexRowSelector rowSelector, IncrementalIndexRowHolder currEntry, String metric) {
        MetricDesc metricDesc = rowSelector.getMetric(metric);
        if (metricDesc == null) {
            return NilColumnValueSelector.instance();
        }
        int metricIndex = metricDesc.getIndex();
        switch ((ValueType)metricDesc.getCapabilities().getType()) {
            case COMPLEX: {
                return new ObjectMetricColumnSelector(rowSelector, currEntry, metricDesc);
            }
            case LONG: {
                return new LongMetricColumnSelector(rowSelector, currEntry, metricIndex);
            }
            case FLOAT: {
                return new FloatMetricColumnSelector(rowSelector, currEntry, metricIndex);
            }
            case DOUBLE: {
                return new DoubleMetricColumnSelector(rowSelector, currEntry, metricIndex);
            }
            case STRING: {
                throw new IllegalStateException("String is not a metric column type");
            }
        }
        throw new ISE("Unknown metric value type: %s", metricDesc.getCapabilities().getType());
    }

    public Interval getInterval() {
        DateTime min = DateTimes.utc(this.minTimestamp);
        return new Interval((ReadableInstant)min, (ReadableInstant)(this.isEmpty() ? min : this.queryGranularity.increment(DateTimes.utc(this.getMaxTimeMillis()))));
    }

    @Nullable
    public DateTime getMinTime() {
        return this.isEmpty() ? null : DateTimes.utc(this.getMinTimeMillis());
    }

    @Nullable
    public DateTime getMaxTime() {
        return this.isEmpty() ? null : DateTimes.utc(this.getMaxTimeMillis());
    }

    public List<String> getDimensionOrder() {
        return this.getDimensionNames(true);
    }

    public static ColumnCapabilitiesImpl makeDefaultCapabilitiesFromValueType(ColumnType type) {
        switch ((ValueType)type.getType()) {
            case STRING: {
                return new ColumnCapabilitiesImpl().setType(type).setHasBitmapIndexes(true).setDictionaryEncoded(true).setDictionaryValuesUnique(true).setDictionaryValuesSorted(false);
            }
            case COMPLEX: {
                return ColumnCapabilitiesImpl.createDefault().setType(type).setHasNulls(true);
            }
        }
        return ColumnCapabilitiesImpl.createSimpleNumericColumnCapabilities(type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadDimensionIterable(Iterable<String> oldDimensionOrder, Map<String, ColumnFormat> oldColumnFormats) {
        Map<String, DimensionDesc> map = this.dimensionDescs;
        synchronized (map) {
            if (this.numRows() != 0) {
                throw new ISE("Cannot load dimension order[%s] when existing index is not empty.", this.dimensionDescs.keySet());
            }
            for (String dim : oldDimensionOrder) {
                if ("__time".equals(dim) || this.dimensionDescs.get(dim) != null) continue;
                ColumnFormat format = oldColumnFormats.get(dim);
                this.addNewDimension(dim, format.getColumnHandler(dim));
            }
        }
    }

    @GuardedBy(value="dimensionDescs")
    private DimensionDesc addNewDimension(String dim, DimensionHandler handler) {
        DimensionDesc desc = this.initDimension(this.dimensionDescs.size(), dim, handler);
        this.dimensionDescs.put(dim, desc);
        this.dimensionDescsList.add(desc);
        return desc;
    }

    private DimensionDesc initDimension(int dimensionIndex, String dimensionName, DimensionHandler dimensionHandler) {
        return new DimensionDesc(dimensionIndex, dimensionName, dimensionHandler);
    }

    @Override
    public List<String> getMetricNames() {
        return ImmutableList.copyOf(this.metricDescs.keySet());
    }

    public List<String> getColumnNames() {
        ArrayList<String> columnNames = new ArrayList<String>(this.getDimensionNames(true));
        columnNames.addAll(this.getMetricNames());
        return columnNames;
    }

    public Metadata getMetadata() {
        return this.metadata;
    }

    @Override
    public Iterator<Row> iterator() {
        return this.iterableWithPostAggregations(null, false).iterator();
    }

    public DateTime getMaxIngestedEventTime() {
        return this.maxIngestedEventTime;
    }

    protected ColumnSelectorFactory makeColumnSelectorFactory(@Nullable AggregatorFactory agg, InputRowHolder in) {
        return IncrementalIndex.makeColumnSelectorFactory(this.virtualColumns, in, agg);
    }

    protected final Comparator<IncrementalIndexRow> dimsComparator() {
        return new IncrementalIndexRowComparator(this.timePosition, this.dimensionDescsList);
    }

    private static String getSimplifiedEventStringFromRow(InputRow inputRow) {
        if (inputRow instanceof MapBasedInputRow) {
            return ((MapBasedInputRow)inputRow).getEvent().toString();
        }
        if (inputRow instanceof ListBasedInputRow) {
            return ((ListBasedInputRow)inputRow).asMap().toString();
        }
        if (inputRow instanceof TransformedInputRow) {
            InputRow innerRow = ((TransformedInputRow)inputRow).getBaseRow();
            return IncrementalIndex.getSimplifiedEventStringFromRow(innerRow);
        }
        return inputRow.toString();
    }

    private static AggregatorFactory[] getCombiningAggregators(AggregatorFactory[] aggregators) {
        AggregatorFactory[] combiningAggregators = new AggregatorFactory[aggregators.length];
        for (int i = 0; i < aggregators.length; ++i) {
            combiningAggregators[i] = aggregators[i].getCombiningFactory();
        }
        return combiningAggregators;
    }

    private static boolean allNull(Object[] dims, int startPosition) {
        for (int i = startPosition; i < dims.length; ++i) {
            if (dims[i] == null) continue;
            return false;
        }
        return true;
    }

    public static class InputRowHolder {
        @Nullable
        private InputRow row;
        private long rowId = -1L;

        public void set(InputRow row) {
            this.row = row;
            ++this.rowId;
        }

        public void unset() {
            this.row = null;
        }

        public InputRow getRow() {
            return (InputRow)Preconditions.checkNotNull((Object)this.row, (Object)"row");
        }

        public long getRowId() {
            return this.rowId;
        }
    }

    public static final class MetricDesc {
        private final int index;
        private final String name;
        private final String type;
        private final ColumnCapabilities capabilities;

        public MetricDesc(int index, AggregatorFactory factory) {
            this.index = index;
            this.name = factory.getName();
            ColumnType valueType = factory.getIntermediateType();
            if (valueType.isNumeric()) {
                this.capabilities = ColumnCapabilitiesImpl.createSimpleNumericColumnCapabilities(valueType);
                this.type = valueType.toString();
            } else if (valueType.is(ValueType.COMPLEX)) {
                ComplexMetricSerde serde = ComplexMetrics.getSerdeForType(valueType.getComplexTypeName());
                if (serde == null) {
                    throw new ISE("Unable to handle complex type[%s]", valueType);
                }
                this.type = serde.getTypeName();
                this.capabilities = ColumnCapabilitiesImpl.createDefault().setType(ColumnType.ofComplex(serde.getTypeName())).setHasNulls(ColumnCapabilities.Capable.TRUE);
            } else {
                throw new ISE("Unable to handle type[%s] for AggregatorFactory[%s]", valueType, factory.getClass());
            }
        }

        public int getIndex() {
            return this.index;
        }

        public String getName() {
            return this.name;
        }

        public String getType() {
            return this.type;
        }

        public ColumnCapabilities getCapabilities() {
            return this.capabilities;
        }
    }

    public static final class DimensionDesc {
        private final int index;
        private final String name;
        private final DimensionHandler<?, ?, ?> handler;
        private final DimensionIndexer<?, ?, ?> indexer;

        public DimensionDesc(int index, String name, DimensionHandler<?, ?, ?> handler) {
            this.index = index;
            this.name = name;
            this.handler = handler;
            this.indexer = handler.makeIndexer();
        }

        public DimensionDesc(int index, String name, DimensionHandler<?, ?, ?> handler, DimensionIndexer<?, ?, ?> indexer) {
            this.index = index;
            this.name = name;
            this.handler = handler;
            this.indexer = indexer;
        }

        public int getIndex() {
            return this.index;
        }

        public String getName() {
            return this.name;
        }

        public ColumnCapabilities getCapabilities() {
            return this.indexer.getColumnCapabilities();
        }

        public DimensionHandler<?, ?, ?> getHandler() {
            return this.handler;
        }

        public DimensionIndexer<?, ?, ?> getIndexer() {
            return this.indexer;
        }
    }

    static class IncrementalIndexRowResult {
        private final IncrementalIndexRow incrementalIndexRow;
        private final List<String> parseExceptionMessages;

        IncrementalIndexRowResult(IncrementalIndexRow incrementalIndexRow, List<String> parseExceptionMessages) {
            this.incrementalIndexRow = incrementalIndexRow;
            this.parseExceptionMessages = parseExceptionMessages;
        }

        IncrementalIndexRow getIncrementalIndexRow() {
            return this.incrementalIndexRow;
        }

        List<String> getParseExceptionMessages() {
            return this.parseExceptionMessages;
        }
    }

    public static class AddToFactsResult {
        private final int rowCount;
        private final long bytesInMemory;
        private final List<String> parseExceptionMessages;

        public AddToFactsResult(int rowCount, long bytesInMemory, List<String> parseExceptionMessages) {
            this.rowCount = rowCount;
            this.bytesInMemory = bytesInMemory;
            this.parseExceptionMessages = parseExceptionMessages;
        }

        int getRowCount() {
            return this.rowCount;
        }

        public long getBytesInMemory() {
            return this.bytesInMemory;
        }

        public List<String> getParseExceptionMessages() {
            return this.parseExceptionMessages;
        }
    }

    private static final class ObjectMetricColumnSelector
    extends ObjectColumnSelector {
        private final IncrementalIndexRowSelector rowSelector;
        private final IncrementalIndexRowHolder currEntry;
        private final int metricIndex;
        private final Class<?> classOfObject;

        public ObjectMetricColumnSelector(IncrementalIndexRowSelector rowSelector, IncrementalIndexRowHolder currEntry, MetricDesc metricDesc) {
            this.currEntry = currEntry;
            this.rowSelector = rowSelector;
            this.metricIndex = metricDesc.getIndex();
            this.classOfObject = ComplexMetrics.getSerdeForType(metricDesc.getType()).getObjectStrategy().getClazz();
        }

        @Override
        @Nullable
        public Object getObject() {
            return this.rowSelector.getMetricObjectValue(this.currEntry.get().getRowIndex(), this.metricIndex);
        }

        @Override
        public Class<?> classOfObject() {
            return this.classOfObject;
        }

        @Override
        public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
            inspector.visit("index", this.rowSelector);
        }
    }

    private static final class LongMetricColumnSelector
    implements LongColumnSelector {
        private final IncrementalIndexRowSelector rowSelector;
        private final IncrementalIndexRowHolder currEntry;
        private final int metricIndex;

        public LongMetricColumnSelector(IncrementalIndexRowSelector rowSelector, IncrementalIndexRowHolder currEntry, int metricIndex) {
            this.rowSelector = rowSelector;
            this.currEntry = currEntry;
            this.metricIndex = metricIndex;
        }

        @Override
        public long getLong() {
            return this.rowSelector.getMetricLongValue(this.currEntry.get().getRowIndex(), this.metricIndex);
        }

        @Override
        public boolean isNull() {
            return this.rowSelector.isNull(this.currEntry.get().getRowIndex(), this.metricIndex);
        }

        @Override
        public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
            inspector.visit("index", this.rowSelector);
        }
    }

    private static final class FloatMetricColumnSelector
    implements FloatColumnSelector {
        private final IncrementalIndexRowSelector rowSelector;
        private final IncrementalIndexRowHolder currEntry;
        private final int metricIndex;

        public FloatMetricColumnSelector(IncrementalIndexRowSelector rowSelector, IncrementalIndexRowHolder currEntry, int metricIndex) {
            this.currEntry = currEntry;
            this.rowSelector = rowSelector;
            this.metricIndex = metricIndex;
        }

        @Override
        public float getFloat() {
            return this.rowSelector.getMetricFloatValue(this.currEntry.get().getRowIndex(), this.metricIndex);
        }

        @Override
        public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
            inspector.visit("index", this.rowSelector);
        }

        @Override
        public boolean isNull() {
            return this.rowSelector.isNull(this.currEntry.get().getRowIndex(), this.metricIndex);
        }
    }

    private static final class DoubleMetricColumnSelector
    implements DoubleColumnSelector {
        private final IncrementalIndexRowSelector rowSelector;
        private final IncrementalIndexRowHolder currEntry;
        private final int metricIndex;

        public DoubleMetricColumnSelector(IncrementalIndexRowSelector rowSelector, IncrementalIndexRowHolder currEntry, int metricIndex) {
            this.currEntry = currEntry;
            this.rowSelector = rowSelector;
            this.metricIndex = metricIndex;
        }

        @Override
        public double getDouble() {
            assert (!this.isNull());
            return this.rowSelector.getMetricDoubleValue(this.currEntry.get().getRowIndex(), this.metricIndex);
        }

        @Override
        public boolean isNull() {
            return this.rowSelector.isNull(this.currEntry.get().getRowIndex(), this.metricIndex);
        }

        @Override
        public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
            inspector.visit("index", this.rowSelector);
        }
    }

    @VisibleForTesting
    static final class IncrementalIndexRowComparator
    implements Comparator<IncrementalIndexRow> {
        private final int timePosition;
        private final List<DimensionDesc> dimensionDescs;

        public IncrementalIndexRowComparator(int timePosition, List<DimensionDesc> dimDescs) {
            this.timePosition = timePosition;
            this.dimensionDescs = dimDescs;
        }

        @Override
        public int compare(IncrementalIndexRow lhs, IncrementalIndexRow rhs) {
            int retVal = 0;
            int numDimComparisons = Math.min(lhs.dims.length, rhs.dims.length);
            int dimIndex = 0;
            while (retVal == 0 && dimIndex < numDimComparisons && (dimIndex != this.timePosition || (retVal = Longs.compare((long)lhs.timestamp, (long)rhs.timestamp)) == 0)) {
                Object lhsIdxs = lhs.dims[dimIndex];
                Object rhsIdxs = rhs.dims[dimIndex];
                if (lhsIdxs == null) {
                    if (rhsIdxs == null) {
                        ++dimIndex;
                        continue;
                    }
                    return -1;
                }
                if (rhsIdxs == null) {
                    return 1;
                }
                DimensionIndexer<?, ?, ?> indexer = this.dimensionDescs.get(dimIndex).getIndexer();
                retVal = indexer.compareUnsortedEncodedKeyComponents(lhsIdxs, rhsIdxs);
                ++dimIndex;
            }
            if (retVal == 0 && dimIndex == numDimComparisons && this.timePosition >= numDimComparisons) {
                retVal = Longs.compare((long)lhs.timestamp, (long)rhs.timestamp);
            }
            if (retVal == 0) {
                int lengthDiff = Ints.compare((int)lhs.dims.length, (int)rhs.dims.length);
                if (lengthDiff == 0) {
                    return 0;
                }
                Object[] largerDims = lengthDiff > 0 ? lhs.dims : rhs.dims;
                return IncrementalIndex.allNull(largerDims, numDimComparisons) ? 0 : lengthDiff;
            }
            return retVal;
        }
    }
}

