/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.data;

import com.google.common.primitives.Ints;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.WritableByteChannel;
import java.util.Arrays;
import java.util.Comparator;
import javax.annotation.Nullable;
import org.apache.druid.error.DruidException;
import org.apache.druid.io.Channels;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.segment.data.DictionaryWriter;
import org.apache.druid.segment.data.VByte;
import org.apache.druid.segment.file.SegmentFileBuilder;
import org.apache.druid.segment.writeout.SegmentWriteOutMedium;
import org.apache.druid.segment.writeout.WriteOutBytes;

public class FrontCodedIntArrayIndexedWriter
implements DictionaryWriter<int[]> {
    private static final int MAX_LOG_BUFFER_SIZE = 26;
    public static final Comparator<int[]> ARRAY_COMPARATOR = (o1, o2) -> {
        if (o1 == o2) {
            return 0;
        }
        if (o1 == null) {
            return -1;
        }
        if (o2 == null) {
            return 1;
        }
        int iter = Math.min(((int[])o1).length, ((int[])o2).length);
        for (int i = 0; i < iter; ++i) {
            int cmp = Integer.compare(o1[i], o2[i]);
            if (cmp == 0) continue;
            return cmp;
        }
        return Integer.compare(((int[])o1).length, ((int[])o2).length);
    };
    private final SegmentWriteOutMedium segmentWriteOutMedium;
    private final int bucketSize;
    private final ByteOrder byteOrder;
    private final int[][] bucketBuffer;
    private final ByteBuffer getOffsetBuffer;
    private final int div;
    @Nullable
    private int[] prevObject = null;
    @Nullable
    private WriteOutBytes headerOut = null;
    @Nullable
    private WriteOutBytes valuesOut = null;
    private int numWritten = 0;
    private ByteBuffer scratch;
    private int logScratchSize = 10;
    private boolean isClosed = false;
    private boolean hasNulls = false;
    private int readCachedBucket = -1;
    @Nullable
    private ByteBuffer readBufferCache = null;

    public FrontCodedIntArrayIndexedWriter(SegmentWriteOutMedium segmentWriteOutMedium, ByteOrder byteOrder, int bucketSize) {
        if (Integer.bitCount(bucketSize) != 1 || bucketSize < 1 || bucketSize > 128) {
            throw new IAE("bucketSize must be a power of two (from 1 up to 128) but was[%,d]", bucketSize);
        }
        this.segmentWriteOutMedium = segmentWriteOutMedium;
        this.scratch = ByteBuffer.allocate(1 << this.logScratchSize).order(byteOrder);
        this.bucketSize = bucketSize;
        this.byteOrder = byteOrder;
        this.bucketBuffer = new int[bucketSize][];
        this.getOffsetBuffer = ByteBuffer.allocate(4).order(byteOrder);
        this.div = Integer.numberOfTrailingZeros(bucketSize);
    }

    @Override
    public void open() throws IOException {
        this.headerOut = this.segmentWriteOutMedium.makeWriteOutBytes();
        this.valuesOut = this.segmentWriteOutMedium.makeWriteOutBytes();
    }

    @Override
    public int write(@Nullable int[] value) throws IOException {
        if (this.prevObject != null && ARRAY_COMPARATOR.compare(this.prevObject, value) >= 0) {
            throw new ISE("Values must be sorted and unique. Element [%s] with value [%s] is before or equivalent to [%s]", this.numWritten, value == null ? null : Arrays.toString(value), Arrays.toString(this.prevObject));
        }
        if (value == null) {
            if (this.numWritten != 0) {
                throw DruidException.defensive("Null must come first, got it at numWritten[%,d]!=0", this.numWritten);
            }
            this.hasNulls = true;
            return 0;
        }
        if (this.numWritten > 0 && this.numWritten % this.bucketSize == 0) {
            int written;
            this.resetScratch();
            do {
                if ((written = FrontCodedIntArrayIndexedWriter.writeBucket(this.scratch, this.bucketBuffer, this.bucketSize)) >= 0) continue;
                this.growScratch();
            } while (written < 0);
            this.scratch.flip();
            Channels.writeFully(this.valuesOut, this.scratch);
            this.resetScratch();
            this.scratch.putInt((int)this.valuesOut.size());
            this.scratch.flip();
            Channels.writeFully(this.headerOut, this.scratch);
        }
        this.bucketBuffer[this.numWritten % this.bucketSize] = value;
        int retVal = this.numWritten++;
        this.prevObject = value;
        return retVal + (this.hasNulls ? 1 : 0);
    }

    @Override
    public long getSerializedSize() throws IOException {
        if (!this.isClosed) {
            this.flush();
        }
        int headerAndValues = Ints.checkedCast((long)(this.headerOut.size() + this.valuesOut.size()));
        return 3 + VByte.computeIntSize(this.numWritten) + VByte.computeIntSize(headerAndValues) + headerAndValues;
    }

    @Override
    public void writeTo(WritableByteChannel channel, SegmentFileBuilder fileBuilder) throws IOException {
        if (!this.isClosed) {
            this.flush();
        }
        this.resetScratch();
        this.scratch.put((byte)0);
        this.scratch.put((byte)this.bucketSize);
        this.scratch.put(this.hasNulls ? (byte)1 : 0);
        VByte.writeInt(this.scratch, this.numWritten);
        VByte.writeInt(this.scratch, Ints.checkedCast((long)(this.headerOut.size() + this.valuesOut.size())));
        this.scratch.flip();
        Channels.writeFully(channel, this.scratch);
        this.headerOut.writeTo(channel);
        this.valuesOut.writeTo(channel);
    }

    @Override
    public boolean isSorted() {
        return true;
    }

    @Override
    @Nullable
    public int[] get(int index) throws IOException {
        if (index == 0 && this.hasNulls) {
            return null;
        }
        int adjustedIndex = this.hasNulls ? index - 1 : index;
        int relativeIndex = adjustedIndex % this.bucketSize;
        if (adjustedIndex >= this.numWritten - this.bucketSize) {
            return this.bucketBuffer[relativeIndex];
        }
        int bucket = adjustedIndex >> this.div;
        if (this.readCachedBucket == bucket) {
            this.readBufferCache.position(0);
            return this.getFromBucket(this.readBufferCache, relativeIndex);
        }
        long startOffset = bucket == 0 ? 0L : this.getBucketOffset(bucket - 1);
        long endOffset = this.getBucketOffset(bucket);
        int currentBucketSize = Ints.checkedCast((long)(endOffset - startOffset));
        if (currentBucketSize == 0) {
            return null;
        }
        if (this.readBufferCache == null || this.readBufferCache.capacity() < currentBucketSize) {
            this.readBufferCache = ByteBuffer.allocate(currentBucketSize).order(this.byteOrder);
        }
        this.readBufferCache.clear();
        this.readBufferCache.limit(currentBucketSize);
        this.valuesOut.readFully(startOffset, this.readBufferCache);
        this.readCachedBucket = bucket;
        this.readBufferCache.position(0);
        return this.getFromBucket(this.readBufferCache, relativeIndex);
    }

    @Override
    public int getCardinality() {
        return this.numWritten + (this.hasNulls ? 1 : 0);
    }

    private long getBucketOffset(int index) throws IOException {
        this.getOffsetBuffer.clear();
        this.headerOut.readFully((long)index * 4L, this.getOffsetBuffer);
        return this.getOffsetBuffer.getInt(0);
    }

    private void flush() throws IOException {
        int written;
        if (this.numWritten == 0) {
            return;
        }
        int remainder = this.numWritten % this.bucketSize;
        this.resetScratch();
        do {
            if ((written = FrontCodedIntArrayIndexedWriter.writeBucket(this.scratch, this.bucketBuffer, remainder == 0 ? this.bucketSize : remainder)) >= 0) continue;
            this.growScratch();
        } while (written < 0);
        this.scratch.flip();
        Channels.writeFully(this.valuesOut, this.scratch);
        this.resetScratch();
        this.isClosed = true;
    }

    private void resetScratch() {
        this.scratch.position(0);
        this.scratch.limit(this.scratch.capacity());
    }

    private void growScratch() {
        if (this.logScratchSize >= 26) {
            throw new IllegalStateException("scratch buffer to big to write buckets");
        }
        this.scratch = ByteBuffer.allocate(1 << ++this.logScratchSize).order(this.byteOrder);
    }

    public static int writeBucket(ByteBuffer buffer, int[][] values, int numValues) {
        int written;
        int[] prev = null;
        for (written = 0; written < numValues; ++written) {
            int cmp;
            int prefixLength;
            int[] next = values[written];
            if (written == 0) {
                prev = next;
                int rem = FrontCodedIntArrayIndexedWriter.writeValue(buffer, prev);
                if (rem >= 0) continue;
                return rem;
            }
            for (prefixLength = 0; prefixLength < prev.length && (cmp = Integer.compare(prev[prefixLength], next[prefixLength])) == 0; ++prefixLength) {
            }
            int[] suffix = new int[next.length - prefixLength];
            System.arraycopy(next, prefixLength, suffix, 0, suffix.length);
            int rem = buffer.remaining() - VByte.computeIntSize(prefixLength);
            if (rem < 0) {
                return rem;
            }
            VByte.writeInt(buffer, prefixLength);
            rem = FrontCodedIntArrayIndexedWriter.writeValue(buffer, suffix);
            prev = next;
            if (rem >= 0) continue;
            return rem;
        }
        return written;
    }

    public static int writeValue(ByteBuffer buffer, int[] ints) {
        int remaining = buffer.remaining() - VByte.computeIntSize(ints.length) - ints.length;
        if (remaining < 0) {
            return remaining;
        }
        int pos = buffer.position();
        VByte.writeInt(buffer, ints.length);
        for (int anInt : ints) {
            remaining = buffer.remaining() - 4;
            if (remaining < 0) {
                return remaining;
            }
            buffer.putInt(anInt);
        }
        return buffer.position() - pos;
    }

    int[] getFromBucket(ByteBuffer buffer, int offset) {
        int i;
        int prefixLength;
        int[] unwindPrefixLength = new int[this.bucketSize];
        int[] unwindBufferPosition = new int[this.bucketSize];
        int length = VByte.readInt(buffer);
        if (offset == 0) {
            int[] firstValue = new int[length];
            for (int i2 = 0; i2 < length; ++i2) {
                firstValue[i2] = buffer.getInt();
            }
            return firstValue;
        }
        int pos = 0;
        unwindPrefixLength[pos] = 0;
        unwindBufferPosition[pos] = buffer.position();
        buffer.position(buffer.position() + length * 4);
        while (true) {
            prefixLength = VByte.readInt(buffer);
            if (++pos >= offset) break;
            int skipLength = VByte.readInt(buffer);
            unwindPrefixLength[pos] = prefixLength;
            unwindBufferPosition[pos] = buffer.position();
            buffer.position(buffer.position() + skipLength * 4);
        }
        int fragmentLength = VByte.readInt(buffer);
        if (prefixLength == 0) {
            int[] value = new int[fragmentLength];
            for (int i3 = 0; i3 < fragmentLength; ++i3) {
                value[i3] = buffer.getInt();
            }
            return value;
        }
        int valueLength = prefixLength + fragmentLength;
        int[] value = new int[valueLength];
        for (i = prefixLength; i < valueLength; ++i) {
            value[i] = buffer.getInt();
        }
        i = prefixLength;
        while (i > 0) {
            if (unwindPrefixLength[--pos] >= i) continue;
            buffer.position(unwindBufferPosition[pos]);
            int prevLength = unwindPrefixLength[pos];
            for (int fragmentOffset = 0; fragmentOffset < i - prevLength; ++fragmentOffset) {
                value[prevLength + fragmentOffset] = buffer.getInt();
            }
            i = unwindPrefixLength[pos];
        }
        return value;
    }
}

