/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.data;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.WritableByteChannel;
import org.apache.druid.segment.data.ColumnCapacityExceededException;
import org.apache.druid.segment.data.ColumnarDoublesSerializer;
import org.apache.druid.segment.data.CompressionStrategy;
import org.apache.druid.segment.file.SegmentFileBuilder;
import org.apache.druid.segment.serde.MetaSerdeHelper;
import org.apache.druid.segment.writeout.SegmentWriteOutMedium;
import org.apache.druid.segment.writeout.WriteOutBytes;

public class EntireLayoutColumnarDoublesSerializer
implements ColumnarDoublesSerializer {
    private static final MetaSerdeHelper<EntireLayoutColumnarDoublesSerializer> META_SERDE_HELPER = MetaSerdeHelper.firstWriteByte(x -> 2).writeInt(x -> x.numInserted).writeInt(x -> 0).writeByte(x -> CompressionStrategy.NONE.getId());
    private final String columnName;
    private final SegmentWriteOutMedium segmentWriteOutMedium;
    private final ByteBuffer orderBuffer;
    private WriteOutBytes valuesOut;
    private int numInserted = 0;

    public EntireLayoutColumnarDoublesSerializer(String columnName, SegmentWriteOutMedium segmentWriteOutMedium, ByteOrder order) {
        this.columnName = columnName;
        this.segmentWriteOutMedium = segmentWriteOutMedium;
        this.orderBuffer = ByteBuffer.allocate(8);
        this.orderBuffer.order(order);
    }

    @Override
    public void open() throws IOException {
        this.valuesOut = this.segmentWriteOutMedium.makeWriteOutBytes();
    }

    @Override
    public int size() {
        return this.numInserted;
    }

    @Override
    public void add(double value) throws IOException {
        this.orderBuffer.rewind();
        this.orderBuffer.putDouble(value);
        this.valuesOut.write(this.orderBuffer.array());
        ++this.numInserted;
        if (this.numInserted < 0) {
            throw new ColumnCapacityExceededException(this.columnName);
        }
    }

    @Override
    public long getSerializedSize() {
        return (long)META_SERDE_HELPER.size(this) + this.valuesOut.size();
    }

    @Override
    public void writeTo(WritableByteChannel channel, SegmentFileBuilder fileBuilder) throws IOException {
        META_SERDE_HELPER.writeTo(channel, this);
        this.valuesOut.writeTo(channel);
    }
}

