/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment;

import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.Nullable;
import org.apache.druid.segment.ComparatorSortedDimensionDictionary;

public class ComparatorDimensionDictionary<T> {
    public static final int ABSENT_VALUE_ID = -1;
    @Nullable
    private T minValue = null;
    @Nullable
    private T maxValue = null;
    private volatile int idForNull = -1;
    private final AtomicLong sizeInBytes = new AtomicLong(0L);
    private final Object2IntMap<T> valueToId = new Object2IntOpenHashMap();
    private final List<T> idToValue = new ArrayList<T>();
    private final Comparator<T> comparator;

    public ComparatorDimensionDictionary(Comparator<T> comparator) {
        this.comparator = comparator;
        this.valueToId.defaultReturnValue(-1);
    }

    public int getId(@Nullable T value) {
        if (value == null) {
            return this.idForNull;
        }
        return this.valueToId.getInt(value);
    }

    @Nullable
    public T getValue(int id) {
        if (id == this.idForNull) {
            return null;
        }
        return this.idToValue.get(id);
    }

    public int size() {
        return this.idToValue.size();
    }

    public long sizeInBytes() {
        return this.sizeInBytes.get();
    }

    public int add(@Nullable T originalValue) {
        if (originalValue == null) {
            if (this.idForNull == -1) {
                this.idForNull = this.idToValue.size();
                this.idToValue.add(null);
            }
            return this.idForNull;
        }
        int prev = this.valueToId.getInt(originalValue);
        if (prev >= 0) {
            return prev;
        }
        int index = this.idToValue.size();
        this.valueToId.put(originalValue, index);
        this.idToValue.add(originalValue);
        this.sizeInBytes.addAndGet(this.estimateSizeOfValue(originalValue) + 16L);
        this.minValue = this.minValue == null || this.comparator.compare(this.minValue, originalValue) > 0 ? originalValue : this.minValue;
        this.maxValue = this.maxValue == null || this.comparator.compare(this.maxValue, originalValue) < 0 ? originalValue : this.maxValue;
        return index;
    }

    public T getMinValue() {
        return this.minValue;
    }

    public T getMaxValue() {
        return this.maxValue;
    }

    public int getIdForNull() {
        return this.idForNull;
    }

    public ComparatorSortedDimensionDictionary<T> sort() {
        return new ComparatorSortedDimensionDictionary<T>(this.idToValue, this.comparator, this.idToValue.size());
    }

    public long estimateSizeOfValue(T value) {
        throw new UnsupportedOperationException();
    }
}

