/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.rowsandcols.semantic;

import java.util.List;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.query.rowsandcols.RowsAndColumns;
import org.apache.druid.query.rowsandcols.column.Column;
import org.apache.druid.query.rowsandcols.column.ColumnAccessor;
import org.apache.druid.query.rowsandcols.semantic.GroupPartitioner;

public class DefaultGroupPartitioner
implements GroupPartitioner {
    private final RowsAndColumns rac;

    public DefaultGroupPartitioner(RowsAndColumns rac) {
        this.rac = rac;
    }

    @Override
    public int[] computeGroupings(List<String> columns) {
        int[] retVal = new int[this.rac.numRows()];
        for (String column : columns) {
            Column theCol = this.rac.findColumn(column);
            if (theCol == null) continue;
            ColumnAccessor accessor = theCol.toAccessor();
            int currGroup = 0;
            int prevGroupVal = 0;
            for (int i = 1; i < retVal.length; ++i) {
                if (retVal[i] == prevGroupVal) {
                    int comparison = accessor.compareRows(i - 1, i);
                    if (comparison == 0) {
                        retVal[i] = currGroup;
                        continue;
                    }
                    if (comparison > 0) {
                        throw new ISE("Pre-sorted data required, rows[%s] and [%s] were not in order", i - 1, i);
                    }
                }
                prevGroupVal = retVal[i];
                retVal[i] = ++currGroup;
            }
        }
        return retVal;
    }
}

