/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.groupby.epinephelinae.vector;

import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import org.apache.druid.query.groupby.epinephelinae.DictionaryBuildingUtils;
import org.apache.druid.query.groupby.epinephelinae.column.DimensionIdCodec;
import org.apache.druid.query.groupby.epinephelinae.column.MemoryFootprint;
import org.apache.druid.query.groupby.epinephelinae.vector.DictionaryBuildingGroupByVectorColumnSelector;
import org.apache.druid.segment.DimensionHandlerUtils;
import org.apache.druid.segment.vector.VectorObjectSelector;

public class DictionaryBuildingSingleValueStringGroupByVectorColumnSelector
extends DictionaryBuildingGroupByVectorColumnSelector<String> {
    public DictionaryBuildingSingleValueStringGroupByVectorColumnSelector(VectorObjectSelector selector) {
        super(selector, new StringDimensionIdCodec());
    }

    @Override
    protected String convertValue(Object rawValue) {
        return DimensionHandlerUtils.convertObjectToString(rawValue);
    }

    private static class StringDimensionIdCodec
    implements DimensionIdCodec<String> {
        private final List<String> dictionary = new ArrayList<String>();
        private final Object2IntMap<String> reverseDictionary = new Object2IntOpenHashMap();

        StringDimensionIdCodec() {
            this.reverseDictionary.defaultReturnValue(-1);
        }

        @Override
        public MemoryFootprint<Integer> lookupId(String value) {
            int dictId = this.reverseDictionary.getInt((Object)value);
            int footprintIncrease = 0;
            if (dictId < 0) {
                dictId = this.dictionary.size();
                this.dictionary.add(value);
                this.reverseDictionary.put((Object)value, dictId);
                footprintIncrease = DictionaryBuildingUtils.estimateEntryFootprint(value == null ? 0 : value.length() * 2);
            }
            return new MemoryFootprint<Integer>(dictId, footprintIncrease);
        }

        @Override
        public String idToKey(int id) {
            return this.dictionary.get(id);
        }

        @Override
        public boolean canCompareIds() {
            return false;
        }

        @Override
        public void reset() {
            this.dictionary.clear();
            this.reverseDictionary.clear();
        }
    }
}

