/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.groupby.epinephelinae.vector;

import org.apache.datasketches.memory.WritableMemory;
import org.apache.druid.query.groupby.ResultRow;
import org.apache.druid.query.groupby.epinephelinae.collection.MemoryPointer;
import org.apache.druid.query.groupby.epinephelinae.column.DimensionIdCodec;
import org.apache.druid.query.groupby.epinephelinae.column.MemoryFootprint;
import org.apache.druid.query.groupby.epinephelinae.vector.GroupByVectorColumnSelector;
import org.apache.druid.segment.vector.VectorObjectSelector;

public abstract class DictionaryBuildingGroupByVectorColumnSelector<T>
implements GroupByVectorColumnSelector {
    protected final VectorObjectSelector selector;
    protected final DimensionIdCodec<T> dimensionIdCodec;

    protected DictionaryBuildingGroupByVectorColumnSelector(VectorObjectSelector selector, DimensionIdCodec<T> dimensionIdCodec) {
        this.selector = selector;
        this.dimensionIdCodec = dimensionIdCodec;
    }

    @Override
    public final int getGroupingKeySize() {
        return 4;
    }

    @Override
    public final int writeKeys(WritableMemory keySpace, int keySize, int keyOffset, int startRow, int endRow) {
        Object[] vector = this.selector.getObjectVector();
        int stateFootprintIncrease = 0;
        int i = startRow;
        int j = keyOffset;
        while (i < endRow) {
            T value = this.convertValue(vector[i]);
            MemoryFootprint<Integer> idAndMemoryIncrease = this.dimensionIdCodec.lookupId(value);
            keySpace.putInt((long)j, idAndMemoryIncrease.value().intValue());
            stateFootprintIncrease += idAndMemoryIncrease.memoryIncrease();
            ++i;
            j += keySize;
        }
        return stateFootprintIncrease;
    }

    @Override
    public final void writeKeyToResultRow(MemoryPointer keyMemory, int keyOffset, ResultRow resultRow, int resultRowPosition) {
        int id = keyMemory.memory().getInt(keyMemory.position() + (long)keyOffset);
        T value = this.dimensionIdCodec.idToKey(id);
        resultRow.set(resultRowPosition, value);
    }

    @Override
    public final void reset() {
        this.dimensionIdCodec.reset();
    }

    protected abstract T convertValue(Object var1);
}

