/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.expression;

import inet.ipaddr.IPAddressString;
import inet.ipaddr.IPAddressStringParameters;
import inet.ipaddr.ipv6.IPv6Address;
import javax.annotation.Nullable;

public class IPv6AddressExprUtils {
    private static final IPAddressStringParameters IPV6_ADDRESS_PARAMS = new IPAddressStringParameters.Builder().allowSingleSegment(false).allow_inet_aton(false).allowIPv4(false).allowPrefix(false).allowEmpty(false).toParams();
    private static final IPAddressStringParameters IPV6_SUBNET_PARAMS = new IPAddressStringParameters.Builder().allowSingleSegment(false).allow_inet_aton(false).allowEmpty(false).allowIPv4(false).toParams();

    static boolean isValidIPv6Address(@Nullable String addressString) {
        return addressString != null && new IPAddressString(addressString, IPV6_ADDRESS_PARAMS).isIPv6();
    }

    static boolean isValidIPv6Subnet(@Nullable String subnetString) {
        return subnetString != null && new IPAddressString(subnetString, IPV6_SUBNET_PARAMS).isPrefixed();
    }

    @Nullable
    public static IPv6Address parse(@Nullable String string) {
        IPAddressString ipAddressString = new IPAddressString(string, IPV6_ADDRESS_PARAMS);
        if (ipAddressString.isIPv6()) {
            return ipAddressString.getAddress().toIPv6();
        }
        return null;
    }

    @Nullable
    public static IPAddressString parseString(@Nullable String string) {
        IPAddressString ipAddressString = new IPAddressString(string, IPV6_ADDRESS_PARAMS);
        if (ipAddressString.isIPv6()) {
            return ipAddressString;
        }
        return null;
    }

    @Nullable
    public static IPv6Address parse(@Nullable byte[] bytes) {
        return bytes == null ? null : new IPv6Address(bytes);
    }
}

