/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query;

import java.util.ArrayList;
import org.apache.druid.java.util.common.io.Closer;
import org.apache.druid.query.DataSegmentAndDescriptor;
import org.apache.druid.query.SegmentDescriptor;
import org.apache.druid.segment.SegmentReference;
import org.apache.druid.utils.CloseableUtils;

public class LeafSegmentsBundle {
    private final ArrayList<SegmentReference> cachedSegments;
    private final ArrayList<DataSegmentAndDescriptor> loadableSegments;
    private final ArrayList<SegmentDescriptor> missingSegments;

    public LeafSegmentsBundle(ArrayList<SegmentReference> cachedSegments, ArrayList<DataSegmentAndDescriptor> loadableSegments, ArrayList<SegmentDescriptor> missingSegments) {
        this.cachedSegments = cachedSegments;
        this.missingSegments = missingSegments;
        this.loadableSegments = loadableSegments;
    }

    public ArrayList<SegmentReference> getCachedSegments() {
        return this.cachedSegments;
    }

    public ArrayList<DataSegmentAndDescriptor> getLoadableSegments() {
        return this.loadableSegments;
    }

    public ArrayList<SegmentDescriptor> getMissingSegments() {
        return this.missingSegments;
    }

    public void closeCachedReferences() {
        Closer closer = CloseableUtils.forIterable(this.cachedSegments);
        CloseableUtils.closeAndWrapExceptions(closer);
    }
}

