/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.math.expr.vector;

import java.util.List;
import javax.annotation.Nullable;
import org.apache.druid.math.expr.Evals;
import org.apache.druid.math.expr.Expr;
import org.apache.druid.math.expr.ExpressionType;
import org.apache.druid.math.expr.vector.CastToTypeVectorProcessor;
import org.apache.druid.math.expr.vector.ExprVectorProcessor;
import org.apache.druid.math.expr.vector.ObjectBivariateObjectsFunctionVectorProcessor;
import org.apache.druid.math.expr.vector.ObjectMultivariateObjectsFunctionVectorProcessor;

public class VectorStringProcessors {
    public static <T> ExprVectorProcessor<T> concat(Expr.VectorInputBindingInspector inspector, Expr left, Expr right) {
        ObjectBivariateObjectsFunctionVectorProcessor processor = new ObjectBivariateObjectsFunctionVectorProcessor(left.asVectorProcessor(inspector), right.asVectorProcessor(inspector), ExpressionType.STRING){

            @Override
            @Nullable
            protected Object processValue(@Nullable Object leftVal, @Nullable Object rightVal) {
                return String.valueOf(leftVal) + (String)rightVal;
            }
        };
        return processor;
    }

    public static <T> ExprVectorProcessor<T> concat(Expr.VectorInputBindingInspector inspector, List<Expr> inputs) {
        ExprVectorProcessor[] inputProcessors = new ExprVectorProcessor[inputs.size()];
        for (int i = 0; i < inputs.size(); ++i) {
            inputProcessors[i] = CastToTypeVectorProcessor.cast(inputs.get(i).asVectorProcessor(inspector), ExpressionType.STRING);
        }
        ObjectMultivariateObjectsFunctionVectorProcessor processor = new ObjectMultivariateObjectsFunctionVectorProcessor(inputProcessors, ExpressionType.STRING){

            @Override
            void processIndex(Object[][] in, int i) {
                String first = Evals.asString(in[0][i]);
                if (first == null) {
                    this.outValues[i] = null;
                    return;
                }
                StringBuilder builder = new StringBuilder(first);
                for (int inputNumber = 1; inputNumber < in.length; ++inputNumber) {
                    String s = Evals.asString(in[inputNumber][i]);
                    if (s == null) {
                        this.outValues[i] = null;
                        return;
                    }
                    builder.append(s);
                }
                this.outValues[i] = builder.toString();
            }
        };
        return processor;
    }
}

