/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.math.expr.vector;

import java.util.List;
import org.apache.druid.annotations.SuppressFBWarnings;
import org.apache.druid.math.expr.Expr;
import org.apache.druid.math.expr.ExprType;
import org.apache.druid.math.expr.ExpressionType;
import org.apache.druid.math.expr.ExpressionTypeConversion;
import org.apache.druid.math.expr.vector.CaseSearchedDoubleVectorProcessor;
import org.apache.druid.math.expr.vector.CaseSearchedFunctionVectorProcessor;
import org.apache.druid.math.expr.vector.CaseSearchedLongVectorProcessor;
import org.apache.druid.math.expr.vector.CaseSearchedObjectVectorProcessor;
import org.apache.druid.math.expr.vector.CastToTypeVectorProcessor;
import org.apache.druid.math.expr.vector.CoalesceDoubleVectorProcessor;
import org.apache.druid.math.expr.vector.CoalesceFunctionVectorProcessor;
import org.apache.druid.math.expr.vector.CoalesceLongVectorProcessor;
import org.apache.druid.math.expr.vector.CoalesceVectorObjectProcessor;
import org.apache.druid.math.expr.vector.ExprVectorProcessor;
import org.apache.druid.math.expr.vector.IfDoubleVectorProcessor;
import org.apache.druid.math.expr.vector.IfFunctionVectorProcessor;
import org.apache.druid.math.expr.vector.IfLongVectorProcessor;
import org.apache.druid.math.expr.vector.IfObjectVectorProcessor;
import org.apache.druid.math.expr.vector.VectorComparisonProcessors;
import org.apache.druid.math.expr.vector.VectorProcessors;

public class VectorConditionalProcessors {
    public static <T> ExprVectorProcessor<T> coalesce(Expr.VectorInputBindingInspector inspector, List<Expr> args) {
        ExpressionType outputType = null;
        for (Expr arg : args) {
            outputType = ExpressionTypeConversion.leastRestrictiveType(outputType, arg.getOutputType(inspector));
        }
        if (outputType == null) {
            return VectorProcessors.constant((Long)null, inspector.getMaxVectorSize());
        }
        ExprVectorProcessor[] processors = new ExprVectorProcessor[args.size()];
        for (int i = 0; i < args.size(); ++i) {
            processors[i] = CastToTypeVectorProcessor.cast(args.get(i).asVectorProcessor(inspector), outputType);
        }
        CoalesceFunctionVectorProcessor processor = outputType.is(ExprType.LONG) ? new CoalesceLongVectorProcessor(processors) : (outputType.is(ExprType.DOUBLE) ? new CoalesceDoubleVectorProcessor(processors) : new CoalesceVectorObjectProcessor(outputType, processors));
        return processor;
    }

    public static <T> ExprVectorProcessor<T> ifFunction(Expr.VectorInputBindingInspector inspector, Expr conditionExpr, Expr thenExpr, Expr elseExpr) {
        ExpressionType outputType = ExpressionTypeConversion.leastRestrictiveType(thenExpr.getOutputType(inspector), elseExpr.getOutputType(inspector));
        if (outputType == null) {
            return VectorProcessors.constant((Long)null, inspector.getMaxVectorSize());
        }
        IfFunctionVectorProcessor processor = outputType.is(ExprType.LONG) ? new IfLongVectorProcessor(conditionExpr.asVectorProcessor(inspector), thenExpr.asVectorProcessor(inspector), elseExpr.asVectorProcessor(inspector)) : (outputType.is(ExprType.DOUBLE) ? new IfDoubleVectorProcessor(conditionExpr.asVectorProcessor(inspector), thenExpr.asVectorProcessor(inspector), elseExpr.asVectorProcessor(inspector)) : new IfObjectVectorProcessor(outputType, (ExprVectorProcessor<?>)conditionExpr.asVectorProcessor(inspector), thenExpr.asVectorProcessor(inspector), elseExpr.asVectorProcessor(inspector)));
        return processor;
    }

    public static <T> ExprVectorProcessor<T> caseSearchedFunction(Expr.VectorInputBindingInspector inspector, List<Expr> args) {
        int conditionProcessorsCount = (int)((double)(args.size() / 2));
        int thenProcessorsCount = args.size() - conditionProcessorsCount;
        ExprVectorProcessor[] conditionProcessors = new ExprVectorProcessor[conditionProcessorsCount];
        ExprVectorProcessor[] thenProcessors = new ExprVectorProcessor[thenProcessorsCount];
        ExpressionType outputType = null;
        int j = 0;
        int k = 0;
        for (int i = 0; i < args.size(); ++i) {
            if (i % 2 == 0 && j < conditionProcessorsCount) {
                conditionProcessors[j++] = args.get(i).asVectorProcessor(inspector);
                continue;
            }
            outputType = ExpressionTypeConversion.leastRestrictiveType(outputType, args.get(i).getOutputType(inspector));
            thenProcessors[k++] = args.get(i).asVectorProcessor(inspector);
        }
        return VectorConditionalProcessors.caseSearchedFunction(inspector, outputType, conditionProcessors, thenProcessors);
    }

    @SuppressFBWarnings(value={"IM_BAD_CHECK_FOR_ODD"})
    public static <T> ExprVectorProcessor<T> caseSimpleFunction(Expr.VectorInputBindingInspector inspector, List<Expr> args) {
        int conditionProcessorsCount = (int)((double)((args.size() - 1) / 2));
        int thenProcessorsCount = args.size() - 1 - conditionProcessorsCount;
        ExprVectorProcessor[] conditionProcessors = new ExprVectorProcessor[conditionProcessorsCount];
        ExprVectorProcessor[] thenProcessors = new ExprVectorProcessor[thenProcessorsCount];
        ExpressionType outputType = null;
        int j = 0;
        int k = 0;
        for (int i = 1; i < args.size(); ++i) {
            if (i % 2 == 1 && j < conditionProcessorsCount) {
                conditionProcessors[j++] = VectorComparisonProcessors.equals().asProcessor(inspector, args.get(0), args.get(i));
                continue;
            }
            outputType = ExpressionTypeConversion.leastRestrictiveType(outputType, args.get(i).getOutputType(inspector));
            thenProcessors[k++] = args.get(i).asVectorProcessor(inspector);
        }
        return VectorConditionalProcessors.caseSearchedFunction(inspector, outputType, conditionProcessors, thenProcessors);
    }

    private static <T> ExprVectorProcessor<T> caseSearchedFunction(Expr.VectorInputBindingInspector inspector, ExpressionType outputType, ExprVectorProcessor<?>[] conditionProcessors, ExprVectorProcessor[] thenProcessors) {
        if (outputType == null) {
            return VectorProcessors.constant((Long)null, inspector.getMaxVectorSize());
        }
        CaseSearchedFunctionVectorProcessor processor = outputType.is(ExprType.LONG) ? new CaseSearchedLongVectorProcessor(conditionProcessors, thenProcessors) : (outputType.is(ExprType.DOUBLE) ? new CaseSearchedDoubleVectorProcessor(conditionProcessors, thenProcessors) : new CaseSearchedObjectVectorProcessor(outputType, conditionProcessors, thenProcessors));
        return processor;
    }
}

