/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.math.expr;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.druid.annotations.SubclassesMustOverrideEqualsAndHashCode;
import org.apache.druid.java.util.common.Cacheable;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.math.expr.ExprEval;
import org.apache.druid.math.expr.ExpressionDruidPredicateFactory;
import org.apache.druid.math.expr.ExpressionPredicateIndexSupplier;
import org.apache.druid.math.expr.ExpressionType;
import org.apache.druid.math.expr.Exprs;
import org.apache.druid.math.expr.IdentifierExpr;
import org.apache.druid.math.expr.InputBindings;
import org.apache.druid.math.expr.vector.ExprVectorProcessor;
import org.apache.druid.query.cache.CacheKeyBuilder;
import org.apache.druid.query.filter.ColumnIndexSelector;
import org.apache.druid.segment.column.ColumnCapabilities;
import org.apache.druid.segment.column.ColumnIndexSupplier;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.filter.Filters;
import org.apache.druid.segment.index.AllFalseBitmapColumnIndex;
import org.apache.druid.segment.index.AllTrueBitmapColumnIndex;
import org.apache.druid.segment.index.AllUnknownBitmapColumnIndex;
import org.apache.druid.segment.index.BitmapColumnIndex;
import org.apache.druid.segment.index.semantic.DictionaryEncodedValueIndex;
import org.apache.druid.segment.serde.NoIndexesColumnIndexSupplier;
import org.apache.druid.segment.virtual.ExpressionSelectors;

@SubclassesMustOverrideEqualsAndHashCode
public interface Expr
extends Cacheable {
    public static final String NULL_LITERAL = "null";
    public static final Joiner ARG_JOINER = Joiner.on((String)", ");

    default public boolean isLiteral() {
        return false;
    }

    default public boolean isNullLiteral() {
        return false;
    }

    default public boolean isIdentifier() {
        return false;
    }

    @Nullable
    default public Object getLiteralValue() {
        throw new ISE("Not a literal", new Object[0]);
    }

    @Nullable
    default public IdentifierExpr getIdentifierExprIfIdentifierExpr() {
        return null;
    }

    @Nullable
    default public String getIdentifierIfIdentifier() {
        return null;
    }

    @Nullable
    default public String getBindingIfIdentifier() {
        return null;
    }

    public ExprEval eval(ObjectBinding var1);

    public String stringify();

    public Expr visit(Shuttle var1);

    public BindingAnalysis analyzeInputs();

    @Nullable
    default public ExpressionType getOutputType(InputBindingInspector inspector) {
        return null;
    }

    default public boolean canVectorize(InputBindingInspector inspector) {
        return false;
    }

    default public Expr asSingleThreaded(InputBindingInspector inspector) {
        return this;
    }

    default public <T> ExprVectorProcessor<T> asVectorProcessor(VectorInputBindingInspector inspector) {
        throw Exprs.cannotVectorize(this);
    }

    @Nullable
    default public ColumnIndexSupplier asColumnIndexSupplier(ColumnIndexSelector columnIndexSelector, @Nullable ColumnType outputType) {
        BindingAnalysis details = this.analyzeInputs();
        if (details.getRequiredBindings().size() == 1) {
            String column = (String)Iterables.getOnlyElement(details.getRequiredBindings());
            ColumnIndexSupplier delegateIndexSupplier = columnIndexSelector.getIndexSupplier(column);
            if (delegateIndexSupplier == null) {
                if (this.eval(InputBindings.nilBindings()).value() != null) {
                    return NoIndexesColumnIndexSupplier.getInstance();
                }
                return null;
            }
            DictionaryEncodedValueIndex delegateRawIndex = delegateIndexSupplier.as(DictionaryEncodedValueIndex.class);
            ColumnCapabilities capabilities = columnIndexSelector.getColumnCapabilities(column);
            if (!ExpressionSelectors.canMapOverDictionary(details, capabilities)) {
                return NoIndexesColumnIndexSupplier.getInstance();
            }
            ExpressionType inputType = ExpressionType.fromColumnTypeStrict(capabilities);
            ColumnType outType = outputType == null ? ExpressionType.toColumnType(this.getOutputType(InputBindings.inspectorForColumn(column, inputType))) : outputType;
            if (delegateRawIndex != null && outputType != null) {
                return new ExpressionPredicateIndexSupplier(this, column, inputType, outType, delegateRawIndex);
            }
        }
        return NoIndexesColumnIndexSupplier.getInstance();
    }

    @Nullable
    default public BitmapColumnIndex asBitmapColumnIndex(ColumnIndexSelector selector) {
        String column;
        ColumnCapabilities capabilities;
        BindingAnalysis details = this.analyzeInputs();
        if (details.getRequiredBindings().isEmpty()) {
            ExprEval eval = this.eval(InputBindings.nilBindings());
            if (eval.value() == null) {
                return new AllUnknownBitmapColumnIndex(selector);
            }
            if (eval.asBoolean()) {
                return new AllTrueBitmapColumnIndex(selector);
            }
            return new AllFalseBitmapColumnIndex(selector.getBitmapFactory());
        }
        if (details.getRequiredBindings().size() == 1 && ExpressionSelectors.canMapOverDictionary(details, capabilities = selector.getColumnCapabilities(column = (String)Iterables.getOnlyElement(details.getRequiredBindings())))) {
            return Filters.makePredicateIndex(column, selector, new ExpressionDruidPredicateFactory(this, capabilities));
        }
        return null;
    }

    default public void decorateCacheKeyBuilder(CacheKeyBuilder builder) {
    }

    @Override
    default public byte[] getCacheKey() {
        CacheKeyBuilder builder = new CacheKeyBuilder(0).appendString(this.stringify());
        Shuttle keyShuttle = expr -> {
            expr.decorateCacheKeyBuilder(builder);
            return expr;
        };
        this.visit(keyShuttle);
        return builder.build();
    }

    public static Expr singleThreaded(Expr expr, InputBindingInspector inspector) {
        return expr.visit(node -> node.asSingleThreaded(inspector));
    }

    public static class BindingAnalysis {
        public static final BindingAnalysis EMTPY = new BindingAnalysis();
        private final ImmutableSet<IdentifierExpr> freeVariables;
        private final ImmutableSet<IdentifierExpr> scalarVariables;
        private final ImmutableSet<IdentifierExpr> arrayVariables;
        private final boolean hasInputArrays;
        private final boolean isOutputArray;

        public BindingAnalysis() {
            this((ImmutableSet<IdentifierExpr>)ImmutableSet.of(), (ImmutableSet<IdentifierExpr>)ImmutableSet.of(), (ImmutableSet<IdentifierExpr>)ImmutableSet.of(), false, false);
        }

        BindingAnalysis(IdentifierExpr expr) {
            this((ImmutableSet<IdentifierExpr>)ImmutableSet.of((Object)expr), (ImmutableSet<IdentifierExpr>)ImmutableSet.of(), (ImmutableSet<IdentifierExpr>)ImmutableSet.of(), false, false);
        }

        private BindingAnalysis(ImmutableSet<IdentifierExpr> freeVariables, ImmutableSet<IdentifierExpr> scalarVariables, ImmutableSet<IdentifierExpr> arrayVariables, boolean hasInputArrays, boolean isOutputArray) {
            this.freeVariables = freeVariables;
            this.scalarVariables = scalarVariables;
            this.arrayVariables = arrayVariables;
            this.hasInputArrays = hasInputArrays;
            this.isOutputArray = isOutputArray;
        }

        public static BindingAnalysis collect(Collection<BindingAnalysis> others) {
            if (others.isEmpty()) {
                return EMTPY;
            }
            if (others.size() == 1) {
                return (BindingAnalysis)Iterables.getOnlyElement(others);
            }
            ImmutableSet.Builder freeVariables = ImmutableSet.builder();
            ImmutableSet.Builder scalarVariables = ImmutableSet.builder();
            ImmutableSet.Builder arrayVariables = ImmutableSet.builder();
            boolean hasInputArrays = false;
            boolean isOutputArray = false;
            for (BindingAnalysis other : others) {
                hasInputArrays = hasInputArrays || other.hasInputArrays;
                isOutputArray = isOutputArray || other.isOutputArray;
                freeVariables.addAll(other.freeVariables);
                scalarVariables.addAll(other.scalarVariables);
                arrayVariables.addAll(other.arrayVariables);
            }
            return new BindingAnalysis((ImmutableSet<IdentifierExpr>)freeVariables.build(), (ImmutableSet<IdentifierExpr>)scalarVariables.build(), (ImmutableSet<IdentifierExpr>)arrayVariables.build(), hasInputArrays, isOutputArray);
        }

        public static BindingAnalysis collectExprs(Collection<Expr> exprs) {
            return BindingAnalysis.collect(exprs.stream().map(Expr::analyzeInputs).collect(Collectors.toList()));
        }

        public List<String> getRequiredBindingsList() {
            return new ArrayList<String>(this.getRequiredBindings());
        }

        public Set<String> getRequiredBindings() {
            return BindingAnalysis.map(this.freeVariables, IdentifierExpr::getBindingIfIdentifier);
        }

        Set<String> getScalarBindings() {
            return BindingAnalysis.map(this.scalarVariables, IdentifierExpr::getBindingIfIdentifier);
        }

        public Set<String> getArrayBindings() {
            return BindingAnalysis.map(this.arrayVariables, IdentifierExpr::getBindingIfIdentifier);
        }

        public Set<IdentifierExpr> getFreeVariables() {
            return this.freeVariables;
        }

        Set<String> getScalarVariables() {
            return BindingAnalysis.map(this.scalarVariables, IdentifierExpr::getIdentifier);
        }

        Set<String> getArrayVariables() {
            return BindingAnalysis.map(this.arrayVariables, IdentifierExpr::getIdentifier);
        }

        public boolean hasInputArrays() {
            return this.hasInputArrays;
        }

        public boolean isOutputArray() {
            return this.isOutputArray;
        }

        public BindingAnalysis withScalarArguments(Set<Expr> scalarArguments) {
            HashSet<IdentifierExpr> moreScalars = new HashSet<IdentifierExpr>();
            for (Expr expr : scalarArguments) {
                boolean isIdentiferExpr = expr.getIdentifierExprIfIdentifierExpr() != null;
                if (!isIdentiferExpr) continue;
                moreScalars.add((IdentifierExpr)expr);
            }
            return new BindingAnalysis((ImmutableSet<IdentifierExpr>)ImmutableSet.copyOf((Collection)Sets.union(this.freeVariables, moreScalars)), (ImmutableSet<IdentifierExpr>)ImmutableSet.copyOf((Collection)Sets.union(this.scalarVariables, moreScalars)), this.arrayVariables, this.hasInputArrays, this.isOutputArray);
        }

        public BindingAnalysis withArrayArguments(Set<Expr> arrayArguments) {
            HashSet<IdentifierExpr> arrayIdentifiers = new HashSet<IdentifierExpr>();
            for (Expr expr : arrayArguments) {
                boolean isIdentifierExpr = expr.getIdentifierExprIfIdentifierExpr() != null;
                if (!isIdentifierExpr) continue;
                arrayIdentifiers.add((IdentifierExpr)expr);
            }
            return new BindingAnalysis((ImmutableSet<IdentifierExpr>)ImmutableSet.copyOf((Collection)Sets.union(this.freeVariables, arrayIdentifiers)), this.scalarVariables, (ImmutableSet<IdentifierExpr>)ImmutableSet.copyOf((Collection)Sets.union(this.arrayVariables, arrayIdentifiers)), this.hasInputArrays || !arrayArguments.isEmpty(), this.isOutputArray);
        }

        public BindingAnalysis withArrayInputs(boolean hasArrays) {
            return new BindingAnalysis(this.freeVariables, this.scalarVariables, this.arrayVariables, hasArrays || !this.arrayVariables.isEmpty(), this.isOutputArray);
        }

        public BindingAnalysis withArrayOutput(boolean isOutputArray) {
            return new BindingAnalysis(this.freeVariables, this.scalarVariables, this.arrayVariables, this.hasInputArrays, isOutputArray);
        }

        BindingAnalysis removeLambdaArguments(Set<String> lambda) {
            return new BindingAnalysis((ImmutableSet<IdentifierExpr>)ImmutableSet.copyOf(this.freeVariables.stream().filter(x -> !lambda.contains(x.getIdentifier())).iterator()), (ImmutableSet<IdentifierExpr>)ImmutableSet.copyOf(this.scalarVariables.stream().filter(x -> !lambda.contains(x.getIdentifier())).iterator()), (ImmutableSet<IdentifierExpr>)ImmutableSet.copyOf(this.arrayVariables.stream().filter(x -> !lambda.contains(x.getIdentifier())).iterator()), this.hasInputArrays, this.isOutputArray);
        }

        private static Set<String> map(Set<IdentifierExpr> variables, Function<IdentifierExpr, String> mapper) {
            HashSet results = Sets.newHashSetWithExpectedSize((int)variables.size());
            for (IdentifierExpr variable : variables) {
                results.add(mapper.apply(variable));
            }
            return results;
        }
    }

    public static interface ObjectBinding
    extends InputBindingInspector {
        @Nullable
        public Object get(String var1);
    }

    public static interface InputBindingInspector {
        @Nullable
        public ExpressionType getType(String var1);

        default public boolean areNumeric(List<Expr> args) {
            boolean numeric = true;
            for (Expr arg : args) {
                ExpressionType argType = arg.getOutputType(this);
                if (argType == null) continue;
                numeric = numeric && argType.isNumeric();
            }
            return numeric;
        }

        default public boolean areNumeric(Expr ... args) {
            return this.areNumeric(Arrays.asList(args));
        }

        default public boolean areSameTypes(List<Expr> args) {
            ExpressionType currentType = null;
            boolean allSame = true;
            for (Expr arg : args) {
                ExpressionType argType = arg.getOutputType(this);
                if (argType == null) continue;
                if (currentType == null) {
                    currentType = argType;
                }
                allSame = allSame && Objects.equals(argType, currentType);
            }
            return allSame;
        }

        default public boolean areSameTypes(Expr ... args) {
            return this.areSameTypes(Arrays.asList(args));
        }

        default public boolean areScalar(List<Expr> args) {
            boolean scalar = true;
            for (Expr arg : args) {
                ExpressionType argType = arg.getOutputType(this);
                if (argType == null) continue;
                scalar = scalar && argType.isPrimitive();
            }
            return scalar;
        }

        default public boolean areScalar(Expr ... args) {
            return this.areScalar(Arrays.asList(args));
        }

        default public boolean canVectorize(List<Expr> args) {
            boolean canVectorize = true;
            for (Expr arg : args) {
                canVectorize = canVectorize && arg.canVectorize(this);
            }
            return canVectorize;
        }

        default public boolean canVectorize(Expr ... args) {
            return this.canVectorize(Arrays.asList(args));
        }
    }

    public static interface Shuttle {
        public Expr visit(Expr var1);

        default public List<Expr> visitAll(List<Expr> exprs) {
            ArrayList<Expr> newExprs = new ArrayList<Expr>();
            for (Expr arg : exprs) {
                newExprs.add(arg.visit(this));
            }
            return newExprs;
        }
    }

    public static interface VectorInputBinding
    extends VectorInputBindingInspector {
        public Object[] getObjectVector(String var1);

        public long[] getLongVector(String var1);

        public double[] getDoubleVector(String var1);

        @Nullable
        public boolean[] getNullVector(String var1);

        public int getCurrentVectorSize();

        public int getCurrentVectorId();
    }

    public static interface VectorInputBindingInspector
    extends InputBindingInspector {
        public int getMaxVectorSize();
    }
}

