/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.math.expr;

import javax.annotation.Nullable;
import org.apache.druid.math.expr.BinaryOpExprBase;
import org.apache.druid.math.expr.Expr;
import org.apache.druid.math.expr.ExprEval;
import org.apache.druid.math.expr.ExprType;
import org.apache.druid.math.expr.ExpressionType;
import org.apache.druid.math.expr.ExpressionTypeConversion;

abstract class BinaryBooleanOpExprBase
extends BinaryOpExprBase {
    BinaryBooleanOpExprBase(String op, Expr left, Expr right) {
        super(op, left, right);
    }

    @Override
    public ExprEval eval(Expr.ObjectBinding bindings) {
        boolean result;
        ExprEval leftVal = this.left.eval(bindings);
        ExprEval rightVal = this.right.eval(bindings);
        if (leftVal.value() == null || rightVal.value() == null) {
            return ExprEval.ofMissing();
        }
        ExpressionType type = ExpressionTypeConversion.autoDetect(leftVal, rightVal);
        switch ((ExprType)type.getType()) {
            case STRING: {
                result = this.evalString(leftVal.asString(), rightVal.asString());
                break;
            }
            case LONG: {
                result = this.evalLong(leftVal.asLong(), rightVal.asLong());
                break;
            }
            case ARRAY: {
                result = this.evalArray(leftVal, rightVal);
                break;
            }
            default: {
                if (leftVal.isNumericNull() || rightVal.isNumericNull()) {
                    return ExprEval.ofMissing();
                }
                result = this.evalDouble(leftVal.asDouble(), rightVal.asDouble());
            }
        }
        return ExprEval.ofLongBoolean(result);
    }

    protected abstract boolean evalString(@Nullable String var1, @Nullable String var2);

    protected abstract boolean evalLong(long var1, long var3);

    protected abstract boolean evalDouble(double var1, double var3);

    protected abstract boolean evalArray(ExprEval var1, ExprEval var2);

    @Override
    @Nullable
    public ExpressionType getOutputType(Expr.InputBindingInspector inspector) {
        return ExpressionType.LONG;
    }

    @Override
    public boolean canVectorize(Expr.InputBindingInspector inspector) {
        ExpressionType leftType = this.left.getOutputType(inspector);
        ExpressionType rightType = this.right.getOutputType(inspector);
        ExpressionType commonType = ExpressionTypeConversion.leastRestrictiveType(leftType, rightType);
        return inspector.canVectorize(this.left, this.right) && (commonType == null || commonType.isPrimitive());
    }
}

