/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.math.expr;

import javax.annotation.Nullable;
import org.apache.druid.math.expr.BinaryEvalOpExprBase;
import org.apache.druid.math.expr.BinaryOpExprBase;
import org.apache.druid.math.expr.Expr;
import org.apache.druid.math.expr.ExprEval;
import org.apache.druid.math.expr.ExprType;
import org.apache.druid.math.expr.ExpressionType;
import org.apache.druid.math.expr.ExpressionTypeConversion;
import org.apache.druid.math.expr.vector.ExprVectorProcessor;
import org.apache.druid.math.expr.vector.VectorMathProcessors;
import org.apache.druid.math.expr.vector.VectorStringProcessors;
import org.apache.druid.segment.column.Types;

final class BinPlusExpr
extends BinaryEvalOpExprBase {
    BinPlusExpr(String op, Expr left, Expr right) {
        super(op, left, right);
    }

    @Override
    protected BinaryOpExprBase copy(Expr left, Expr right) {
        return new BinPlusExpr(this.op, left, right);
    }

    @Override
    protected ExprEval evalString(@Nullable String left, @Nullable String right) {
        return ExprEval.ofString(left + right);
    }

    @Override
    protected long evalLong(long left, long right) {
        return left + right;
    }

    @Override
    protected double evalDouble(double left, double right) {
        return left + right;
    }

    @Override
    public boolean canVectorize(Expr.InputBindingInspector inspector) {
        return inspector.areScalar(this.left, this.right) && inspector.canVectorize(this.left, this.right);
    }

    @Override
    public <T> ExprVectorProcessor<T> asVectorProcessor(Expr.VectorInputBindingInspector inspector) {
        ExpressionType type = ExpressionTypeConversion.operator(this.left.getOutputType(inspector), this.right.getOutputType(inspector));
        if (Types.is(type, ExprType.STRING)) {
            return VectorStringProcessors.concat(inspector, this.left, this.right);
        }
        return VectorMathProcessors.plus().asProcessor(inspector, this.left, this.right);
    }
}

