/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.java.util.metrics.cgroups;

import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.java.util.metrics.cgroups.CgroupDiscoverer;
import org.apache.druid.java.util.metrics.cgroups.CgroupVersion;
import org.apache.druid.java.util.metrics.cgroups.Cpu;
import org.apache.druid.java.util.metrics.cgroups.CpuSet;
import org.apache.druid.java.util.metrics.cgroups.ProcCgroupDiscoverer;
import org.apache.druid.java.util.metrics.cgroups.ProcCgroupV2Discoverer;

public class ProcSelfCgroupDiscoverer
implements CgroupDiscoverer {
    private static final Logger LOG = new Logger(ProcSelfCgroupDiscoverer.class);
    private final CgroupDiscoverer delegate;

    public ProcSelfCgroupDiscoverer() {
        this(ProcCgroupDiscoverer.class);
    }

    public static CgroupDiscoverer autoCgroupDiscoverer() {
        return ProcSelfCgroupDiscoverer.autoCgroupDiscoverer(Paths.get("/proc/self", new String[0]));
    }

    public ProcSelfCgroupDiscoverer(Class<? extends CgroupDiscoverer> discoverer) {
        try {
            this.delegate = discoverer.getDeclaredConstructor(Path.class).newInstance(Paths.get("/proc/self", new String[0]));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Path discover(String cgroup) {
        return this.delegate.discover(cgroup);
    }

    @Override
    public Cpu.CpuMetrics getCpuMetrics() {
        return this.delegate.getCpuMetrics();
    }

    @Override
    public CpuSet.CpuSetMetric getCpuSetMetrics() {
        return this.delegate.getCpuSetMetrics();
    }

    @Override
    public CgroupVersion getCgroupVersion() {
        return this.delegate.getCgroupVersion();
    }

    public static CgroupDiscoverer autoCgroupDiscoverer(Path procPidDir) {
        CgroupVersion version = ProcSelfCgroupDiscoverer.detectCgroupVersion(procPidDir);
        switch (version) {
            case V2: {
                LOG.info("Detected cgroups v2, using ProcCgroupV2Discoverer", new Object[0]);
                return new ProcCgroupV2Discoverer(procPidDir);
            }
            case V1: {
                LOG.info("Detected cgroups v1, using ProcCgroupDiscoverer", new Object[0]);
                return new ProcCgroupDiscoverer(procPidDir);
            }
        }
        LOG.warn("Could not detect cgroups version, falling back to cgroups v1 discoverer", new Object[0]);
        return new ProcCgroupDiscoverer(procPidDir);
    }

    private static CgroupVersion detectCgroupVersion(Path procPidDir) {
        File mountsFile = new File(procPidDir.toFile(), "mounts");
        if (!mountsFile.exists() || !mountsFile.canRead()) {
            LOG.warn("Cannot read mounts file at [%s], unable to detect cgroups version", mountsFile);
            return CgroupVersion.UNKNOWN;
        }
        try {
            boolean hasV1 = false;
            boolean hasV2 = false;
            for (String line : Files.readLines((File)mountsFile, (Charset)StandardCharsets.UTF_8)) {
                String[] parts = line.split("\\s+");
                if (parts.length < 3) continue;
                String fsType = parts[2];
                if ("cgroup".equals(fsType)) {
                    hasV1 = true;
                    continue;
                }
                if (!"cgroup2".equals(fsType)) continue;
                hasV2 = true;
            }
            if (hasV2) {
                return CgroupVersion.V2;
            }
            if (hasV1) {
                return CgroupVersion.V1;
            }
            return CgroupVersion.UNKNOWN;
        }
        catch (IOException e) {
            LOG.warn(e, "Error reading mounts file [%s], unable to detect cgroups version", mountsFile);
            return CgroupVersion.UNKNOWN;
        }
    }
}

