/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.java.util.metrics.cgroups;

import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import org.apache.druid.java.util.common.RE;
import org.apache.druid.java.util.metrics.cgroups.CgroupVersion;
import org.apache.druid.java.util.metrics.cgroups.Cpu;
import org.apache.druid.java.util.metrics.cgroups.CpuSet;
import org.apache.druid.java.util.metrics.cgroups.CpuSetV2;
import org.apache.druid.java.util.metrics.cgroups.CpuV2;
import org.apache.druid.java.util.metrics.cgroups.ProcCgroupDiscoverer;

public class ProcCgroupV2Discoverer
extends ProcCgroupDiscoverer {
    private static final String CGROUP_TYPE = "cgroup2";

    public ProcCgroupV2Discoverer(Path procDir) {
        super(procDir);
    }

    @Override
    public Path discover(String cgroup) {
        try {
            for (String line : Files.readLines((File)new File(this.procDir, "mounts"), (Charset)StandardCharsets.UTF_8)) {
                ProcCgroupDiscoverer.ProcMountsEntry entry = ProcCgroupDiscoverer.ProcMountsEntry.parse(line);
                if (!CGROUP_TYPE.equals(entry.type)) continue;
                return entry.path;
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        throw new RE("Cgroup location not found", new Object[0]);
    }

    @Override
    public Cpu.CpuMetrics getCpuMetrics() {
        return new CpuV2(this).snapshot();
    }

    @Override
    public CpuSet.CpuSetMetric getCpuSetMetrics() {
        return new CpuSetV2(this).snapshot();
    }

    @Override
    public CgroupVersion getCgroupVersion() {
        return CgroupVersion.V2;
    }
}

