/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.java.util.metrics.cgroups;

import com.google.common.primitives.Longs;
import java.io.BufferedReader;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.regex.Pattern;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.java.util.metrics.CgroupUtil;
import org.apache.druid.java.util.metrics.cgroups.CgroupDiscoverer;
import org.apache.druid.java.util.metrics.cgroups.Cpu;

public class CpuV2 {
    public static final String CGROUP = "";
    private static final Logger LOG = new Logger(CpuV2.class);
    private static final String CPU_STAT_FILE = "cpu.stat";
    private static final String CPU_WEIGHT_FILE = "cpu.weight";
    private static final String CPU_MAX_FILE = "cpu.max";
    private final CgroupDiscoverer cgroupDiscoverer;

    public CpuV2(CgroupDiscoverer cgroupDiscoverer) {
        this.cgroupDiscoverer = cgroupDiscoverer;
    }

    public Cpu.CpuMetrics snapshot() {
        long usageUsec = -1L;
        long userUsec = -1L;
        long systemUsec = -1L;
        try (BufferedReader reader = Files.newBufferedReader(Paths.get(this.cgroupDiscoverer.discover(CGROUP).toString(), CPU_STAT_FILE));){
            String line = reader.readLine();
            while (line != null) {
                String[] parts = line.split(Pattern.quote(" "));
                if (parts.length == 2) {
                    switch (parts[0]) {
                        case "usage_usec": {
                            usageUsec = Longs.tryParse((String)parts[1]);
                            break;
                        }
                        case "user_usec": {
                            userUsec = Longs.tryParse((String)parts[1]);
                            break;
                        }
                        case "system_usec": {
                            systemUsec = Longs.tryParse((String)parts[1]);
                        }
                    }
                }
                line = reader.readLine();
            }
        }
        catch (IOException | RuntimeException ex) {
            LOG.noStackTrace().warn(ex, "Unable to fetch CPU v2 snapshot. Cgroup metrics will not be emitted.", new Object[0]);
        }
        long weight = CgroupUtil.readLongValue(this.cgroupDiscoverer, CGROUP, CPU_WEIGHT_FILE, -1L);
        long quotaUs = -1L;
        long periodUs = -1L;
        try (BufferedReader reader = Files.newBufferedReader(Paths.get(this.cgroupDiscoverer.discover(CGROUP).toString(), CPU_MAX_FILE));){
            String[] parts;
            String line = reader.readLine();
            if (line != null && !line.trim().startsWith("max") && (parts = line.trim().split("\\s+")).length == 2) {
                quotaUs = Longs.tryParse((String)parts[0]);
                periodUs = Longs.tryParse((String)parts[1]);
            }
        }
        catch (IOException | RuntimeException ex) {
            LOG.noStackTrace().warn(ex, "Unable to read cpu.max file.", new Object[0]);
        }
        long shares = CpuV2.convertWeightToShares(weight);
        return new Cpu.CpuMetrics(shares, quotaUs, periodUs, -1L, -1L, userUsec, systemUsec, usageUsec);
    }

    private static long convertWeightToShares(long weight) {
        if (weight <= 0L) {
            return -1L;
        }
        return Math.max(2L, weight * 1024L / 100L);
    }
}

