/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.java.util.metrics;

import com.google.common.collect.Sets;
import com.google.errorprone.annotations.concurrent.GuardedBy;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.lifecycle.LifecycleStart;
import org.apache.druid.java.util.common.lifecycle.LifecycleStop;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.java.util.emitter.service.ServiceEmitter;
import org.apache.druid.java.util.metrics.DruidMonitorSchedulerConfig;
import org.apache.druid.java.util.metrics.Monitor;

public abstract class MonitorScheduler {
    private static final Logger log = new Logger(MonitorScheduler.class);
    private final DruidMonitorSchedulerConfig config;
    private final ServiceEmitter emitter;
    private final Set<Monitor> monitors;
    private final Object lock = new Object();
    private volatile boolean started = false;

    MonitorScheduler(DruidMonitorSchedulerConfig config, ServiceEmitter emitter, List<Monitor> monitors) {
        this.config = config;
        this.emitter = emitter;
        this.monitors = Sets.newHashSet(monitors);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @LifecycleStart
    public void start() {
        Object object = this.lock;
        synchronized (object) {
            if (this.started) {
                return;
            }
            this.started = true;
            for (Monitor monitor : this.monitors) {
                this.startMonitor(monitor);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMonitor(Monitor monitor) {
        Object object = this.lock;
        synchronized (object) {
            if (!this.started) {
                throw new ISE("addMonitor must be called after start", new Object[0]);
            }
            if (this.hasMonitor(monitor)) {
                throw new ISE("Monitor already monitoring: %s", monitor);
            }
            this.monitors.add(monitor);
            this.startMonitor(monitor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMonitor(Monitor monitor) {
        Object object = this.lock;
        synchronized (object) {
            this.monitors.remove(monitor);
            try {
                monitor.monitor(this.emitter);
            }
            catch (Throwable t) {
                log.warn(t, "Monitor could not emit finally before being removed from scheduler", new Object[0]);
            }
            monitor.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends Monitor> Optional<T> findMonitor(Class<T> monitorClass) {
        Object object = this.lock;
        synchronized (object) {
            return this.monitors.stream().filter(m -> m.getClass() == monitorClass).findFirst();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @LifecycleStop
    public void stop() {
        Object object = this.lock;
        synchronized (object) {
            if (!this.started) {
                return;
            }
            this.started = false;
            ArrayList<Monitor> monitorsCopy = new ArrayList<Monitor>(this.monitors);
            for (Monitor monitor : monitorsCopy) {
                this.removeMonitor(monitor);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean hasMonitor(Monitor monitor) {
        Object object = this.lock;
        synchronized (object) {
            return this.monitors.contains(monitor);
        }
    }

    DruidMonitorSchedulerConfig getConfig() {
        return this.config;
    }

    ServiceEmitter getEmitter() {
        return this.emitter;
    }

    @GuardedBy(value="lock")
    abstract void startMonitor(Monitor var1);
}

