/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.java.util.metrics;

import com.google.common.base.Preconditions;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.java.util.emitter.service.ServiceEmitter;
import org.apache.druid.java.util.emitter.service.ServiceMetricEvent;
import org.apache.druid.java.util.metrics.CgroupV2CpuMonitor;
import org.apache.druid.java.util.metrics.FeedDefiningMonitor;
import org.apache.druid.java.util.metrics.cgroups.CgroupDiscoverer;
import org.apache.druid.java.util.metrics.cgroups.CgroupVersion;
import org.apache.druid.java.util.metrics.cgroups.CpuAcct;
import org.apache.druid.java.util.metrics.cgroups.ProcSelfCgroupDiscoverer;
import org.joda.time.DateTime;

public class CpuAcctDeltaMonitor
extends FeedDefiningMonitor {
    private static final Logger log = new Logger(CpuAcctDeltaMonitor.class);
    private static final String USE_CGROUPS_V2_MESSAGE = StringUtils.format("%s doest not function correctly on cgroups v2. Please use %s instead.", CpuAcctDeltaMonitor.class.getSimpleName(), CgroupV2CpuMonitor.class.getSimpleName());
    private final AtomicReference<SnapshotHolder> priorSnapshot = new AtomicReference<Object>(null);
    private final CgroupDiscoverer cgroupDiscoverer;
    private final boolean isRunningOnCgroupsV2;

    public CpuAcctDeltaMonitor() {
        this("metrics");
    }

    public CpuAcctDeltaMonitor(String feed) {
        this(feed, ProcSelfCgroupDiscoverer.autoCgroupDiscoverer());
    }

    public CpuAcctDeltaMonitor(String feed, CgroupDiscoverer cgroupDiscoverer) {
        super(feed);
        this.cgroupDiscoverer = (CgroupDiscoverer)Preconditions.checkNotNull((Object)cgroupDiscoverer, (Object)"cgroupDiscoverer required");
        this.isRunningOnCgroupsV2 = cgroupDiscoverer.getCgroupVersion().equals((Object)CgroupVersion.V2);
        if (this.isRunningOnCgroupsV2) {
            log.warn(USE_CGROUPS_V2_MESSAGE, new Object[0]);
        }
    }

    @Override
    public boolean doMonitor(ServiceEmitter emitter) {
        if (this.isRunningOnCgroupsV2) {
            log.warn(USE_CGROUPS_V2_MESSAGE, new Object[0]);
            return false;
        }
        CpuAcct cpuAcct = new CpuAcct(this.cgroupDiscoverer);
        CpuAcct.CpuAcctMetric snapshot = cpuAcct.snapshot();
        long nanoTime = System.nanoTime();
        DateTime dateTime = DateTimes.nowUtc();
        SnapshotHolder priorSnapshotHolder = this.priorSnapshot.get();
        if (!this.priorSnapshot.compareAndSet(priorSnapshotHolder, new SnapshotHolder(snapshot, nanoTime))) {
            log.debug("Pre-empted by another monitor run", new Object[0]);
            return false;
        }
        if (priorSnapshotHolder == null) {
            log.info("Detected first run, storing result for next run", new Object[0]);
            return false;
        }
        long elapsedNs = nanoTime - priorSnapshotHolder.timestamp;
        if (snapshot.cpuCount() != priorSnapshotHolder.metric.cpuCount()) {
            log.warn("Prior CPU count [%d] does not match current cpu count [%d]. Skipping metrics emission", priorSnapshotHolder.metric.cpuCount(), snapshot.cpuCount());
            return false;
        }
        for (int i = 0; i < snapshot.cpuCount(); ++i) {
            ServiceMetricEvent.Builder builderUsr = this.builder().setDimension("cpuName", Integer.toString(i)).setDimension("cpuTime", "usr").setDimension("cgroupversion", this.cgroupDiscoverer.getCgroupVersion().name());
            ServiceMetricEvent.Builder builderSys = this.builder().setDimension("cpuName", Integer.toString(i)).setDimension("cpuTime", "sys").setDimension("cgroupversion", this.cgroupDiscoverer.getCgroupVersion().name());
            emitter.emit(builderUsr.setCreatedTime(dateTime).setMetric("cgroup/cpu_time_delta_ns", snapshot.usrTime(i) - priorSnapshotHolder.metric.usrTime(i)));
            emitter.emit(builderSys.setCreatedTime(dateTime).setMetric("cgroup/cpu_time_delta_ns", snapshot.sysTime(i) - priorSnapshotHolder.metric.sysTime(i)));
        }
        if (snapshot.cpuCount() > 0) {
            emitter.emit(this.builder().setCreatedTime(dateTime).setMetric("cgroup/cpu_time_delta_ns_elapsed", elapsedNs));
        }
        return true;
    }

    static class SnapshotHolder {
        private final CpuAcct.CpuAcctMetric metric;
        private final long timestamp;

        SnapshotHolder(CpuAcct.CpuAcctMetric metric, long timestamp) {
            this.metric = metric;
            this.timestamp = timestamp;
        }
    }
}

