/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.java.util.metrics;

import com.google.common.annotations.VisibleForTesting;
import org.apache.druid.java.util.emitter.service.ServiceEmitter;
import org.apache.druid.java.util.metrics.CgroupMemoryMonitor;
import org.apache.druid.java.util.metrics.FeedDefiningMonitor;
import org.apache.druid.java.util.metrics.cgroups.CgroupDiscoverer;
import org.apache.druid.java.util.metrics.cgroups.ProcCgroupV2Discoverer;
import org.apache.druid.java.util.metrics.cgroups.ProcSelfCgroupDiscoverer;

public class CgroupV2MemoryMonitor
extends FeedDefiningMonitor {
    private static final String MEMORY_USAGE_FILE = "memory.current";
    private static final String MEMORY_LIMIT_FILE = "memory.max";
    private final CgroupDiscoverer cgroupDiscoverer;

    @VisibleForTesting
    CgroupV2MemoryMonitor(CgroupDiscoverer cgroupDiscoverer, String feed) {
        super(feed);
        this.cgroupDiscoverer = cgroupDiscoverer;
    }

    public CgroupV2MemoryMonitor(String feed) {
        this(new ProcSelfCgroupDiscoverer(ProcCgroupV2Discoverer.class), feed);
    }

    public CgroupV2MemoryMonitor() {
        this("metrics");
    }

    @Override
    public boolean doMonitor(ServiceEmitter emitter) {
        return CgroupMemoryMonitor.parseAndEmit(emitter, this.cgroupDiscoverer, MEMORY_USAGE_FILE, MEMORY_LIMIT_FILE, this);
    }
}

