/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.java.util.metrics;

import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.java.util.emitter.service.ServiceEmitter;
import org.apache.druid.java.util.emitter.service.ServiceMetricEvent;
import org.apache.druid.java.util.metrics.CgroupV2MemoryMonitor;
import org.apache.druid.java.util.metrics.FeedDefiningMonitor;
import org.apache.druid.java.util.metrics.cgroups.CgroupDiscoverer;
import org.apache.druid.java.util.metrics.cgroups.CgroupVersion;
import org.apache.druid.java.util.metrics.cgroups.Memory;
import org.apache.druid.java.util.metrics.cgroups.ProcSelfCgroupDiscoverer;

public class CgroupMemoryMonitor
extends FeedDefiningMonitor {
    private static final Logger LOG = new Logger(CgroupMemoryMonitor.class);
    private static final String MEMORY_USAGE_FILE = "memory.usage_in_bytes";
    private static final String MEMORY_LIMIT_FILE = "memory.limit_in_bytes";
    final CgroupDiscoverer cgroupDiscoverer;
    private final boolean isRunningOnCgroupsV2;
    private final CgroupV2MemoryMonitor cgroupV2MemoryMonitor;

    public CgroupMemoryMonitor(CgroupDiscoverer cgroupDiscoverer, String feed) {
        super(feed);
        this.cgroupDiscoverer = cgroupDiscoverer;
        this.isRunningOnCgroupsV2 = cgroupDiscoverer.getCgroupVersion().equals((Object)CgroupVersion.V2);
        if (this.isRunningOnCgroupsV2) {
            this.cgroupV2MemoryMonitor = new CgroupV2MemoryMonitor(cgroupDiscoverer, feed);
            LOG.info("Detected cgroups v2, using CgroupV2MemoryMonitor behavior for accurate metrics", new Object[0]);
        } else {
            this.cgroupV2MemoryMonitor = null;
        }
    }

    public CgroupMemoryMonitor(String feed) {
        this(ProcSelfCgroupDiscoverer.autoCgroupDiscoverer(), feed);
    }

    public CgroupMemoryMonitor() {
        this("metrics");
    }

    @Override
    public boolean doMonitor(ServiceEmitter emitter) {
        if (this.isRunningOnCgroupsV2) {
            return this.cgroupV2MemoryMonitor.doMonitor(emitter);
        }
        return CgroupMemoryMonitor.parseAndEmit(emitter, this.cgroupDiscoverer, MEMORY_USAGE_FILE, MEMORY_LIMIT_FILE, this);
    }

    public static boolean parseAndEmit(ServiceEmitter emitter, CgroupDiscoverer cgroupDiscoverer, String memoryUsageFile, String memoryLimitFile, FeedDefiningMonitor feedDefiningMonitor) {
        Memory memory = new Memory(cgroupDiscoverer);
        Memory.MemoryStat stat = memory.snapshot(memoryUsageFile, memoryLimitFile);
        ServiceMetricEvent.Builder builder = feedDefiningMonitor.builder();
        builder.setDimension("cgroupversion", cgroupDiscoverer.getCgroupVersion().name());
        emitter.emit(builder.setMetric("cgroup/memory/usage/bytes", stat.getUsage()));
        emitter.emit(builder.setMetric("cgroup/memory/limit/bytes", stat.getLimit()));
        stat.getMemoryStats().forEach((key, value) -> emitter.emit(builder.setMetric(StringUtils.format("cgroup/memory/%s", key), (Number)value)));
        stat.getNumaMemoryStats().forEach((key, value) -> {
            feedDefiningMonitor.builder().setDimension("numaZone", Long.toString(key));
            value.forEach((k, v) -> emitter.emit(builder.setMetric(StringUtils.format("cgroup/memory_numa/%s/pages", k), (Number)v)));
        });
        return true;
    }
}

