/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.java.util.common;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import javax.validation.Constraint;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import javax.validation.Payload;
import org.apache.druid.java.util.common.HumanReadableBytes;

@Target(value={ElementType.METHOD, ElementType.FIELD, ElementType.ANNOTATION_TYPE, ElementType.CONSTRUCTOR, ElementType.PARAMETER})
@Retention(value=RetentionPolicy.RUNTIME)
@Documented
@Constraint(validatedBy={HumanReadableBytesRangeValidator.class})
public @interface HumanReadableBytesRange {
    public long min() default 0L;

    public long max() default 0x7FFFFFFFFFFFFFFFL;

    public Class<?>[] groups() default {};

    public String message() default "value must be in the range of [{min}, {max}]";

    public Class<? extends Payload>[] payload() default {};

    public static class HumanReadableBytesRangeValidator
    implements ConstraintValidator<HumanReadableBytesRange, Object> {
        private HumanReadableBytesRange range;

        public void initialize(HumanReadableBytesRange range) {
            this.range = range;
        }

        public boolean isValid(Object value, ConstraintValidatorContext context) {
            if (value == null) {
                return true;
            }
            if (value instanceof HumanReadableBytes) {
                long bytes = ((HumanReadableBytes)value).getBytes();
                return bytes >= this.range.min() && bytes <= this.range.max();
            }
            return true;
        }
    }
}

