/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.druid.guice.BuiltInTypesModule;
import org.apache.druid.segment.column.StringEncodingStrategy;
import org.apache.druid.segment.data.BitmapSerde;
import org.apache.druid.segment.data.BitmapSerdeFactory;
import org.apache.druid.segment.data.CompressionFactory;
import org.apache.druid.segment.data.CompressionStrategy;
import org.apache.druid.segment.loading.SegmentizerFactory;
import org.apache.druid.segment.nested.NestedCommonFormatColumnFormatSpec;

public class IndexSpec {
    @Nullable
    private final BitmapSerdeFactory bitmapSerdeFactory;
    @Nullable
    private final CompressionStrategy dimensionCompression;
    @Nullable
    private final StringEncodingStrategy stringDictionaryEncoding;
    @Nullable
    private final CompressionStrategy metricCompression;
    @Nullable
    private final CompressionFactory.LongEncodingStrategy longEncoding;
    @Nullable
    private final CompressionStrategy complexMetricCompression;
    @Nullable
    private final CompressionStrategy jsonCompression;
    @Nullable
    private final SegmentizerFactory segmentLoader;
    @Nullable
    private final NestedCommonFormatColumnFormatSpec autoColumnFormatSpec;

    public static IndexSpec getDefault() {
        return BuiltInTypesModule.getDefaultIndexSpec();
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonCreator
    public IndexSpec(@JsonProperty(value="bitmap") @Nullable BitmapSerdeFactory bitmapSerdeFactory, @JsonProperty(value="dimensionCompression") @Nullable CompressionStrategy dimensionCompression, @JsonProperty(value="stringDictionaryEncoding") @Nullable StringEncodingStrategy stringDictionaryEncoding, @JsonProperty(value="metricCompression") @Nullable CompressionStrategy metricCompression, @JsonProperty(value="longEncoding") @Nullable CompressionFactory.LongEncodingStrategy longEncoding, @JsonProperty(value="complexMetricCompression") @Nullable CompressionStrategy complexMetricCompression, @Deprecated @JsonProperty(value="jsonCompression") @Nullable CompressionStrategy jsonCompression, @JsonProperty(value="segmentLoader") @Nullable SegmentizerFactory segmentLoader, @JsonProperty(value="autoColumnFormatSpec") @Nullable NestedCommonFormatColumnFormatSpec autoColumnFormatSpec) {
        this.bitmapSerdeFactory = bitmapSerdeFactory;
        this.dimensionCompression = dimensionCompression;
        this.stringDictionaryEncoding = stringDictionaryEncoding;
        this.metricCompression = metricCompression;
        this.complexMetricCompression = complexMetricCompression;
        this.longEncoding = longEncoding;
        this.jsonCompression = jsonCompression;
        this.segmentLoader = segmentLoader;
        this.autoColumnFormatSpec = autoColumnFormatSpec;
    }

    @JsonProperty(value="bitmap")
    @Nullable
    public BitmapSerdeFactory getBitmapSerdeFactory() {
        return this.bitmapSerdeFactory;
    }

    @JsonProperty
    @Nullable
    public CompressionStrategy getDimensionCompression() {
        return this.dimensionCompression;
    }

    @JsonProperty
    @Nullable
    public StringEncodingStrategy getStringDictionaryEncoding() {
        return this.stringDictionaryEncoding;
    }

    @JsonProperty
    @Nullable
    public CompressionStrategy getMetricCompression() {
        return this.metricCompression;
    }

    @JsonProperty
    @Nullable
    public CompressionFactory.LongEncodingStrategy getLongEncoding() {
        return this.longEncoding;
    }

    @JsonProperty
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @Nullable
    public CompressionStrategy getComplexMetricCompression() {
        return this.complexMetricCompression;
    }

    @JsonProperty
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @Nullable
    public SegmentizerFactory getSegmentLoader() {
        return this.segmentLoader;
    }

    @Deprecated
    @JsonProperty
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @Nullable
    public CompressionStrategy getJsonCompression() {
        return this.jsonCompression;
    }

    @JsonProperty
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @Nullable
    public NestedCommonFormatColumnFormatSpec getAutoColumnFormatSpec() {
        return this.autoColumnFormatSpec;
    }

    @JsonIgnore
    public IndexSpec getEffectiveSpec() {
        Builder bob = IndexSpec.builder();
        IndexSpec defaultSpec = IndexSpec.getDefault();
        if (this.bitmapSerdeFactory != null) {
            bob.withBitmapSerdeFactory(this.bitmapSerdeFactory);
        } else if (defaultSpec.bitmapSerdeFactory != null) {
            bob.withBitmapSerdeFactory(defaultSpec.bitmapSerdeFactory);
        } else {
            bob.withBitmapSerdeFactory(new BitmapSerde.DefaultBitmapSerdeFactory());
        }
        if (this.dimensionCompression != null) {
            bob.withDimensionCompression(this.dimensionCompression);
        } else if (defaultSpec.dimensionCompression != null) {
            bob.withDimensionCompression(defaultSpec.dimensionCompression);
        } else {
            bob.withDimensionCompression(CompressionStrategy.DEFAULT_COMPRESSION_STRATEGY);
        }
        if (this.stringDictionaryEncoding != null) {
            bob.withStringDictionaryEncoding(this.stringDictionaryEncoding);
        } else if (defaultSpec.stringDictionaryEncoding != null) {
            bob.withStringDictionaryEncoding(defaultSpec.stringDictionaryEncoding);
        } else {
            bob.withStringDictionaryEncoding(StringEncodingStrategy.DEFAULT);
        }
        if (this.metricCompression != null) {
            bob.withMetricCompression(this.metricCompression);
        } else if (defaultSpec.metricCompression != null) {
            bob.withMetricCompression(defaultSpec.metricCompression);
        } else {
            bob.withMetricCompression(CompressionStrategy.DEFAULT_COMPRESSION_STRATEGY);
        }
        if (this.longEncoding != null) {
            bob.withLongEncoding(this.longEncoding);
        } else if (defaultSpec.longEncoding != null) {
            bob.withLongEncoding(defaultSpec.longEncoding);
        } else {
            bob.withLongEncoding(CompressionFactory.DEFAULT_LONG_ENCODING_STRATEGY);
        }
        if (this.complexMetricCompression != null) {
            bob.withComplexMetricCompression(this.complexMetricCompression);
        } else if (defaultSpec.complexMetricCompression != null) {
            bob.withComplexMetricCompression(defaultSpec.complexMetricCompression);
        }
        if (this.jsonCompression != null) {
            bob.withJsonCompression(this.jsonCompression);
        } else if (defaultSpec.jsonCompression != null) {
            bob.withJsonCompression(defaultSpec.jsonCompression);
        }
        if (this.segmentLoader != null) {
            bob.withSegmentLoader(this.segmentLoader);
        } else if (defaultSpec.segmentLoader != null) {
            bob.withSegmentLoader(defaultSpec.segmentLoader);
        }
        if (this.autoColumnFormatSpec != null) {
            bob.withAutoColumnFormatSpec(NestedCommonFormatColumnFormatSpec.getEffectiveFormatSpec(this.autoColumnFormatSpec, this));
        } else if (defaultSpec.autoColumnFormatSpec != null) {
            bob.withAutoColumnFormatSpec(NestedCommonFormatColumnFormatSpec.getEffectiveFormatSpec(defaultSpec.autoColumnFormatSpec, this));
        }
        return bob.build();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IndexSpec indexSpec = (IndexSpec)o;
        return Objects.equals(this.bitmapSerdeFactory, indexSpec.bitmapSerdeFactory) && this.dimensionCompression == indexSpec.dimensionCompression && Objects.equals(this.stringDictionaryEncoding, indexSpec.stringDictionaryEncoding) && this.metricCompression == indexSpec.metricCompression && this.longEncoding == indexSpec.longEncoding && Objects.equals((Object)this.complexMetricCompression, (Object)indexSpec.complexMetricCompression) && Objects.equals((Object)this.jsonCompression, (Object)indexSpec.jsonCompression) && Objects.equals(this.segmentLoader, indexSpec.segmentLoader) && Objects.equals(this.autoColumnFormatSpec, indexSpec.autoColumnFormatSpec);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.bitmapSerdeFactory, this.dimensionCompression, this.stringDictionaryEncoding, this.metricCompression, this.longEncoding, this.complexMetricCompression, this.jsonCompression, this.segmentLoader, this.autoColumnFormatSpec});
    }

    public String toString() {
        return "IndexSpec{bitmapSerdeFactory=" + String.valueOf(this.bitmapSerdeFactory) + ", dimensionCompression=" + String.valueOf((Object)this.dimensionCompression) + ", stringDictionaryEncoding=" + String.valueOf(this.stringDictionaryEncoding) + ", metricCompression=" + String.valueOf((Object)this.metricCompression) + ", longEncoding=" + String.valueOf((Object)this.longEncoding) + ", complexMetricCompression=" + String.valueOf((Object)this.complexMetricCompression) + ", autoColumnFormatSpec=" + String.valueOf(this.autoColumnFormatSpec) + ", jsonCompression=" + String.valueOf((Object)this.jsonCompression) + ", segmentLoader=" + String.valueOf(this.segmentLoader) + "}";
    }

    public static class Builder {
        @Nullable
        private BitmapSerdeFactory bitmapSerdeFactory;
        @Nullable
        private CompressionStrategy dimensionCompression;
        @Nullable
        private StringEncodingStrategy stringDictionaryEncoding;
        @Nullable
        private CompressionStrategy metricCompression;
        @Nullable
        private CompressionFactory.LongEncodingStrategy longEncoding;
        @Nullable
        private CompressionStrategy complexMetricCompression;
        @Nullable
        private CompressionStrategy jsonCompression;
        @Nullable
        private SegmentizerFactory segmentLoader;
        @Nullable
        private NestedCommonFormatColumnFormatSpec autoColumnFormatSpec;

        public Builder withBitmapSerdeFactory(@Nullable BitmapSerdeFactory bitmapSerdeFactory) {
            this.bitmapSerdeFactory = bitmapSerdeFactory;
            return this;
        }

        public Builder withDimensionCompression(@Nullable CompressionStrategy dimensionCompression) {
            this.dimensionCompression = dimensionCompression;
            return this;
        }

        public Builder withStringDictionaryEncoding(@Nullable StringEncodingStrategy stringDictionaryEncoding) {
            this.stringDictionaryEncoding = stringDictionaryEncoding;
            return this;
        }

        public Builder withMetricCompression(@Nullable CompressionStrategy metricCompression) {
            this.metricCompression = metricCompression;
            return this;
        }

        public Builder withComplexMetricCompression(@Nullable CompressionStrategy complexMetricCompression) {
            this.complexMetricCompression = complexMetricCompression;
            return this;
        }

        public Builder withLongEncoding(@Nullable CompressionFactory.LongEncodingStrategy longEncoding) {
            this.longEncoding = longEncoding;
            return this;
        }

        @Deprecated
        public Builder withJsonCompression(@Nullable CompressionStrategy jsonCompression) {
            this.jsonCompression = jsonCompression;
            return this;
        }

        public Builder withSegmentLoader(@Nullable SegmentizerFactory segmentLoader) {
            this.segmentLoader = segmentLoader;
            return this;
        }

        public Builder withAutoColumnFormatSpec(@Nullable NestedCommonFormatColumnFormatSpec autoColumnFormatSpec) {
            this.autoColumnFormatSpec = autoColumnFormatSpec;
            return this;
        }

        public IndexSpec build() {
            return new IndexSpec(this.bitmapSerdeFactory, this.dimensionCompression, this.stringDictionaryEncoding, this.metricCompression, this.longEncoding, this.complexMetricCompression, this.jsonCompression, this.segmentLoader, this.autoColumnFormatSpec);
        }
    }
}

