/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.java.util.http.client.response;

import java.io.InputStream;
import org.apache.druid.java.util.http.client.io.AppendableByteArrayInputStream;
import org.apache.druid.java.util.http.client.response.ClientResponse;
import org.apache.druid.java.util.http.client.response.HttpResponseHandler;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.handler.codec.http.HttpChunk;
import org.jboss.netty.handler.codec.http.HttpResponse;

public class InputStreamResponseHandler
implements HttpResponseHandler<AppendableByteArrayInputStream, InputStream> {
    @Override
    public ClientResponse<AppendableByteArrayInputStream> handleResponse(HttpResponse response, HttpResponseHandler.TrafficCop trafficCop) {
        AppendableByteArrayInputStream in = new AppendableByteArrayInputStream();
        in.add(this.getContentBytes(response.getContent()));
        return ClientResponse.finished(in);
    }

    @Override
    public ClientResponse<AppendableByteArrayInputStream> handleChunk(ClientResponse<AppendableByteArrayInputStream> clientResponse, HttpChunk chunk, long chunkNum) {
        clientResponse.getObj().add(this.getContentBytes(chunk.getContent()));
        return clientResponse;
    }

    @Override
    public ClientResponse<InputStream> done(ClientResponse<AppendableByteArrayInputStream> clientResponse) {
        AppendableByteArrayInputStream obj = clientResponse.getObj();
        obj.done();
        return ClientResponse.finished(obj);
    }

    @Override
    public void exceptionCaught(ClientResponse<AppendableByteArrayInputStream> clientResponse, Throwable e) {
        AppendableByteArrayInputStream obj = clientResponse.getObj();
        obj.exceptionCaught(e);
    }

    private byte[] getContentBytes(ChannelBuffer content) {
        byte[] contentBytes = new byte[content.readableBytes()];
        content.readBytes(contentBytes);
        return contentBytes;
    }
}

