/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.java.util.common.parsers;

import javax.annotation.Nullable;
import org.apache.druid.java.util.common.StringUtils;

public class ParseException
extends RuntimeException {
    private final boolean fromPartiallyValidRow;
    private final long timeOfExceptionMillis;
    private final String input;

    public ParseException(@Nullable String input, String formatText, Object ... arguments) {
        this(input, false, formatText, arguments);
    }

    public ParseException(@Nullable String input, boolean fromPartiallyValidRow, String formatText, Object ... arguments) {
        this(input, fromPartiallyValidRow, null, formatText, arguments);
    }

    public ParseException(@Nullable String input, Throwable cause, String formatText, Object ... arguments) {
        this(input, false, cause, formatText, arguments);
    }

    public ParseException(@Nullable String input, boolean fromPartiallyValidRow, Throwable cause, String formatText, Object ... arguments) {
        super(StringUtils.nonStrictFormat(formatText, arguments), cause);
        this.input = input;
        this.fromPartiallyValidRow = fromPartiallyValidRow;
        this.timeOfExceptionMillis = System.currentTimeMillis();
    }

    public boolean isFromPartiallyValidRow() {
        return this.fromPartiallyValidRow;
    }

    public long getTimeOfExceptionMillis() {
        return this.timeOfExceptionMillis;
    }

    @Nullable
    public String getInput() {
        return this.input;
    }
}

