/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.frame.write.cast;

import javax.annotation.Nullable;
import org.apache.druid.error.DruidException;
import org.apache.druid.frame.write.cast.ObjectToArrayColumnValueSelector;
import org.apache.druid.frame.write.cast.ObjectToNumberColumnValueSelector;
import org.apache.druid.math.expr.ExprEval;
import org.apache.druid.math.expr.ExpressionType;
import org.apache.druid.segment.ColumnSelectorFactory;
import org.apache.druid.segment.ColumnValueSelector;
import org.apache.druid.segment.RowIdSupplier;
import org.apache.druid.segment.column.ColumnCapabilities;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.ValueType;

public class TypeCastSelectors {
    public static ColumnValueSelector<?> makeColumnValueSelector(ColumnSelectorFactory columnSelectorFactory, String column, ColumnType desiredType) {
        ColumnValueSelector selector = columnSelectorFactory.makeColumnValueSelector(column);
        ColumnCapabilities selectorCapabilities = columnSelectorFactory.getColumnCapabilities(column);
        return TypeCastSelectors.wrapColumnValueSelectorIfNeeded(selector, selectorCapabilities, columnSelectorFactory.getRowIdSupplier(), desiredType);
    }

    public static ColumnValueSelector<?> wrapColumnValueSelectorIfNeeded(ColumnValueSelector<?> selector, @Nullable ColumnCapabilities selectorCapabilities, @Nullable RowIdSupplier rowIdSupplier, ColumnType desiredType) {
        ExpressionType desiredExpressionType = ExpressionType.fromColumnType(desiredType);
        if (desiredType.is(ValueType.STRING)) {
            throw DruidException.defensive("Type[%s] should be read using a DimensionSelector", desiredType);
        }
        if (desiredType.isNumeric() && (selectorCapabilities == null || !selectorCapabilities.isNumeric())) {
            return new ObjectToNumberColumnValueSelector(selector, desiredExpressionType, rowIdSupplier);
        }
        if (desiredType.isArray()) {
            return new ObjectToArrayColumnValueSelector(selector, desiredExpressionType, rowIdSupplier);
        }
        return selector;
    }

    @Nullable
    public static Object bestEffortCoerce(@Nullable Object obj, @Nullable ExpressionType desiredType) {
        if (obj == null || desiredType == null) {
            return obj;
        }
        return ExprEval.ofType(desiredType, obj).value();
    }
}

