/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.topn;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.query.topn.DimensionAndMetricValueExtractor;

public class TopNResultValue
implements Iterable<DimensionAndMetricValueExtractor> {
    private final List<DimensionAndMetricValueExtractor> valueList;

    @JsonCreator
    public static TopNResultValue create(List<?> value) {
        if (value == null) {
            return new TopNResultValue(new ArrayList<DimensionAndMetricValueExtractor>());
        }
        return new TopNResultValue(Lists.transform(value, input -> {
            if (input instanceof Map) {
                return new DimensionAndMetricValueExtractor((Map)input);
            }
            if (input instanceof DimensionAndMetricValueExtractor) {
                return (DimensionAndMetricValueExtractor)input;
            }
            throw new IAE("Unknown type for input[%s]", input.getClass());
        }));
    }

    public TopNResultValue(List<DimensionAndMetricValueExtractor> valueList) {
        this.valueList = valueList;
    }

    @JsonValue
    public List<DimensionAndMetricValueExtractor> getValue() {
        return this.valueList;
    }

    @Override
    public Iterator<DimensionAndMetricValueExtractor> iterator() {
        return this.valueList.iterator();
    }

    public String toString() {
        return "TopNResultValue{valueList=" + this.valueList + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TopNResultValue that = (TopNResultValue)o;
        return Objects.equals(this.valueList, that.valueList);
    }

    public int hashCode() {
        return this.valueList != null ? this.valueList.hashCode() : 0;
    }
}

