/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.loading;

import com.fasterxml.jackson.annotation.JsonTypeName;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import org.apache.druid.segment.loading.LoadSpec;
import org.apache.druid.segment.loading.SegmentLoadingException;

@JsonTypeName(value="tombstone")
public class TombstoneLoadSpec
implements LoadSpec {
    @Override
    public LoadSpec.LoadSpecResult loadSegment(File destDir) throws SegmentLoadingException {
        try {
            return new LoadSpec.LoadSpecResult(TombstoneLoadSpec.writeFactoryFile(destDir));
        }
        catch (IOException e) {
            throw new SegmentLoadingException("Failed to create factory.json for tombstone in dir [%s]", destDir.getAbsolutePath());
        }
    }

    @VisibleForTesting
    public static int writeFactoryFile(File destDir) throws IOException {
        String factoryJSONString = "{\"type\":\"tombstoneSegmentFactory\"}";
        File factoryJson = new File(destDir, "factory.json");
        factoryJson.createNewFile();
        Files.write((byte[])"{\"type\":\"tombstoneSegmentFactory\"}".getBytes(StandardCharsets.UTF_8), (File)factoryJson);
        return "{\"type\":\"tombstoneSegmentFactory\"}".length();
    }
}

