/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.data;

import java.io.Closeable;
import javax.annotation.Nullable;
import org.apache.druid.collections.bitmap.ImmutableBitmap;
import org.apache.druid.query.monomorphicprocessing.RuntimeShapeInspector;
import org.apache.druid.segment.ColumnValueSelector;
import org.apache.druid.segment.LongColumnSelector;
import org.apache.druid.segment.data.ReadableOffset;
import org.apache.druid.segment.historical.HistoricalColumnSelector;
import org.apache.druid.segment.vector.BaseLongVectorValueSelector;
import org.apache.druid.segment.vector.ReadableVectorOffset;
import org.apache.druid.segment.vector.VectorSelectorUtils;
import org.apache.druid.segment.vector.VectorValueSelector;
import org.roaringbitmap.PeekableIntIterator;

public interface ColumnarLongs
extends Closeable {
    public int size();

    public long get(int var1);

    default public void get(long[] out, int start, int length) {
        this.get(out, 0, start, length);
    }

    default public void get(long[] out, int offset, int start, int length) {
        for (int i = 0; i < length; ++i) {
            out[offset + i] = this.get(i + start);
        }
    }

    default public void get(long[] out, int[] indexes, int length) {
        for (int i = 0; i < length; ++i) {
            out[i] = this.get(indexes[i]);
        }
    }

    @Override
    public void close();

    @Nullable
    default public <T> T as(Class<? extends T> clazz) {
        return null;
    }

    default public ColumnValueSelector<Long> makeColumnValueSelector(final ReadableOffset offset, final ImmutableBitmap nullValueBitmap) {
        if (nullValueBitmap.isEmpty()) {
            class HistoricalLongColumnSelector
            implements LongColumnSelector,
            HistoricalColumnSelector<Long> {
                HistoricalLongColumnSelector() {
                }

                @Override
                public boolean isNull() {
                    return false;
                }

                @Override
                public long getLong() {
                    return ColumnarLongs.this.get(offset.getOffset());
                }

                @Override
                public double getDouble(int offset2) {
                    return ColumnarLongs.this.get(offset2);
                }

                @Override
                public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
                    inspector.visit("columnar", ColumnarLongs.this);
                    inspector.visit("offset", offset);
                }
            }
            return new HistoricalLongColumnSelector();
        }
        class HistoricalLongColumnSelectorWithNulls
        implements LongColumnSelector,
        HistoricalColumnSelector<Long> {
            private PeekableIntIterator nullIterator;
            private int nullMark;
            private int offsetMark;

            HistoricalLongColumnSelectorWithNulls() {
                this.nullIterator = nullValueBitmap.peekableIterator();
                this.nullMark = -1;
                this.offsetMark = -1;
            }

            @Override
            public boolean isNull() {
                int i = offset.getOffset();
                if (i < this.offsetMark) {
                    this.nullMark = -1;
                    this.nullIterator = nullValueBitmap.peekableIterator();
                }
                this.offsetMark = i;
                if (this.nullMark < i) {
                    this.nullIterator.advanceIfNeeded(this.offsetMark);
                    if (this.nullIterator.hasNext()) {
                        this.nullMark = this.nullIterator.next();
                    }
                }
                return this.nullMark == this.offsetMark;
            }

            @Override
            public long getLong() {
                assert (!this.isNull());
                return ColumnarLongs.this.get(offset.getOffset());
            }

            @Override
            public double getDouble(int offset2) {
                assert (!nullValueBitmap.get(offset2));
                return ColumnarLongs.this.get(offset2);
            }

            @Override
            public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
                inspector.visit("columnar", ColumnarLongs.this);
                inspector.visit("offset", offset);
                inspector.visit("nullValueBitmap", nullValueBitmap);
            }
        }
        return new HistoricalLongColumnSelectorWithNulls();
    }

    default public VectorValueSelector makeVectorValueSelector(final ReadableVectorOffset theOffset, final ImmutableBitmap nullValueBitmap) {
        class ColumnarLongsVectorValueSelector
        extends BaseLongVectorValueSelector {
            private final long[] longVector;
            private int id;
            private PeekableIntIterator nullIterator;
            private int offsetMark;
            @Nullable
            private boolean[] nullVector;

            private ColumnarLongsVectorValueSelector() {
                super(readableVectorOffset);
                this.id = -1;
                this.nullIterator = nullValueBitmap.peekableIterator();
                this.offsetMark = -1;
                this.nullVector = null;
                this.longVector = new long[this.offset.getMaxVectorSize()];
            }

            @Override
            @Nullable
            public boolean[] getNullVector() {
                this.computeVectorsIfNeeded();
                return this.nullVector;
            }

            @Override
            public long[] getLongVector() {
                this.computeVectorsIfNeeded();
                return this.longVector;
            }

            private void computeVectorsIfNeeded() {
                if (this.id == this.offset.getId()) {
                    return;
                }
                if (this.offset.isContiguous()) {
                    if (this.offset.getStartOffset() < this.offsetMark) {
                        this.nullIterator = nullValueBitmap.peekableIterator();
                    }
                    this.offsetMark = this.offset.getStartOffset() + this.offset.getCurrentVectorSize();
                    ColumnarLongs.this.get(this.longVector, this.offset.getStartOffset(), this.offset.getCurrentVectorSize());
                } else {
                    int[] offsets = this.offset.getOffsets();
                    if (offsets[offsets.length - 1] < this.offsetMark) {
                        this.nullIterator = nullValueBitmap.peekableIterator();
                    }
                    this.offsetMark = offsets[offsets.length - 1];
                    ColumnarLongs.this.get(this.longVector, offsets, this.offset.getCurrentVectorSize());
                }
                this.nullVector = VectorSelectorUtils.populateNullVector(this.nullVector, this.offset, this.nullIterator);
                this.id = this.offset.getId();
            }
        }
        return new ColumnarLongsVectorValueSelector();
    }
}

