/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment;

import com.google.common.primitives.Ints;
import it.unimi.dsi.fastutil.ints.IntArrays;
import java.util.Arrays;
import java.util.BitSet;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.druid.collections.bitmap.BitmapFactory;
import org.apache.druid.collections.bitmap.MutableBitmap;
import org.apache.druid.data.input.impl.DimensionSchema;
import org.apache.druid.error.DruidException;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.guava.Comparators;
import org.apache.druid.math.expr.Evals;
import org.apache.druid.query.dimension.DimensionSpec;
import org.apache.druid.query.extraction.ExtractionFn;
import org.apache.druid.query.filter.DruidObjectPredicate;
import org.apache.druid.query.filter.DruidPredicateFactory;
import org.apache.druid.query.filter.DruidPredicateMatch;
import org.apache.druid.query.filter.StringPredicateDruidPredicateFactory;
import org.apache.druid.query.filter.ValueMatcher;
import org.apache.druid.query.monomorphicprocessing.RuntimeShapeInspector;
import org.apache.druid.segment.DictionaryEncodedColumnIndexer;
import org.apache.druid.segment.DimensionSelector;
import org.apache.druid.segment.EncodedKeyComponent;
import org.apache.druid.segment.IdLookup;
import org.apache.druid.segment.StringDimensionDictionary;
import org.apache.druid.segment.column.ColumnCapabilities;
import org.apache.druid.segment.column.ColumnCapabilitiesImpl;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.data.ArrayBasedIndexedInts;
import org.apache.druid.segment.data.IndexedInts;
import org.apache.druid.segment.incremental.IncrementalIndex;
import org.apache.druid.segment.incremental.IncrementalIndexRow;
import org.apache.druid.segment.incremental.IncrementalIndexRowHolder;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;

public class StringDimensionIndexer
extends DictionaryEncodedColumnIndexer<int[], String> {
    private final DimensionSchema.MultiValueHandling multiValueHandling;
    private final boolean hasBitmapIndexes;
    private final boolean hasSpatialIndexes;
    private volatile boolean hasMultipleValues = false;

    public StringDimensionIndexer(@Nullable DimensionSchema.MultiValueHandling multiValueHandling, boolean hasBitmapIndexes, boolean hasSpatialIndexes) {
        super(new StringDimensionDictionary());
        this.multiValueHandling = multiValueHandling == null ? DimensionSchema.MultiValueHandling.ofDefault() : multiValueHandling;
        this.hasBitmapIndexes = hasBitmapIndexes;
        this.hasSpatialIndexes = hasSpatialIndexes;
    }

    @Override
    public EncodedKeyComponent<int[]> processRowValsToUnsortedEncodedKeyComponent(@Nullable Object dimValues, boolean reportParseExceptions) {
        int[] encodedDimensionValues;
        int oldDictSize = this.dimLookup.size();
        long oldDictSizeInBytes = this.dimLookup.sizeInBytes();
        if (dimValues instanceof Object[]) {
            dimValues = Arrays.asList((Object[])dimValues);
        }
        if (dimValues == null) {
            int[] nArray;
            int nullId = this.dimLookup.getId(null);
            if (nullId == -1) {
                int[] nArray2 = new int[1];
                nArray = nArray2;
                nArray2[0] = this.dimLookup.add(null);
            } else {
                int[] nArray3 = new int[1];
                nArray = nArray3;
                nArray3[0] = nullId;
            }
            encodedDimensionValues = nArray;
        } else if (dimValues instanceof List) {
            List<Object> dimValuesList = dimValues;
            if (dimValuesList.isEmpty()) {
                this.dimLookup.add(null);
                encodedDimensionValues = IntArrays.EMPTY_ARRAY;
            } else if (dimValuesList.size() == 1) {
                encodedDimensionValues = new int[]{this.dimLookup.add(Evals.asString(dimValuesList.get(0)))};
            } else {
                this.hasMultipleValues = true;
                String[] dimensionValues = new String[dimValuesList.size()];
                for (int i = 0; i < dimValuesList.size(); ++i) {
                    dimensionValues[i] = Evals.asString(dimValuesList.get(i));
                }
                if (this.multiValueHandling.needSorting()) {
                    Arrays.sort(dimensionValues, Comparators.naturalNullsFirst());
                }
                int[] retVal = new int[dimensionValues.length];
                int prevId = -1;
                int pos = 0;
                for (String dimensionValue : dimensionValues) {
                    if (this.multiValueHandling != DimensionSchema.MultiValueHandling.SORTED_SET) {
                        retVal[pos++] = this.dimLookup.add(dimensionValue);
                        continue;
                    }
                    int index = this.dimLookup.add(dimensionValue);
                    if (index == prevId) continue;
                    int n = pos++;
                    int n2 = index;
                    retVal[n] = n2;
                    prevId = n2;
                }
                encodedDimensionValues = pos == retVal.length ? retVal : Arrays.copyOf(retVal, pos);
            }
        } else {
            encodedDimensionValues = dimValues instanceof byte[] ? new int[]{this.dimLookup.add(Evals.asString(StringUtils.encodeBase64String((byte[])dimValues)))} : new int[]{this.dimLookup.add(Evals.asString(dimValues))};
        }
        if (oldDictSize != this.dimLookup.size()) {
            this.sortedLookup = null;
        }
        long effectiveSizeBytes = 16L + (long)encodedDimensionValues.length * 4L + (this.dimLookup.sizeInBytes() - oldDictSizeInBytes);
        return new EncodedKeyComponent<int[]>(encodedDimensionValues, effectiveSizeBytes);
    }

    public long estimateEncodedKeyComponentSize(int[] keys) {
        String[] vals;
        long estimatedSize = keys.length * 4;
        for (String val : vals = (String[])this.dimLookup.getValues(keys)) {
            if (val == null) continue;
            int sizeOfString = 44 + 2 * val.length();
            estimatedSize += (long)sizeOfString;
        }
        return estimatedSize;
    }

    @Override
    public int compareUnsortedEncodedKeyComponents(int[] lhs, int[] rhs) {
        int lhsLen = lhs.length;
        int rhsLen = rhs.length;
        int lenCompareResult = Ints.compare((int)lhsLen, (int)rhsLen);
        if (lenCompareResult != 0 && lhsLen + rhsLen == 1) {
            int[] longerVal;
            int[] nArray = longerVal = rhsLen > lhsLen ? rhs : lhs;
            if (longerVal[0] == this.dimLookup.getIdForNull()) {
                return 0;
            }
            return longerVal == lhs ? 1 : -1;
        }
        int lenToCompare = Math.min(lhsLen, rhsLen);
        for (int valsIndex = 0; valsIndex < lenToCompare; ++valsIndex) {
            int lhsVal = lhs[valsIndex];
            int rhsVal = rhs[valsIndex];
            if (lhsVal == rhsVal) continue;
            String lhsValActual = (String)this.getActualValue(lhsVal, false);
            String rhsValActual = (String)this.getActualValue(rhsVal, false);
            int valueCompareResult = 0;
            if (lhsValActual != null && rhsValActual != null) {
                valueCompareResult = lhsValActual.compareTo(rhsValActual);
            } else if (lhsValActual == null ^ rhsValActual == null) {
                int n = valueCompareResult = lhsValActual == null ? -1 : 1;
            }
            if (valueCompareResult == 0) continue;
            return valueCompareResult;
        }
        return lenCompareResult;
    }

    @Override
    public boolean checkUnsortedEncodedKeyComponentsEqual(int[] lhs, int[] rhs) {
        return Arrays.equals(lhs, rhs);
    }

    @Override
    public int getUnsortedEncodedKeyComponentHashCode(int[] key) {
        return Arrays.hashCode(key);
    }

    @Override
    public ColumnCapabilities getColumnCapabilities() {
        ColumnCapabilitiesImpl capabilites = new ColumnCapabilitiesImpl().setType(ColumnType.STRING).setHasBitmapIndexes(this.hasBitmapIndexes).setHasSpatialIndexes(this.hasSpatialIndexes).setDictionaryEncoded(true).setDictionaryValuesUnique(true).setDictionaryValuesSorted(false);
        if (this.hasMultipleValues) {
            capabilites.setHasMultipleValues(true);
        }
        if (this.dimLookup.getIdForNull() != -1) {
            capabilites.setHasNulls(true);
        }
        return capabilites;
    }

    @Override
    public DimensionSelector makeDimensionSelector(DimensionSpec spec, final IncrementalIndexRowHolder currEntry, IncrementalIndex.DimensionDesc desc) {
        final ExtractionFn extractionFn = spec.getExtractionFn();
        final int dimIndex = desc.getIndex();
        final int maxId = this.getCardinality();
        class IndexerDimensionSelector
        implements DimensionSelector,
        IdLookup {
            private final ArrayBasedIndexedInts indexedInts = new ArrayBasedIndexedInts();
            @Nullable
            private @MonotonicNonNull int[] nullIdIntArray;

            IndexerDimensionSelector() {
            }

            @Override
            public IndexedInts getRow() {
                Object[] dims = currEntry.get().getDims();
                int[] indices = dimIndex < dims.length ? (int[])dims[dimIndex] : null;
                int[] row = null;
                int rowSize = 0;
                if (indices == null || indices.length == 0) {
                    if (StringDimensionIndexer.this.hasMultipleValues) {
                        row = IntArrays.EMPTY_ARRAY;
                    } else {
                        int nullId = StringDimensionIndexer.this.getEncodedValue(null, false);
                        DruidException.conditionalDefensive(nullId >= 0 && nullId < maxId, "Null value not present in dictionary, how did this happen?", new Object[0]);
                        if (this.nullIdIntArray == null) {
                            this.nullIdIntArray = new int[]{nullId};
                        }
                        row = this.nullIdIntArray;
                        rowSize = 1;
                    }
                } else {
                    row = indices;
                    rowSize = indices.length;
                }
                this.indexedInts.setValues(row, rowSize);
                return this.indexedInts;
            }

            @Override
            public ValueMatcher makeValueMatcher(final @Nullable String value) {
                if (extractionFn != null) {
                    return this.makeValueMatcher(StringPredicateDruidPredicateFactory.equalTo(value));
                }
                final int valueId = this.lookupId(value);
                final int nullValueId = this.lookupId(null);
                if (valueId >= 0 || value == null) {
                    return new ValueMatcher(){

                        @Override
                        public boolean matches(boolean includeUnknown) {
                            Object[] dims = currEntry.get().getDims();
                            if (dimIndex >= dims.length) {
                                return includeUnknown || value == null;
                            }
                            int[] dimsInt = (int[])dims[dimIndex];
                            if (dimsInt == null || dimsInt.length == 0) {
                                return includeUnknown || value == null;
                            }
                            for (int id : dimsInt) {
                                if (id == valueId) {
                                    return true;
                                }
                                if (!includeUnknown || id != nullValueId) continue;
                                return true;
                            }
                            return false;
                        }

                        @Override
                        public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
                        }
                    };
                }
                return new ValueMatcher(){

                    @Override
                    public boolean matches(boolean includeUnknown) {
                        if (includeUnknown) {
                            IndexedInts row = this.getRow();
                            int size = row.size();
                            if (size == 0) {
                                return true;
                            }
                            for (int i = 0; i < size; ++i) {
                                if (row.get(i) != nullValueId) continue;
                                return true;
                            }
                        }
                        return false;
                    }

                    @Override
                    public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
                    }
                };
            }

            @Override
            public ValueMatcher makeValueMatcher(DruidPredicateFactory predicateFactory) {
                final BitSet checkedIds = new BitSet(maxId);
                final BitSet matchingIds = new BitSet(maxId);
                final DruidObjectPredicate<String> predicate = predicateFactory.makeStringPredicate();
                return new ValueMatcher(){

                    @Override
                    public boolean matches(boolean includeUnknown) {
                        Object[] dims = currEntry.get().getDims();
                        if (dimIndex >= dims.length) {
                            return predicate.apply(null).matches(includeUnknown);
                        }
                        int[] dimsInt = (int[])dims[dimIndex];
                        if (dimsInt == null || dimsInt.length == 0) {
                            return predicate.apply(null).matches(includeUnknown);
                        }
                        for (int id : dimsInt) {
                            if (checkedIds.get(id)) {
                                if (!matchingIds.get(id)) continue;
                                return true;
                            }
                            DruidPredicateMatch matches = predicate.apply(this.lookupName(id));
                            checkedIds.set(id);
                            if (!matches.matches(includeUnknown)) continue;
                            matchingIds.set(id);
                            return true;
                        }
                        return false;
                    }

                    @Override
                    public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
                    }
                };
            }

            @Override
            public int getValueCardinality() {
                return maxId;
            }

            @Override
            public String lookupName(int id) {
                if (id >= maxId) {
                    throw new ISE("id[%d] >= maxId[%d]", id, maxId);
                }
                String strValue = (String)StringDimensionIndexer.this.getActualValue(id, false);
                return extractionFn == null ? strValue : extractionFn.apply(strValue);
            }

            @Override
            public boolean nameLookupPossibleInAdvance() {
                return true;
            }

            @Override
            @Nullable
            public IdLookup idLookup() {
                return extractionFn == null ? this : null;
            }

            @Override
            public int lookupId(@Nullable String name) {
                if (extractionFn != null) {
                    throw new UnsupportedOperationException("cannot perform lookup when applying an extraction function");
                }
                int id = StringDimensionIndexer.this.getEncodedValue(name, false);
                if (id < maxId) {
                    return id;
                }
                return -1;
            }

            @Override
            @Nullable
            public Object getObject() {
                IncrementalIndexRow key = currEntry.get();
                if (key == null) {
                    return null;
                }
                Object[] dims = key.getDims();
                if (dimIndex >= dims.length) {
                    return null;
                }
                return StringDimensionIndexer.this.convertUnsortedEncodedKeyComponentToActualList((int[])dims[dimIndex]);
            }

            @Override
            public Class classOfObject() {
                return Object.class;
            }

            @Override
            public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
            }
        }
        return new IndexerDimensionSelector();
    }

    @Override
    @Nullable
    public Object convertUnsortedEncodedKeyComponentToActualList(int[] key) {
        if (key == null || key.length == 0) {
            return null;
        }
        if (key.length == 1) {
            return this.getActualValue(key[0], false);
        }
        String[] rowArray = new String[key.length];
        for (int i = 0; i < key.length; ++i) {
            String val;
            rowArray[i] = val = (String)this.getActualValue(key[i], false);
        }
        return Arrays.asList(rowArray);
    }

    @Override
    public void fillBitmapsFromUnsortedEncodedKeyComponent(int[] key, int rowNum, MutableBitmap[] bitmapIndexes, BitmapFactory factory) {
        if (!this.hasBitmapIndexes) {
            throw new UnsupportedOperationException("This column does not include bitmap indexes");
        }
        for (int dimValIdx : key) {
            if (bitmapIndexes[dimValIdx] == null) {
                bitmapIndexes[dimValIdx] = factory.makeEmptyMutableBitmap();
            }
            bitmapIndexes[dimValIdx].add(rowNum);
        }
    }
}

