/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.groupby.epinephelinae.vector;

import org.apache.datasketches.memory.WritableMemory;
import org.apache.druid.query.groupby.ResultRow;
import org.apache.druid.query.groupby.epinephelinae.collection.MemoryPointer;
import org.apache.druid.query.groupby.epinephelinae.vector.GroupByVectorColumnSelector;
import org.apache.druid.segment.vector.VectorValueSelector;

public class NullableDoubleGroupByVectorColumnSelector
implements GroupByVectorColumnSelector {
    private final VectorValueSelector selector;

    NullableDoubleGroupByVectorColumnSelector(VectorValueSelector selector) {
        this.selector = selector;
    }

    @Override
    public int getGroupingKeySize() {
        return 9;
    }

    @Override
    public int writeKeys(WritableMemory keySpace, int keySize, int keyOffset, int startRow, int endRow) {
        double[] vector = this.selector.getDoubleVector();
        boolean[] nulls = this.selector.getNullVector();
        if (nulls != null) {
            int i = startRow;
            int j = keyOffset;
            while (i < endRow) {
                keySpace.putByte((long)j, nulls[i] ? (byte)1 : 0);
                keySpace.putDouble((long)(j + 1), vector[i]);
                ++i;
                j += keySize;
            }
        } else {
            int i = startRow;
            int j = keyOffset;
            while (i < endRow) {
                keySpace.putByte((long)j, (byte)0);
                keySpace.putDouble((long)(j + 1), vector[i]);
                ++i;
                j += keySize;
            }
        }
        return 0;
    }

    @Override
    public void writeKeyToResultRow(MemoryPointer keyMemory, int keyOffset, ResultRow resultRow, int resultRowPosition) {
        if (keyMemory.memory().getByte(keyMemory.position() + (long)keyOffset) == 1) {
            resultRow.set(resultRowPosition, null);
        } else {
            resultRow.set(resultRowPosition, keyMemory.memory().getDouble(keyMemory.position() + (long)keyOffset + 1L));
        }
    }

    @Override
    public void reset() {
    }
}

