/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Comparator;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.base.AbstractInstant;

public class Result<T>
implements Comparable<Result<T>> {
    private final DateTime timestamp;
    private final T value;

    @JsonCreator
    public Result(@JsonProperty(value="timestamp") @Nullable DateTime timestamp, @JsonProperty(value="result") T value) {
        this.timestamp = timestamp;
        this.value = value;
    }

    public <U> Result<U> map(Function<? super T, ? extends U> mapper) {
        return new Result<U>(this.timestamp, mapper.apply(this.value));
    }

    @Override
    public int compareTo(Result<T> tResult) {
        return Comparator.nullsLast(AbstractInstant::compareTo).compare(this.timestamp, tResult.timestamp);
    }

    @JsonProperty
    @Nullable
    public DateTime getTimestamp() {
        return this.timestamp;
    }

    @JsonProperty(value="result")
    public T getValue() {
        return this.value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Result result = (Result)o;
        if (this.timestamp != null && result.timestamp != null ? !this.timestamp.isEqual((ReadableInstant)result.timestamp) && this.timestamp.getZone().getOffset((ReadableInstant)this.timestamp) == result.timestamp.getZone().getOffset((ReadableInstant)result.timestamp) : this.timestamp == null ^ result.timestamp == null) {
            return false;
        }
        return Objects.equals(this.value, result.value);
    }

    public int hashCode() {
        return Objects.hash(this.timestamp, this.value);
    }

    public String toString() {
        return "Result{timestamp=" + String.valueOf(this.timestamp) + ", value=" + String.valueOf(this.value) + "}";
    }
}

