/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.math.expr.vector;

import org.apache.druid.math.expr.Expr;
import org.apache.druid.math.expr.ExpressionType;
import org.apache.druid.math.expr.vector.ExprEvalLongVector;
import org.apache.druid.math.expr.vector.ExprEvalVector;
import org.apache.druid.math.expr.vector.ExprVectorProcessor;
import org.apache.druid.math.expr.vector.NvlFunctionVectorProcessor;

public final class NvlLongVectorProcessor
extends NvlFunctionVectorProcessor<long[]> {
    private final long[] output;
    private final boolean[] outputNulls;

    public NvlLongVectorProcessor(ExprVectorProcessor<long[]> inputProcessor, ExprVectorProcessor<long[]> elseProcessor) {
        super(ExpressionType.LONG, inputProcessor, elseProcessor);
        this.output = new long[inputProcessor.maxVectorSize()];
        this.outputNulls = new boolean[inputProcessor.maxVectorSize()];
    }

    @Override
    public ExprEvalVector<long[]> evalVector(Expr.VectorInputBinding bindings) {
        this.inputBindingFilterer.setBindings(bindings);
        ExprEvalVector<long[]> inputVector = this.inputProcessor.evalVector(bindings);
        if (inputVector.getNullVector() == null) {
            return inputVector;
        }
        long[] inputValues = inputVector.getLongVector();
        boolean[] inputNulls = inputVector.getNullVector();
        int[] selection = this.inputBindingFilterer.getVectorMatch().getSelection();
        int nulls = 0;
        for (int i = 0; i < bindings.getCurrentVectorSize(); ++i) {
            if (inputNulls[i]) {
                selection[nulls++] = i;
                continue;
            }
            this.outputNulls[i] = false;
            this.output[i] = inputValues[i];
        }
        this.inputBindingFilterer.getVectorMatch().setSelectionSize(nulls);
        if (nulls == 0) {
            return new ExprEvalLongVector(this.output, this.outputNulls);
        }
        if (nulls == bindings.getCurrentVectorSize()) {
            return this.elseProcessor.evalVector(bindings);
        }
        ExprEvalVector elseVector = this.elseProcessor.evalVector(this.inputBindingFilterer);
        long[] elseValues = elseVector.getLongVector();
        boolean[] elseNulls = elseVector.getNullVector();
        for (int i = 0; i < nulls; ++i) {
            int outIndex = selection[i];
            if (elseNulls != null && elseNulls[i]) {
                this.outputNulls[outIndex] = true;
                continue;
            }
            this.output[outIndex] = elseValues[i];
            this.outputNulls[outIndex] = false;
        }
        return new ExprEvalLongVector(this.output, this.outputNulls);
    }
}

