/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.serde.cell;

import com.google.common.primitives.Ints;
import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import javax.annotation.Nonnull;
import org.apache.druid.segment.serde.cell.BlockCompressedPayloadReader;
import org.apache.druid.segment.serde.cell.PayloadEntrySpan;

public class CellIndexReader
implements Closeable {
    private final BlockCompressedPayloadReader payloadReader;

    public CellIndexReader(BlockCompressedPayloadReader payloadReader) {
        this.payloadReader = payloadReader;
    }

    @Nonnull
    public PayloadEntrySpan getEntrySpan(int entryNumber) {
        int position = entryNumber * 8;
        ByteBuffer payload = this.payloadReader.read(position, 16);
        long payloadValue = payload.getLong();
        long nextPayloadValue = payload.getLong();
        return new PayloadEntrySpan(payloadValue, Ints.checkedCast((long)(nextPayloadValue - payloadValue)));
    }

    @Override
    public void close() throws IOException {
        this.payloadReader.close();
    }
}

